/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.presentation;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.stp.sca.DocumentRoot;
import org.eclipse.stp.sca.ScaFactory;
import org.eclipse.stp.sca.ScaPackage;
import org.eclipse.stp.sca.presentation.ScaEditorPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScaModelWizard
extends Wizard
implements INewWizard {
    public static final List<String> FILE_EXTENSIONS = Collections.unmodifiableList(Arrays.asList(ScaEditorPlugin.INSTANCE.getString("_UI_ScaEditorFilenameExtensions").split("\\s*,\\s*")));
    public static final String FORMATTED_FILE_EXTENSIONS = ScaEditorPlugin.INSTANCE.getString("_UI_ScaEditorFilenameExtensions").replaceAll("\\s*,\\s*", ", ");
    protected ScaPackage scaPackage = ScaPackage.eINSTANCE;
    protected ScaFactory scaFactory = this.scaPackage.getScaFactory();
    protected ScaModelWizardNewFileCreationPage newFileCreationPage;
    protected ScaModelWizardInitialObjectCreationPage initialObjectCreationPage;
    protected IStructuredSelection selection;
    protected IWorkbench workbench;
    protected List<String> initialObjectNames;
    private IConfigurationElement configurationElement;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle(ScaEditorPlugin.INSTANCE.getString("_UI_Wizard_label"));
        this.setDefaultPageImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(ScaEditorPlugin.INSTANCE.getImage("full/wizban/NewSca")));
    }

    protected Collection<String> getInitialObjectNames() {
        return null;
    }

    protected EObject createInitialModel() {
        String compositeName;
        DocumentRoot docRoot;
        EClass eClass = ExtendedMetaData.INSTANCE.getDocumentRoot((EPackage)this.scaPackage);
        EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature("composite");
        EObject rootObject = this.scaFactory.create(eClass);
        rootObject.eSet(eStructuralFeature, (Object)EcoreUtil.create((EClass)((EClass)eStructuralFeature.getEType())));
        if (rootObject instanceof DocumentRoot && (docRoot = (DocumentRoot)rootObject).getComposite() != null && (compositeName = this.getModelFile().getName()) != null) {
            compositeName = compositeName.replace(".composite", "");
            docRoot.getComposite().setName(compositeName);
            String tns = "http://eclipse.org" + this.getModelFile().getFullPath().toString();
            tns = tns.replace(".composite", "");
            docRoot.getComposite().setTargetNamespace(tns);
        }
        return rootObject;
    }

    public boolean performFinish() {
        try {
            final IFile modelFile = this.getModelFile();
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor progressMonitor) {
                    try {
                        try {
                            ResourceSetImpl resourceSet = new ResourceSetImpl();
                            URI fileURI = URI.createPlatformResourceURI((String)modelFile.getFullPath().toString(), (boolean)true);
                            Resource resource = resourceSet.createResource(fileURI);
                            EObject rootObject = ScaModelWizard.this.createInitialModel();
                            if (rootObject != null) {
                                resource.getContents().add((Object)rootObject);
                            }
                            HashMap<String, String> options = new HashMap<String, String>();
                            options.put("ENCODING", "UTF-8");
                            resource.save(options);
                        }
                        catch (Exception exception) {
                            ScaEditorPlugin.INSTANCE.log(exception);
                            progressMonitor.done();
                        }
                    }
                    finally {
                        progressMonitor.done();
                    }
                }
            };
            this.getContainer().run(false, false, (IRunnableWithProgress)operation);
            IWorkbenchWindow workbenchWindow = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = workbenchWindow.getActivePage();
            final IWorkbenchPart activePart = page.getActivePart();
            if (activePart instanceof ISetSelectionTarget) {
                StructuredSelection targetSelection = new StructuredSelection((Object)modelFile);
                this.getShell().getDisplay().asyncExec(new Runnable((ISelection)targetSelection){
                    private final /* synthetic */ ISelection val$targetSelection;
                    {
                        this.val$targetSelection = iSelection;
                    }

                    public void run() {
                        ((ISetSelectionTarget)activePart).selectReveal(this.val$targetSelection);
                    }
                });
            }
            try {
                page.openEditor((IEditorInput)new FileEditorInput(modelFile), this.workbench.getEditorRegistry().getDefaultEditor(modelFile.getFullPath().toString()).getId());
            }
            catch (PartInitException exception) {
                MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)ScaEditorPlugin.INSTANCE.getString("_UI_OpenEditorError_label"), (String)exception.getMessage());
                return false;
            }
        }
        catch (Exception exception) {
            ScaEditorPlugin.INSTANCE.log(exception);
            return false;
        }
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.configurationElement);
        return true;
    }

    public void addPages() {
        Object selectedElement;
        this.newFileCreationPage = new ScaModelWizardNewFileCreationPage("Whatever", this.selection);
        this.newFileCreationPage.setTitle(ScaEditorPlugin.INSTANCE.getString("_UI_ScaModelWizard_label"));
        this.newFileCreationPage.setDescription(ScaEditorPlugin.INSTANCE.getString("_UI_ScaModelWizard_description"));
        this.newFileCreationPage.setFileName(String.valueOf(ScaEditorPlugin.INSTANCE.getString("_UI_ScaEditorFilenameDefaultBase")) + "." + ScaEditorPlugin.INSTANCE.getString("_UI_ScaEditorFilenameExtension"));
        this.addPage((IWizardPage)this.newFileCreationPage);
        if (this.selection != null && !this.selection.isEmpty() && (selectedElement = this.selection.iterator().next()) instanceof IResource) {
            IResource selectedResource = (IResource)selectedElement;
            if (selectedResource.getType() == 1) {
                selectedResource = selectedResource.getParent();
            }
            if (selectedResource instanceof IFolder || selectedResource instanceof IProject) {
                this.newFileCreationPage.setContainerFullPath(selectedResource.getFullPath());
                String defaultModelBaseFilename = ScaEditorPlugin.INSTANCE.getString("_UI_ScaEditorFilenameDefaultBase");
                String defaultModelFilenameExtension = ScaEditorPlugin.INSTANCE.getString("_UI_ScaEditorFilenameExtension");
                String modelFilename = String.valueOf(defaultModelBaseFilename) + "." + defaultModelFilenameExtension;
                int i = 1;
                while (((IContainer)selectedResource).findMember(modelFilename) != null) {
                    modelFilename = String.valueOf(defaultModelBaseFilename) + i + "." + defaultModelFilenameExtension;
                    ++i;
                }
                this.newFileCreationPage.setFileName(modelFilename);
            }
        }
    }

    public IFile getModelFile() {
        return this.newFileCreationPage.getModelFile();
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
        this.configurationElement = config;
    }

    public class ScaModelWizardInitialObjectCreationPage {
    }

    public class ScaModelWizardNewFileCreationPage
    extends WizardNewFileCreationPage {
        public ScaModelWizardNewFileCreationPage(String pageId, IStructuredSelection selection) {
            super(pageId, selection);
        }

        protected boolean validatePage() {
            if (super.validatePage()) {
                String extension = new Path(this.getFileName()).getFileExtension();
                if (extension == null || !FILE_EXTENSIONS.contains(extension)) {
                    String key = FILE_EXTENSIONS.size() > 1 ? "_WARN_FilenameExtensions" : "_WARN_FilenameExtension";
                    this.setErrorMessage(ScaEditorPlugin.INSTANCE.getString(key, new Object[]{FORMATTED_FILE_EXTENSIONS}));
                    return false;
                }
                return true;
            }
            return false;
        }

        public IFile getModelFile() {
            return ResourcesPlugin.getWorkspace().getRoot().getFile(this.getContainerFullPath().append(this.getFileName()));
        }
    }
}

