/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.examples.java;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.stp.sca.common.ScaCommonPlugin;
import org.eclipse.stp.sca.examples.wizards.PostInit;

public class SetClassPath
implements PostInit {
    private static final String srcFolderString = "src";

    public void postInit(String projectName) throws Exception {
        File tuscanyDirectory;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(projectName);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        ArrayList<IClasspathEntry> newEntries = new ArrayList<IClasspathEntry>();
        newEntries.addAll(Arrays.asList(javaProject.getRawClasspath()));
        boolean classpathIsNotSet = true;
        for (IClasspathEntry entry : newEntries) {
            if (entry.getEntryKind() != 3 || entry.getPath().segmentCount() <= 1) continue;
            classpathIsNotSet = false;
            break;
        }
        if (classpathIsNotSet) {
            newEntries.clear();
            IFile srcFolder = workspace.getRoot().getProject(projectName).getFile(srcFolderString);
            newEntries.add(JavaCore.newSourceEntry((IPath)srcFolder.getFullPath()));
            newEntries.add(JavaCore.newContainerEntry((IPath)new Path(JavaRuntime.JRE_CONTAINER)));
        }
        if ((tuscanyDirectory = new File(ScaCommonPlugin.getDefault().getPreferenceStore().getString("TuscanyDirectory").concat(File.separator).concat("lib"))).exists() && tuscanyDirectory.isDirectory()) {
            File[] fileArray = tuscanyDirectory.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                String name = f.getName();
                if (name.indexOf(".jar") != -1) {
                    IClasspathEntry varEntry = JavaCore.newLibraryEntry((IPath)new Path(f.getAbsolutePath()), null, null);
                    newEntries.add(varEntry);
                }
                ++n2;
            }
        }
        javaProject.setRawClasspath(newEntries.toArray(new IClasspathEntry[newEntries.size()]), (IProgressMonitor)new NullProgressMonitor());
    }
}

