/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.examples.wizards;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledFormText;

public class FormBrowser {
    FormToolkit toolkit;
    Composite container;
    ScrolledFormText formText;
    String text;
    int style;

    public FormBrowser(int style) {
        this.style = style;
    }

    public void createControl(Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        int borderStyle = this.toolkit.getBorderStyle() == 2048 ? 0 : 2048;
        this.container = new Composite(parent, borderStyle);
        FillLayout flayout = new FillLayout();
        flayout.marginWidth = 1;
        flayout.marginHeight = 1;
        this.container.setLayout((Layout)flayout);
        this.formText = new ScrolledFormText(this.container, 768, false);
        if (borderStyle == 0) {
            this.formText.setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
            this.toolkit.paintBordersFor(this.container);
        }
        FormText ftext = this.toolkit.createFormText((Composite)this.formText, false);
        this.formText.setFormText(ftext);
        this.formText.setExpandHorizontal(true);
        this.formText.setExpandVertical(true);
        this.formText.setBackground(this.toolkit.getColors().getBackground());
        this.formText.setForeground(this.toolkit.getColors().getForeground());
        ftext.marginWidth = 2;
        ftext.marginHeight = 2;
        ftext.setHyperlinkSettings((HyperlinkSettings)this.toolkit.getHyperlinkGroup());
        this.formText.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (FormBrowser.this.toolkit != null) {
                    FormBrowser.this.toolkit.dispose();
                    FormBrowser.this.toolkit = null;
                }
            }
        });
        if (this.text != null) {
            this.formText.setText(this.text);
        }
    }

    public Control getControl() {
        return this.container;
    }

    public void setText(String text) {
        this.text = text;
        if (this.formText != null) {
            this.formText.setText(text);
        }
    }
}

