/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.introspection;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.stp.sca.Component;
import org.eclipse.stp.sca.ComponentReference;
import org.eclipse.stp.sca.ComponentService;
import org.eclipse.stp.sca.ComponentType;
import org.eclipse.stp.sca.Composite;
import org.eclipse.stp.sca.DocumentRoot;
import org.eclipse.stp.sca.Implementation;
import org.eclipse.stp.sca.JavaImplementation;
import org.eclipse.stp.sca.ScaPackage;
import org.eclipse.stp.sca.introspection.ComponentTypeFileResolver;
import org.eclipse.stp.sca.introspection.IntrospectionPlugin;
import org.eclipse.stp.sca.introspection.Messages;
import org.eclipse.stp.sca.introspection.Resolver;
import org.eclipse.stp.sca.util.ScaResourceFactoryImpl;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentTypeResolver
implements Resolver {
    private static final String COMPONENT_TYPE_RESOLVER_EXTENSION_POINT = "org.eclipse.stp.sca.introspection.componentTypeResolver";
    private List<ComponentTypeFileResolver> componentTypesFileResolver;
    private IProject project;

    public ComponentTypeResolver(IProject projectC) {
        this.project = projectC;
        this.componentTypesFileResolver = new ArrayList<ComponentTypeFileResolver>();
        this.resolveExtensionPoint();
    }

    private void resolveExtensionPoint() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(COMPONENT_TYPE_RESOLVER_EXTENSION_POINT);
        if (extensionPoint == null || extensionPoint.getExtensions().length == 0) {
            return;
        }
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                Status status;
                String componentTypeResolverS = configElements[j].getAttribute("componentTypeFileResolver");
                ComponentTypeFileResolver componentTypeResolver = null;
                try {
                    String contibutorName = configElements[j].getContributor().getName();
                    Bundle bundle = Platform.getBundle((String)contibutorName);
                    componentTypeResolver = (ComponentTypeFileResolver)bundle.loadClass(componentTypeResolverS).newInstance();
                }
                catch (ClassNotFoundException e) {
                    status = new Status(4, "org.eclipse.stp.sca.introspection", e.getMessage(), (Throwable)e);
                    IntrospectionPlugin.getDefault().getLog().log((IStatus)status);
                }
                catch (InstantiationException e) {
                    status = new Status(4, "org.eclipse.stp.sca.introspection", e.getMessage(), (Throwable)e);
                    IntrospectionPlugin.getDefault().getLog().log((IStatus)status);
                }
                catch (IllegalAccessException e) {
                    status = new Status(4, "org.eclipse.stp.sca.introspection", e.getMessage(), (Throwable)e);
                    IntrospectionPlugin.getDefault().getLog().log((IStatus)status);
                }
                if (componentTypeResolver != null) {
                    this.componentTypesFileResolver.add(componentTypeResolver);
                }
                ++j;
            }
            ++i;
        }
    }

    @Override
    public Composite resolve(Composite composite) {
        for (Component component : composite.getComponent()) {
            this.resolveComponent(component);
        }
        return composite;
    }

    private void resolveComponent(Component component) {
        if (component.getImplementation() == null) {
            return;
        }
        if (component.getImplementation() instanceof JavaImplementation) {
            return;
        }
        ComponentType componentType = this.getComponentType(component.getImplementation());
        if (componentType == null) {
            return;
        }
        this.processComponentType(component, componentType);
    }

    private void processComponentType(Component component, ComponentType componentType) {
        for (ComponentService ctService : componentType.getService()) {
            ComponentService componentService = this.getService(ctService.getName(), (EList<ComponentService>)component.getService());
            if (componentService != null) {
                componentService.getInterface();
                ctService.getInterface();
                continue;
            }
            component.getService().add((Object)ctService);
        }
        for (ComponentReference ctReference : componentType.getReference()) {
            ComponentReference componentRef = this.getReference(ctReference.getName(), (EList<ComponentReference>)component.getReference());
            if (componentRef != null) continue;
            component.getReference().add((Object)ctReference);
        }
    }

    private ComponentService getService(String name, EList<ComponentService> services) {
        for (ComponentService service : services) {
            if (!name.equals(service.getName())) continue;
            return service;
        }
        return null;
    }

    private ComponentReference getReference(String name, EList<ComponentReference> references) {
        for (ComponentReference reference : references) {
            if (!name.equals(reference.getName())) continue;
            return reference;
        }
        return null;
    }

    private ComponentType getComponentType(Implementation implementation) {
        ComponentType result = null;
        ComponentTypeFileResolver componentTypeFileResolver = this.getComponentTypeFileResolver(implementation);
        if (componentTypeFileResolver == null) {
            Status status = new Status(2, "org.eclipse.stp.sca.introspection", String.valueOf(Messages.ComponentTypeResolver_2) + implementation.getClass().getCanonicalName());
            IntrospectionPlugin.getDefault().getLog().log((IStatus)status);
            return null;
        }
        URI uri = this.getComponentFileType(componentTypeFileResolver.getFileName(implementation));
        if (uri == null) {
            Status status = new Status(2, "org.eclipse.stp.sca.introspection", String.valueOf(Messages.ComponentTypeResolver_3) + componentTypeFileResolver.getFileName(implementation));
            IntrospectionPlugin.getDefault().getLog().log((IStatus)status);
            return null;
        }
        Resource resource = this.getEMFResource(uri);
        if (resource == null) {
            return null;
        }
        result = ((DocumentRoot)resource.getContents().get(0)).getComponentType();
        return result;
    }

    private URI getComponentFileType(String fileName) {
        File projectFile = this.project.getLocation().toFile();
        List<URI> componentTypeFiles = this.getComponentFiles(projectFile, String.valueOf(fileName) + ".componentType");
        if (componentTypeFiles.size() > 0) {
            return componentTypeFiles.get(0);
        }
        return null;
    }

    private ComponentTypeFileResolver getComponentTypeFileResolver(Implementation implementation) {
        ComponentTypeFileResolver result = null;
        Iterator<ComponentTypeFileResolver> it = this.componentTypesFileResolver.iterator();
        while (result == null && it.hasNext()) {
            ComponentTypeFileResolver fileResolver = it.next();
            if (!fileResolver.canBeApplied(implementation)) continue;
            result = fileResolver;
        }
        return result;
    }

    private Resource getEMFResource(URI uri) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new ScaResourceFactoryImpl());
        resourceSet.getPackageRegistry().put((Object)"http://www.osoa.org/xmlns/sca/1.0", (Object)ScaPackage.eINSTANCE);
        Resource resource = null;
        try {
            resource = resourceSet.getResource(uri, true);
        }
        catch (RuntimeException e) {
            Status status = new Status(2, "org.eclipse.stp.sca.introspection", String.valueOf(Messages.ComponentTypeResolver_5) + uri.toString(), (Throwable)e);
            IntrospectionPlugin.getDefault().getLog().log((IStatus)status);
            return null;
        }
        return resource;
    }

    private List<URI> getComponentFiles(File file, String fileNameToSearch) {
        ArrayList<URI> result = new ArrayList<URI>();
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                result.addAll(this.getComponentFiles(f, fileNameToSearch));
                ++n2;
            }
        } else if (file.getName().toLowerCase().endsWith(fileNameToSearch.toLowerCase())) {
            URI uri = URI.createFileURI((String)file.getAbsolutePath());
            result.add(uri);
        }
        return result;
    }
}

