/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.introspection;

import java.util.HashMap;
import java.util.Set;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.stp.sca.Component;
import org.eclipse.stp.sca.ComponentReference;
import org.eclipse.stp.sca.ComponentService;
import org.eclipse.stp.sca.Composite;
import org.eclipse.stp.sca.Interface;
import org.eclipse.stp.sca.Property;
import org.eclipse.stp.sca.PropertyValue;
import org.eclipse.stp.sca.Reference;
import org.eclipse.stp.sca.SCAImplementation;
import org.eclipse.stp.sca.ScaFactory;
import org.eclipse.stp.sca.ScaPackage;
import org.eclipse.stp.sca.Service;
import org.eclipse.stp.sca.introspection.Resolver;
import org.eclipse.stp.sca.util.ScaCompositeUtils;

public class CompositeImplementationResolver
implements Resolver {
    public void resolveServices(Component component, Composite composite) {
        for (Service service : composite.getService()) {
            this.setService(component, service);
        }
    }

    public void resolveReferences(Component component, Composite composite) {
        for (Reference reference : composite.getReference()) {
            this.setReference(component, reference);
        }
    }

    public void resolveProperties(Component component, Composite composite) {
        HashMap propertyMap = new HashMap();
        HashMap<String, Property> missingPropertyMap = new HashMap<String, Property>();
        EList newPropertyList = composite.getProperty();
        for (Property property : newPropertyList) {
            if (propertyMap.containsValue(property.getName())) continue;
            String pName = property.getName();
            missingPropertyMap.put(pName, property);
        }
        Set propertySet = missingPropertyMap.keySet();
        for (String key : propertySet) {
            PropertyValue p = ScaFactory.eINSTANCE.createPropertyValue();
            p.setName(key);
            p.setType(((Property)missingPropertyMap.get(key)).getType());
            p.setValue(((Property)missingPropertyMap.get(key)).getValue());
            component.getProperty().add((Object)p);
        }
    }

    public Composite resolve(Composite composite) {
        for (Component component : composite.getComponent()) {
            this.resolve(component);
        }
        return composite;
    }

    private void resolve(Component component) {
        IResource compositeFile;
        if (!(component.getImplementation() instanceof SCAImplementation)) {
            return;
        }
        SCAImplementation scaImplem = (SCAImplementation)component.getImplementation();
        QName compositeName = scaImplem.getName();
        if (compositeName != null && (compositeFile = null) != null) {
            Composite includedComposite = ScaCompositeUtils.getComposite(compositeFile);
            this.resolveServices(component, includedComposite);
            this.resolveReferences(component, includedComposite);
            this.resolveProperties(component, includedComposite);
        }
    }

    private void setService(Component component, Service service) {
        ComponentService componentService = ScaFactory.eINSTANCE.createComponentService();
        componentService.setName(service.getName());
        if (service.getInterface() != null) {
            this.setInterface(componentService.getInterfaceGroup(), ScaPackage.Literals.BASE_SERVICE__INTERFACE_GROUP, service.getInterfaceGroup().getEStructuralFeature(0), service.getInterface());
        } else if (service.getPromote2() != null && service.getPromote2().getInterface() != null) {
            this.setInterface(componentService.getInterfaceGroup(), ScaPackage.Literals.BASE_SERVICE__INTERFACE_GROUP, service.getPromote2().getInterfaceGroup().getEStructuralFeature(0), service.getPromote2().getInterface());
        }
        component.getService().add((Object)componentService);
    }

    private void setInterface(FeatureMap interfaceGroup, EAttribute interfaceGroupLiteral, EStructuralFeature eStructuralFeature, Interface interfac) {
        ((FeatureMap.Internal)interfaceGroup).clear();
        ((FeatureMap.Internal)interfaceGroup).add((EStructuralFeature)interfaceGroupLiteral, (Object)FeatureMapUtil.createEntry((EStructuralFeature)eStructuralFeature, (Object)interfac));
    }

    private void setReference(Component component, Reference reference) {
        ComponentReference componentReference = ScaFactory.eINSTANCE.createComponentReference();
        componentReference.setName(reference.getName());
        if (reference.getInterface() != null) {
            this.setInterface(componentReference.getInterfaceGroup(), ScaPackage.Literals.BASE_REFERENCE__INTERFACE_GROUP, reference.getInterfaceGroup().getEStructuralFeature(0), reference.getInterface());
        } else if (reference.getPromote2() != null && reference.getPromote2().getInterface() != null) {
            this.setInterface(componentReference.getInterfaceGroup(), ScaPackage.Literals.BASE_REFERENCE__INTERFACE_GROUP, reference.getPromote2().getInterfaceGroup().getEStructuralFeature(0), reference.getPromote2().getInterface());
        }
        component.getReference().add((Object)componentReference);
    }
}

