/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.ontology.view.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.stp.sca.ontology.view.mock.ExtendedIterator;
import org.eclipse.stp.sca.ontology.view.mock.OntClass;
import org.eclipse.stp.sca.ontology.view.mock.OntModel;
import org.eclipse.stp.sca.ontology.view.search.OntologySearchResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassBrowser {
    public static final int SEARCH_ALL = 0;
    public static final int SEARCH_ANY = 1;
    public static final int SEARCH_EXACT = 2;
    public static ClassBrowser INSTANCE = new ClassBrowser();
    private List<OntClass> listOfClasses = new ArrayList<OntClass>();

    private ClassBrowser() {
    }

    public List<OntologySearchResult> searchClasses(OntModel model, String query, int searchMode) {
        this.listOfClasses.clear();
        ExtendedIterator it = model.listClasses();
        while (it.hasNext()) {
            this.graphTraversal(it.next());
        }
        return this.getMatchingResult(query, searchMode);
    }

    private List<OntologySearchResult> getMatchingResult(String query, int searchMode) {
        HashMap<OntClass, OntologySearchResult> result;
        block8: {
            String[] keywords;
            block7: {
                result = new HashMap<OntClass, OntologySearchResult>();
                keywords = null;
                keywords = searchMode == 2 ? new String[]{query} : query.split("(\\s)+");
                if (searchMode != 1 && searchMode != 2) break block7;
                for (OntClass ontClass : this.listOfClasses) {
                    String name = this.getName(ontClass).toLowerCase();
                    String description = this.getDescription(ontClass).toLowerCase();
                    String annotation = this.getAnnotation(ontClass);
                    String[] stringArray = keywords;
                    int n = keywords.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String keyword = stringArray[n2];
                        if (name.contains(keyword = keyword.toLowerCase()) || description.contains(keyword)) {
                            int interest = name.contains(keyword) ? 1 : 0;
                            interest += ClassBrowser.stringOccur(description, keyword);
                            OntologySearchResult bean = (OntologySearchResult)result.get(ontClass);
                            if (bean == null) {
                                bean = new OntologySearchResult();
                                bean.setAnnotation(annotation);
                                bean.setDescription(this.getDescription(ontClass));
                                bean.setName(this.getName(ontClass));
                                bean.setInterest(interest);
                            } else {
                                bean.setInterest(interest + bean.getInterest());
                            }
                            result.put(ontClass, bean);
                        }
                        ++n2;
                    }
                }
                break block8;
            }
            if (searchMode != 0) break block8;
            block2: for (OntClass ontClass : this.listOfClasses) {
                String name = this.getName(ontClass);
                String description = this.getDescription(ontClass);
                int interest = 0;
                String[] stringArray = keywords;
                int n = keywords.length;
                int n3 = 0;
                while (n3 < n) {
                    int currentInterest;
                    String keyword = stringArray[n3];
                    int n4 = currentInterest = name.contains(keyword) ? 1 : 0;
                    if ((currentInterest += ClassBrowser.stringOccur(description, keyword)) == 0) continue block2;
                    interest += currentInterest;
                    ++n3;
                }
                OntologySearchResult bean = (OntologySearchResult)result.get(ontClass);
                bean = new OntologySearchResult();
                String annotation = this.getAnnotation(ontClass);
                bean.setAnnotation(annotation);
                bean.setDescription(description);
                bean.setName(name);
                bean.setInterest(interest);
                result.put(ontClass, bean);
            }
        }
        return new ArrayList<OntologySearchResult>(result.values());
    }

    public static final int stringOccur(String text, String string) {
        return ClassBrowser.regexOccur(text, Pattern.quote(string));
    }

    public static final int regexOccur(String text, String regex) {
        Matcher matcher = Pattern.compile(regex).matcher(text);
        int occur = 0;
        while (matcher.find()) {
            ++occur;
        }
        return occur;
    }

    protected void graphTraversal(OntClass classe) {
        if (!this.listOfClasses.contains(classe) && !classe.isAnon()) {
            this.listOfClasses.add(classe);
            ExtendedIterator it = classe.listSubClasses(true);
            while (it.hasNext()) {
                this.graphTraversal(it.next());
            }
        }
    }

    private String getName(OntClass cls) {
        String name = cls.getLocalName();
        return name != null ? name : "";
    }

    private String getDescription(OntClass cls) {
        String desc = cls.getComment(null);
        return desc != null ? desc : "";
    }

    private String getOntologyURI(OntClass cls) {
        return (String)cls.getModel().getNsPrefixMap().get("");
    }

    private String getAnnotation(OntClass cls) {
        return "modelReference=\"" + this.getOntologyURI(cls) + this.getName(cls) + "\"";
    }
}

