/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.ontology.view.search;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.stp.sca.ontology.view.mock.OntModel;
import org.eclipse.stp.sca.ontology.view.mock.OntModelFactory;
import org.eclipse.stp.sca.ontology.view.search.IOntologyModelManager;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OntologyModelManager
implements IOntologyModelManager {
    public static final OntologyModelManager INSTANCE = new OntologyModelManager();

    private OntologyModelManager() {
    }

    @Override
    public void addModelFile(String url) {
        URI uri = this.resolveUrlToNormalizedUri(url);
        this.addModelFile(uri);
    }

    public void addModelFile(URI uri) {
        if (uri == null || models.containsKey(uri)) {
            return;
        }
        OntModelFactory ontModelFactory = null;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.stp.sca.ontology.modelfactory");
        if (extensionPoint == null || extensionPoint.getExtensions().length == 0) {
            ontModelFactory = new OntModelFactory();
        } else {
            Bundle theBundle = null;
            IExtension[] extensions = extensionPoint.getExtensions();
            IExtension extension = extensions[0];
            IConfigurationElement[] members = extension.getConfigurationElements();
            int j = 0;
            while (j < members.length) {
                IConfigurationElement member = members[j];
                String conditionClass = member.getAttribute("class");
                theBundle = Platform.getBundle((String)member.getNamespaceIdentifier());
                if (conditionClass != null) {
                    try {
                        Class c = theBundle.loadClass(conditionClass);
                        Object instance = c.newInstance();
                        if (instance instanceof OntModelFactory) {
                            ontModelFactory = (OntModelFactory)instance;
                        }
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                        ontModelFactory = new OntModelFactory();
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                        ontModelFactory = new OntModelFactory();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                        ontModelFactory = new OntModelFactory();
                    }
                } else {
                    ontModelFactory = new OntModelFactory();
                }
                ++j;
            }
        }
        OntModel model = ontModelFactory.createOntModel();
        model.read(uri.toString());
        models.put(uri, model);
    }

    @Override
    public void refreshModelFile(String url) {
        URI uri = this.resolveUrlToNormalizedUri(url);
        if (uri == null) {
            return;
        }
        models.remove(uri);
        this.addModelFile(uri);
    }

    @Override
    public void removeModelFile(String url) {
        URI uri = this.resolveUrlToNormalizedUri(url);
        if (uri != null) {
            models.remove(uri);
        }
    }

    @Override
    public Map<URI, OntModel> getModels() {
        return Collections.unmodifiableMap(models);
    }

    @Override
    public Collection<OntModel> getOntologyModels() {
        return Collections.unmodifiableCollection(models.values());
    }

    @Override
    public Collection<URI> getSourceUris() {
        return models.keySet();
    }

    public URI resolveUrlToNormalizedUri(String url) throws IllegalArgumentException {
        try {
            URL newUrl = new URL(url);
            return this.resolveUrlToNormalizedUri(newUrl);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public URI resolveUrlToNormalizedUri(URL url) throws IllegalArgumentException {
        URI uri = null;
        try {
            uri = url.toURI();
        }
        catch (URISyntaxException e) {
            try {
                uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
            }
            catch (URISyntaxException e1) {
                throw new IllegalArgumentException("Broken URL: " + url);
            }
        }
        uri = uri.normalize();
        return uri;
    }
}

