/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.ontology.view.viewer;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.stp.sca.ontology.view.search.OntologySearchResult;
import org.eclipse.stp.sca.ontology.view.viewer.OntologyFlatContentProvider;
import org.eclipse.stp.sca.ontology.view.viewer.OntologyViewerInput;

public class OntologyViewerFilter
extends ViewerFilter {
    private int cpt = 0;
    private int page;

    public OntologyViewerFilter(int page) {
        this.page = page;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element == OntologyFlatContentProvider.RESULT_ROOT) {
            this.cpt = 0;
            return true;
        }
        if (element instanceof String) {
            OntologyViewerInput input = (OntologyViewerInput)viewer.getInput();
            if (!input.isKnownFamily((String)element)) {
                return true;
            }
            int lowerLimit = input.getLowerLimit((String)element);
            int upperLimit = input.getUpperLimit((String)element);
            int minPage = (this.page - 1) * 25;
            int maxPage = this.page * 25;
            if (lowerLimit >= minPage && lowerLimit < maxPage) {
                return true;
            }
            return upperLimit > minPage && upperLimit <= maxPage;
        }
        if (element instanceof OntologySearchResult) {
            if (this.cpt >= (this.page - 1) * 25 && this.cpt < this.page * 25) {
                ++this.cpt;
                return true;
            }
            ++this.cpt;
        }
        return false;
    }

    public void resetCount() {
        this.cpt = 0;
    }

    public void setPage(int page) {
        this.page = page;
        this.cpt = 0;
    }
}

