/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.ontology.view.viewer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.stp.sca.ontology.view.search.OntologySearchResult;
import org.eclipse.stp.sca.ontology.view.viewer.OntologyBeanComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OntologyViewerInput {
    private Map<String, List<OntologySearchResult>> concepts = new HashMap<String, List<OntologySearchResult>>();
    private Map<String, Integer> lowerLimit = new HashMap<String, Integer>();
    private Map<String, Integer> upperLimit = new HashMap<String, Integer>();
    private int numberOfConcepts = 0;

    public void clearAllConcepts() {
        this.numberOfConcepts = 0;
        this.concepts.clear();
        this.lowerLimit.clear();
        this.upperLimit.clear();
    }

    public void addConcepts(String family, List<OntologySearchResult> beans) {
        Collections.sort(beans, new OntologyBeanComparator());
        this.concepts.put(family, beans);
        this.lowerLimit.put(family, this.numberOfConcepts);
        this.numberOfConcepts += beans.size();
        this.upperLimit.put(family, this.numberOfConcepts);
    }

    public int getNumberOfConcepts() {
        return this.numberOfConcepts;
    }

    public int getNumberOfConcepts(String family) {
        List<OntologySearchResult> beans = this.concepts.get(family);
        return beans == null ? 0 : beans.size();
    }

    public int getLowerLimit(String family) {
        return this.lowerLimit.get(family);
    }

    public int getUpperLimit(String family) {
        return this.upperLimit.get(family);
    }

    public List<OntologySearchResult> getAllTheConcepts() {
        ArrayList<OntologySearchResult> result = new ArrayList<OntologySearchResult>();
        for (List<OntologySearchResult> beans : this.concepts.values()) {
            result.addAll(beans);
        }
        Collections.sort(result, new OntologyBeanComparator());
        return result;
    }

    public List<OntologySearchResult> getConcepts(String family) {
        List<OntologySearchResult> result = Collections.emptyList();
        return this.concepts.containsKey(family) ? this.concepts.get(family) : result;
    }

    public Collection<String> getFamilies() {
        return this.concepts.keySet();
    }

    public boolean isKnownFamily(String family) {
        return this.concepts.containsKey(family);
    }
}

