/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.xmleditor.completion.test;

import org.eclipse.stp.sca.xmleditor.completion.XmlContextualDom;
import org.junit.Assert;
import org.junit.Test;

public class XmlContextualDomTest {
    private final String[] xmlStrings = new String[]{"<?xml versi=\"1.0\" encoding=\"ISO-8859-15\"?><!-- Comment over one light with weird symbols # @%// \u0002~ ... < and > --><sca:composite xmlns:sca=\"http://www.osoa.org/xmlns/sca/1.0\" xmlns=\"http://www.osoa.org/xmlns/sca/1.0 \" xmlns:tuscany=\"http://tuscany.apache.org/xmlns/sca/1.0\" name=\"RestaurantRMIService\" targetNamespace=\"toto\">\n\t\n\t\n<!-- Comment over \n several \n\n lines --><sca:component name=\"RestaurantServiceComponent\"><sca:implementation.java class=\"restaurant_rmi_service.lib.RestaurantServiceImpl\"/><sca:service name=\"RestaurantService\"> <sca:interface.java interface=\"restaurant_rmi_service.api.RestaurantService\"/><tuscany:binding.rmi  host=\"localhost\" port=\"8099\" serviceName=\"RestaurantServiceRMI\"/></sca:service><sca:reference  name = \"billService\" target=\"BillServiceComponent/BillService\"/>", "<?xml versi=\"1.0\" encoding=\"ISO-8859-15\"?><composite xmlns=\"http://www.osoa.org/xmlns/sca/1.0 \" name=\"RestaurantRMIService\" targetNamespace=\"toto\"><component name=\"RestaurantServiceComponent\" <"};

    @Test
    public void testProcessingInstructions() {
        XmlContextualDom xcd = new XmlContextualDom(0, this.xmlStrings[0]);
        if (xcd.getStatus() != XmlContextualDom.PositionStatus.OTHER) {
            Assert.fail((String)"Position should be OTHER - xmlString-0, offset = 0");
        }
        if ((xcd = new XmlContextualDom(1, this.xmlStrings[1])).getStatus() != XmlContextualDom.PositionStatus.ELEMENT_NAME) {
            Assert.fail((String)"Position should be ELEMENT_NAME - xmlString-0, offset = 1");
        }
        if ((xcd = new XmlContextualDom(29, this.xmlStrings[1])).getStatus() != XmlContextualDom.PositionStatus.OTHER) {
            Assert.fail((String)"Position should be OTHER - xmlString-1, offset = 29");
        }
        if ((xcd = new XmlContextualDom(41, this.xmlStrings[0])).getStatus() != XmlContextualDom.PositionStatus.OTHER) {
            Assert.fail((String)"Position should be OTHER - xmlString-0, offset 41");
        }
        if (xcd.getLastNode() != xcd.getDoc()) {
            Assert.fail((String)"Last node should be equal to the document");
        }
    }

    @Test
    public void testComments() {
        XmlContextualDom xcd = new XmlContextualDom(48, this.xmlStrings[0]);
        if (xcd.getStatus() != XmlContextualDom.PositionStatus.OTHER) {
            Assert.fail((String)"Position should be OTHER - xmlString-0, offset = 48");
        }
        if ((xcd = new XmlContextualDom(110, this.xmlStrings[0])).getStatus() != XmlContextualDom.PositionStatus.OTHER) {
            Assert.fail((String)"Position should be OTHER - xmlString-0, offset = 110");
        }
        if ((xcd = new XmlContextualDom(360, this.xmlStrings[0])).getStatus() != XmlContextualDom.PositionStatus.OTHER) {
            Assert.fail((String)"Position should be OTHER - xmlString-0, offset = 360");
        }
        if (xcd.getLastNode() == null || !xcd.getLastNode().getNodeName().startsWith("sca:composite")) {
            Assert.fail((String)"Last node is incorrect.");
        }
    }

    @Test
    public void testElementName() {
        String uri;
        XmlContextualDom xcd = new XmlContextualDom(116, this.xmlStrings[0]);
        if (xcd.getStatus() != XmlContextualDom.PositionStatus.ELEMENT_NAME) {
            Assert.fail((String)"Position should be ELEMENT_NAME - xmlString-0, offset = 115");
        }
        if (xcd.getLastNode() == null || !xcd.getLastNode().getNodeName().equals("s")) {
            Assert.fail((String)"Last node should be 's'");
        }
        if ((xcd = new XmlContextualDom(118, this.xmlStrings[0])).getStatus() != XmlContextualDom.PositionStatus.ELEMENT_NAME) {
            Assert.fail((String)"Position should be ELEMENT_NAME - xmlString-0, offset = 118");
        }
        if (xcd.getLastNode() == null || !xcd.getLastNode().getNodeName().equals("sca")) {
            Assert.fail((String)"Last node should be 'sca'");
        }
        if ((xcd = new XmlContextualDom(122, this.xmlStrings[0])).getStatus() != XmlContextualDom.PositionStatus.ELEMENT_NAME) {
            Assert.fail((String)"Position should be ELEMENT_NAME - xmlString-0, offset = 122");
        }
        if (xcd.getLastNode() == null || !xcd.getLastNode().getNodeName().equals("sca:com")) {
            Assert.fail((String)"Last node should be 'sca:com'");
        }
        if ((xcd = new XmlContextualDom(128, this.xmlStrings[0])).getStatus() != XmlContextualDom.PositionStatus.ELEMENT_NAME) {
            Assert.fail((String)"Position should be ELEMENT_NAME - xmlString-0, offset = 128");
        }
        if (xcd.getLastNode() == null || !xcd.getLastNode().getNodeName().equals("sca:composite")) {
            Assert.fail((String)"Last node should be 'sca:composite'");
        }
        if ((xcd = new XmlContextualDom(47, this.xmlStrings[1])).getStatus() != XmlContextualDom.PositionStatus.ELEMENT_NAME) {
            Assert.fail((String)"Position should be ELEMENT_NAME - xmlString-1, offset = 47");
        }
        if (xcd.getLastNode() == null || !xcd.getLastNode().getNodeName().equals("comp")) {
            Assert.fail((String)"Last node should be 'comp'");
        }
        if ((uri = xcd.getLastNode().lookupNamespaceURI(null)) == null || uri.length() == 0) {
            Assert.fail((String)"Last node name space was not defined.");
        }
        if ((xcd = new XmlContextualDom(150, this.xmlStrings[1])).getStatus() != XmlContextualDom.PositionStatus.ELEMENT_NAME) {
            Assert.fail((String)"Position should be ELEMENT_NAME - xmlString-1, offset = 150 (unclosed mark-up)");
        }
        if (xcd.getLastNode() == null || !xcd.getLastNode().getNodeName().equals("co")) {
            Assert.fail((String)"Last node should be 'co'");
        }
        if (xcd.getLastNode().getAttributes().getLength() != 1) {
            Assert.fail((String)"Last node should have one attribute.");
        }
    }

    @Test
    public void testElementValue() {
        XmlContextualDom xcd = new XmlContextualDom(325, this.xmlStrings[0]);
        if (xcd.getStatus() != XmlContextualDom.PositionStatus.ELEMENT_VALUE) {
            Assert.fail((String)"Position should be ELEMENT_VALUE - xmlString-0, offset = 325");
        }
        if (xcd.getLastNode() == null || !xcd.getLastNode().getNodeName().equals("sca:composite")) {
            Assert.fail((String)"Last node should be 'sca:composite'");
        }
        if ((xcd = new XmlContextualDom(328, this.xmlStrings[0])).getStatus() != XmlContextualDom.PositionStatus.ELEMENT_VALUE) {
            Assert.fail((String)"Position should be ELEMENT_VALUE - xmlString-0, offset = 328");
        }
        if (xcd.getLastNode() == null || !xcd.getLastNode().getNodeName().equals("sca:composite")) {
            Assert.fail((String)"Last node should be 'sca:composite'");
        }
        if ((xcd = new XmlContextualDom(540, this.xmlStrings[0])).getStatus() != XmlContextualDom.PositionStatus.ELEMENT_VALUE) {
            Assert.fail((String)"Position should be ELEMENT_VALUE - xmlString-0, offset = 540");
        }
        if (xcd.getLastNode() == null || !xcd.getLastNode().getNodeName().equals("sca:service")) {
            Assert.fail((String)"Last node should be 'sca:service'");
        }
    }

    @Test
    public void testAttributeName() {
        XmlContextualDom xcd = new XmlContextualDom(177, this.xmlStrings[0]);
        if (xcd.getStatus() != XmlContextualDom.PositionStatus.ATTRIBUTE_NAME) {
            Assert.fail((String)"Position should be ATTRIBUTE_NAME - xmlString-0, offset = 177");
        }
        if (xcd.getLastNode() == null || !xcd.getLastNode().getNodeName().equals("sca:composite")) {
            Assert.fail((String)"Last node should be 'sca:composite'");
        }
        if (xcd.getLastAttr() == null || !xcd.getLastAttr().getNodeName().equals("xm")) {
            Assert.fail((String)"Last attribute should be 'xm'");
        }
        if (xcd.getLastNode().getAttributes().getLength() != 5) {
            Assert.fail((String)"Last node should have 5 attributes");
        }
        if ((xcd = new XmlContextualDom(180, this.xmlStrings[0])).getStatus() != XmlContextualDom.PositionStatus.NS_DECLARATION) {
            Assert.fail((String)"Position should be NS_DECLARATION - xmlString-0, offset = 180");
        }
        if (xcd.getLastAttr() == null || !xcd.getLastAttr().getNodeName().equals("xmlns")) {
            Assert.fail((String)"Last attribute should be 'xmlns'");
        }
        if (xcd.getLastNode().getAttributes().getLength() != 5) {
            Assert.fail((String)"Last node should have 5 attributes");
        }
        if ((xcd = new XmlContextualDom(99, this.xmlStrings[1])).getStatus() != XmlContextualDom.PositionStatus.ATTRIBUTE_NAME) {
            Assert.fail((String)"Position should be ATTRIBUTE_NAME - xmlString-1, offset = 99");
        }
        if (xcd.getLastNode() == null || !xcd.getLastNode().getNodeName().equals("composite")) {
            Assert.fail((String)"Last node should be 'composite'");
        }
        if (xcd.getLastAttr() == null || !xcd.getLastAttr().getNodeName().equals("nam")) {
            Assert.fail((String)"Last attribute should be 'nam'");
        }
        if (xcd.getLastNode().getAttributes().getLength() != 3) {
            Assert.fail((String)"Last node should have 3 attributes");
        }
        if ((xcd = new XmlContextualDom(640, this.xmlStrings[0])).getStatus() != XmlContextualDom.PositionStatus.ATTRIBUTE_NAME) {
            Assert.fail((String)"Position should be ATTRIBUTE_NAME - xmlString-0, offset = 640");
        }
        if (xcd.getLastAttr() != null) {
            Assert.fail((String)"Last attribute should be null");
        }
        if (xcd.getLastNode() == null || !xcd.getLastNode().getNodeName().equals("tuscany:binding.rmi")) {
            Assert.fail((String)"Last node should be 'tuscany:binding.rmi'");
        }
        if (xcd.getLastNode().getAttributes().getLength() != 3) {
            Assert.fail((String)"Last node should have 3 attributes (offset in between two spaces before 'host')");
        }
        if ((xcd = new XmlContextualDom(641, this.xmlStrings[0])).getStatus() != XmlContextualDom.PositionStatus.ATTRIBUTE_NAME) {
            Assert.fail((String)"Position should be ATTRIBUTE_NAME - xmlString-0, offset = 641");
        }
        if (xcd.getLastAttr() != null) {
            Assert.fail((String)"Last attribute should be null");
        }
        if (xcd.getLastNode() == null || !xcd.getLastNode().getNodeName().equals("tuscany:binding.rmi")) {
            Assert.fail((String)"Last node should be 'tuscany:binding.rmi'");
        }
        if (xcd.getLastNode().getAttributes().getLength() != 3) {
            Assert.fail((String)"Last node should have 3 attributes (offset is just before 'host')");
        }
    }

    @Test
    public void testAttributeValue() {
        XmlContextualDom xcd = new XmlContextualDom(183, this.xmlStrings[0]);
        if (xcd.getStatus() != XmlContextualDom.PositionStatus.NS_URI) {
            Assert.fail((String)"Position should be NS_URI - xmlString-0, offset = 183");
        }
        if (xcd.getLastNode() == null || !xcd.getLastNode().getNodeName().equals("sca:composite")) {
            Assert.fail((String)"Last node should be 'sca:composite'");
        }
        if (xcd.getLastAttr() == null || !xcd.getLastAttr().getNodeName().equals("xmlns")) {
            Assert.fail((String)"Last attribute should be 'xmlns'");
        }
        if (!xcd.getLastAttr().getNodeValue().equals("h")) {
            Assert.fail((String)"Last attribute value should be 'h'");
        }
        if (!xcd.getEndOfAttributeValue().equals("ttp://www.osoa.org/xmlns/sca/1.0 ")) {
            Assert.fail((String)"The end of the current attribute should be 'ttp://www.osoa.org/xmlns/sca/1.0 '");
        }
        if (xcd.getLastNode().getAttributes().getLength() != 5) {
            Assert.fail((String)"Last node should have 5 attributes");
        }
        if ((xcd = new XmlContextualDom(300, this.xmlStrings[0])).getStatus() != XmlContextualDom.PositionStatus.ATTRIBUTE_VALUE) {
            Assert.fail((String)"Position should be ATTRIBUTE_VALUE - xmlString-0, offset = 300");
        }
        if (xcd.getLastNode() == null || !xcd.getLastNode().getNodeName().equals("sca:composite")) {
            Assert.fail((String)"Last node should be 'sca:composite'");
        }
        if (xcd.getLastAttr() == null || !xcd.getLastAttr().getNodeName().equals("name")) {
            Assert.fail((String)"Last attribute should be 'name'");
        }
        if (!xcd.getLastAttr().getNodeValue().equals("RestaurantRMIService")) {
            Assert.fail((String)"Last attribute value should be 'RestaurantRMIService'");
        }
        if (xcd.getEndOfAttributeValue().length() != 0) {
            Assert.fail((String)"The end of the current attribute should be the empty string.");
        }
        if (xcd.getLastNode().getAttributes().getLength() != 5) {
            Assert.fail((String)"Last node should have 5 attributes");
        }
        if ((xcd = new XmlContextualDom(233, this.xmlStrings[0])).getStatus() != XmlContextualDom.PositionStatus.NS_URI) {
            Assert.fail((String)"Position should be NS_URI - xmlString-0, offset = 233");
        }
        if (xcd.getLastNode() == null || !xcd.getLastNode().getNodeName().equals("sca:composite")) {
            Assert.fail((String)"Last node should be 'sca:composite'");
        }
        if (xcd.getLastAttr() == null || !xcd.getLastAttr().getNodeName().equals("xmlns:tuscany")) {
            Assert.fail((String)"Last attribute should be 'xmlns:tuscany'");
        }
        if (xcd.getLastAttr().getNodeValue().length() != 0) {
            Assert.fail((String)"Last attribute value should be the empty string");
        }
        if (!xcd.getEndOfAttributeValue().equals("http://tuscany.apache.org/xmlns/sca/1.0")) {
            Assert.fail((String)"The end of the current attribute should be 'http://tuscany.apache.org/xmlns/sca/1.0'");
        }
        if (xcd.getLastNode().getAttributes().getLength() != 5) {
            Assert.fail((String)"Last node should have 5 attributes");
        }
    }

    @Test
    public void testInsideMarkUp() {
        XmlContextualDom xcd = new XmlContextualDom(741, this.xmlStrings[0]);
        if (xcd.getStatus() != XmlContextualDom.PositionStatus.INSIDE_MARK_UP) {
            Assert.fail((String)"Position should be INSIDE_MARK_UP - xmlString-0, offset = 741 ('name {offset}=')");
        }
        if ((xcd = new XmlContextualDom(742, this.xmlStrings[0])).getStatus() != XmlContextualDom.PositionStatus.INSIDE_MARK_UP) {
            Assert.fail((String)"Position should be INSIDE_MARK_UP - xmlString-0, offset = 742 ('name ={offset} ')");
        }
        if ((xcd = new XmlContextualDom(743, this.xmlStrings[0])).getStatus() != XmlContextualDom.PositionStatus.INSIDE_MARK_UP) {
            Assert.fail((String)"Position should be INSIDE_MARK_UP - xmlString-0, offset = 743 ('name = {offset}\"')");
        }
    }

    @Test
    public void testUndeclaredNamespaces() {
        XmlContextualDom xcd = new XmlContextualDom(51, this.xmlStrings[1]);
        if (xcd.getStatus() != XmlContextualDom.PositionStatus.ELEMENT_NAME) {
            Assert.fail((String)"Position should be ELEMENT_NAME - xmlString-1, offset = 51");
        }
        if ((xcd = new XmlContextualDom(128, this.xmlStrings[0])).getStatus() != XmlContextualDom.PositionStatus.ELEMENT_NAME) {
            Assert.fail((String)"Position should be ELEMENT_NAME - xmlString-0, offset = 128 ('sca:composite{offset} ')");
        }
        if (xcd.getLastNode() == null || !xcd.getLastNode().getNodeName().equals("sca:composite")) {
            Assert.fail((String)"Last node should be 'sca:composite'");
        }
        if ((xcd = new XmlContextualDom(129, this.xmlStrings[0])).getStatus() != XmlContextualDom.PositionStatus.ATTRIBUTE_NAME) {
            Assert.fail((String)"Position should be ATTRIBUTE_NAME - xmlString-0, offset = 129 ('sca:composite {offset}')");
        }
        if (xcd.getLastNode() == null || !xcd.getLastNode().getNodeName().equals("sca:composite")) {
            Assert.fail((String)"Last node should be 'sca:composite'");
        }
        if ((xcd = new XmlContextualDom(130, this.xmlStrings[0])).getStatus() != XmlContextualDom.PositionStatus.CORRUPTED) {
            Assert.fail((String)"Position should be CORRUPTED - xmlString-0, offset = 130 ('sca:composite x{offset}mlns:sca')");
        }
        if ((xcd = new XmlContextualDom(140, this.xmlStrings[0])).getStatus() != XmlContextualDom.PositionStatus.NS_URI) {
            Assert.fail((String)"Position should be NS_URI - xmlString-0, offset = 140 ('xmlns:sca=\"{offset}h')");
        }
        if ((xcd = new XmlContextualDom(141, this.xmlStrings[0])).getStatus() != XmlContextualDom.PositionStatus.NS_URI) {
            Assert.fail((String)"Position should be NS_URI - xmlString-0, offset = 141 ('xmlns:sca=\"h{offset}')");
        }
        if (xcd.getLastNode() == null || !xcd.getLastNode().getNodeName().equals("sca:composite")) {
            Assert.fail((String)"Last node should be 'sca:composite'");
        }
    }
}

