/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.xmleditor.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.stp.sca.xmleditor.preferences.beans.ScaXmlAttribute;
import org.eclipse.stp.sca.xmleditor.preferences.beans.ScaXmlElement;
import org.eclipse.stp.sca.xmleditor.preferences.beans.ScaXmlNamespace;
import org.eclipse.stp.sca.xmleditor.preferences.beans.ScaXmlPlatform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPreferences {
    private static DefaultPreferences instance = new DefaultPreferences();
    private ScaXmlPlatform fabric3 = new ScaXmlPlatform("Fabric3");
    private ScaXmlPlatform pFrascati = new ScaXmlPlatform("FraSCAti / PEtALS");
    private ScaXmlPlatform tuscany = new ScaXmlPlatform("Tuscany");
    private final ScaXmlNamespace fabric3_0_5_1 = new ScaXmlNamespace("http://fabric3.org/xmlns/sca/tutorials/0.5.1", this.fabric3);
    private final ScaXmlNamespace pFrascatiNs = new ScaXmlNamespace("http://frascati.ow2.org", this.pFrascati);
    private final ScaXmlNamespace pFrascati11Ns = new ScaXmlNamespace("http://frascati.ow2.org/xmlns/sca/1.1", this.pFrascati);
    private final ScaXmlNamespace tuscanyNs = new ScaXmlNamespace("http://tuscany.apache.org/xmlns/sca/1.0", this.tuscany);

    private DefaultPreferences() {
    }

    public static DefaultPreferences getInstance() {
        return instance;
    }

    public List<ScaXmlPlatform> getDefaultPreferences() {
        this.fabric3 = new ScaXmlPlatform("Fabric3");
        this.pFrascati = new ScaXmlPlatform("FraSCAti / PEtALS");
        this.tuscany = new ScaXmlPlatform("Tuscany");
        this.fabric3.namespaces.add(this.fabric3_0_5_1);
        this.addFabric3DefaultBindings();
        this.pFrascati.namespaces.add(this.pFrascatiNs);
        this.pFrascati.namespaces.add(this.pFrascati11Ns);
        this.addPetalsFrascatiDefaultBindings();
        this.addPetalsFrascatiDefaultImplementations();
        this.tuscany.namespaces.add(this.tuscanyNs);
        this.addTuscanyDefaultBindings();
        this.addTuscanyDefaultImplementations();
        this.addTuscanyDefaultInterfaces();
        ArrayList<ScaXmlPlatform> platforms = new ArrayList<ScaXmlPlatform>();
        platforms.add(this.fabric3);
        platforms.add(this.pFrascati);
        platforms.add(this.tuscany);
        return platforms;
    }

    private void addPetalsFrascatiDefaultBindings() {
        ScaXmlElement jbiElement = new ScaXmlElement("binding.jbi", this.pFrascati);
        new ScaXmlAttribute("interfaceName", jbiElement, ScaXmlAttribute.ScaXmlAttributeProperty.required);
        new ScaXmlAttribute("interfaceNamespace", jbiElement, ScaXmlAttribute.ScaXmlAttributeProperty.required);
        new ScaXmlAttribute("serviceName", jbiElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional);
        new ScaXmlAttribute("serviceNamespace", jbiElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional);
        new ScaXmlAttribute("endpointName", jbiElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional);
        new ScaXmlAttribute("operationName", jbiElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional);
        new ScaXmlAttribute("operationNamespace", jbiElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional);
        new ScaXmlAttribute("wsdl", jbiElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional);
        new ScaXmlAttribute("timeout", jbiElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional);
        ArrayList<ScaXmlElement> elements = new ArrayList<ScaXmlElement>();
        elements.add(jbiElement);
        this.pFrascati.bindings.addAll(elements);
        this.pFrascati.nsToBindings.put(this.pFrascatiNs, elements);
        ScaXmlElement restElement = new ScaXmlElement("binding.rest", this.pFrascati);
        ScaXmlElement rmiElement = new ScaXmlElement("binding.rmi", this.pFrascati);
        new ScaXmlAttribute("host", rmiElement, ScaXmlAttribute.ScaXmlAttributeProperty.required);
        new ScaXmlAttribute("serviceName", rmiElement, ScaXmlAttribute.ScaXmlAttributeProperty.required);
        new ScaXmlAttribute("port", rmiElement, ScaXmlAttribute.ScaXmlAttributeProperty.required);
        elements = new ArrayList();
        elements.add(jbiElement);
        elements.add(restElement);
        elements.add(rmiElement);
        this.pFrascati.bindings.addAll(elements);
        this.pFrascati.nsToBindings.put(this.pFrascati11Ns, elements);
    }

    private void addPetalsFrascatiDefaultImplementations() {
        ScaXmlElement fractalElement = new ScaXmlElement("binding.fractal", this.pFrascati);
        new ScaXmlAttribute("definition", fractalElement, ScaXmlAttribute.ScaXmlAttributeProperty.required);
        ArrayList<ScaXmlElement> elements = new ArrayList<ScaXmlElement>();
        elements.add(fractalElement);
        this.pFrascati.implementations.addAll(elements);
        this.pFrascati.nsToImplementations.put(this.pFrascatiNs, elements);
        ScaXmlElement osgiElement = new ScaXmlElement("implementation.osgi", this.pFrascati);
        new ScaXmlAttribute("bundle", osgiElement, ScaXmlAttribute.ScaXmlAttributeProperty.required);
        ScaXmlElement scriptElement = new ScaXmlElement("implementation.script", this.pFrascati);
        new ScaXmlAttribute("language", scriptElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional);
        new ScaXmlAttribute("script", scriptElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional);
        elements = new ArrayList();
        elements.add(fractalElement);
        elements.add(osgiElement);
        elements.add(scriptElement);
        this.pFrascati.implementations.addAll(elements);
        this.pFrascati.nsToImplementations.put(this.pFrascati11Ns, elements);
    }

    private void addFabric3DefaultBindings() {
        ScaXmlElement burlapElement = new ScaXmlElement("binding.burlap", this.fabric3);
        new ScaXmlAttribute("uri", burlapElement, ScaXmlAttribute.ScaXmlAttributeProperty.required);
        ScaXmlElement hessianElement = new ScaXmlElement("binding.hessian", this.fabric3);
        new ScaXmlAttribute("uri", hessianElement, ScaXmlAttribute.ScaXmlAttributeProperty.required);
        ArrayList<ScaXmlElement> elements = new ArrayList<ScaXmlElement>();
        elements.add(burlapElement);
        elements.add(hessianElement);
        this.fabric3.bindings.addAll(elements);
        this.fabric3.nsToBindings.put(this.fabric3_0_5_1, elements);
    }

    private void addTuscanyDefaultBindings() {
        String[] rmiAttributes;
        ScaXmlElement ajaxElement = new ScaXmlElement("binding.ajax", this.tuscany);
        ScaXmlElement dwrElement = new ScaXmlElement("binding.dwr", this.tuscany);
        ScaXmlElement httpElement = new ScaXmlElement("binding.http", this.tuscany);
        ScaXmlElement jsonRpcElement = new ScaXmlElement("binding.jsonrpc", this.tuscany);
        ScaXmlElement atomElement = new ScaXmlElement("binding.atom", this.tuscany);
        new ScaXmlAttribute("title", atomElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional);
        ScaXmlElement ejbElement = new ScaXmlElement("binding.ejb", this.tuscany);
        new ScaXmlAttribute("uri", ejbElement, ScaXmlAttribute.ScaXmlAttributeProperty.required);
        ScaXmlElement jmsElement = new ScaXmlElement("binding.jms", this.tuscany);
        new ScaXmlAttribute("uri", jmsElement, ScaXmlAttribute.ScaXmlAttributeProperty.required);
        ScaXmlElement notificationElement = new ScaXmlElement("binding.notification", this.tuscany);
        new ScaXmlAttribute("ntm", notificationElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional);
        new ScaXmlAttribute("notificationType", notificationElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional);
        ScaXmlElement rmiElement = new ScaXmlElement("binding.rmi", this.tuscany);
        String[] stringArray = rmiAttributes = new String[]{"host", "port", "serviceName"};
        int n = rmiAttributes.length;
        int n2 = 0;
        while (n2 < n) {
            String rmiAttribute = stringArray[n2];
            new ScaXmlAttribute(rmiAttribute, rmiElement, ScaXmlAttribute.ScaXmlAttributeProperty.required);
            ++n2;
        }
        ScaXmlElement rssElement = new ScaXmlElement("binding.rss", this.tuscany);
        new ScaXmlAttribute("title", rssElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional);
        ArrayList<ScaXmlElement> elements = new ArrayList<ScaXmlElement>();
        elements.add(ajaxElement);
        elements.add(dwrElement);
        elements.add(httpElement);
        elements.add(jsonRpcElement);
        elements.add(atomElement);
        elements.add(ejbElement);
        elements.add(jmsElement);
        elements.add(notificationElement);
        elements.add(rmiElement);
        elements.add(rssElement);
        this.tuscany.bindings.addAll(elements);
        this.tuscany.nsToBindings.put(this.tuscanyNs, elements);
    }

    private void addTuscanyDefaultImplementations() {
        ScaXmlElement bpelElement = new ScaXmlElement("implementation.bpel", this.tuscany);
        new ScaXmlAttribute("process", bpelElement, ScaXmlAttribute.ScaXmlAttributeProperty.required);
        ScaXmlElement dasElement = new ScaXmlElement("implementation.das", this.tuscany);
        new ScaXmlAttribute("config", dasElement, ScaXmlAttribute.ScaXmlAttributeProperty.required);
        new ScaXmlAttribute("dataAccessType", dasElement, ScaXmlAttribute.ScaXmlAttributeProperty.required);
        ScaXmlElement connectionInfoElement = new ScaXmlElement("ConnectionInfo", dasElement);
        new ScaXmlAttribute("dataSource", connectionInfoElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional);
        new ScaXmlAttribute("managedtx", connectionInfoElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional, "", "true");
        ScaXmlElement connectionPropertiesElement = new ScaXmlElement("ConnectionProperties", connectionInfoElement);
        new ScaXmlAttribute("driverClass", connectionPropertiesElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional);
        new ScaXmlAttribute("databaseURL", connectionPropertiesElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional);
        new ScaXmlAttribute("username", connectionPropertiesElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional, "", "");
        new ScaXmlAttribute("password", connectionPropertiesElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional, "", "");
        new ScaXmlAttribute("loginTimeout", connectionPropertiesElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional, "", "0");
        ScaXmlElement dataElement = new ScaXmlElement("implementation.data", this.tuscany);
        connectionInfoElement = new ScaXmlElement("ConnectionInfo", dataElement);
        new ScaXmlAttribute("dataSource", connectionInfoElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional);
        new ScaXmlAttribute("managedtx", connectionInfoElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional, "", "true");
        connectionPropertiesElement = new ScaXmlElement("ConnectionProperties", connectionInfoElement);
        new ScaXmlAttribute("driverClass", connectionPropertiesElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional);
        new ScaXmlAttribute("databaseURL", connectionPropertiesElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional);
        new ScaXmlAttribute("username", connectionPropertiesElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional, "", "");
        new ScaXmlAttribute("password", connectionPropertiesElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional, "", "");
        new ScaXmlAttribute("loginTimeout", connectionPropertiesElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional, "", "0");
        ScaXmlElement nodeElement = new ScaXmlElement("implementation.node", this.tuscany);
        new ScaXmlAttribute("uri", nodeElement, ScaXmlAttribute.ScaXmlAttributeProperty.required);
        new ScaXmlAttribute("composite", nodeElement, ScaXmlAttribute.ScaXmlAttributeProperty.required);
        ScaXmlElement notificationElement = new ScaXmlElement("implementation.notification", this.tuscany);
        new ScaXmlAttribute("name", notificationElement, ScaXmlAttribute.ScaXmlAttributeProperty.required);
        ScaXmlElement osgiElement = new ScaXmlElement("implementation.osgi", this.tuscany);
        new ScaXmlAttribute("bundleSymbolicName", osgiElement, ScaXmlAttribute.ScaXmlAttributeProperty.required);
        new ScaXmlAttribute("bundleVersion", osgiElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional);
        new ScaXmlAttribute("classes", osgiElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional);
        new ScaXmlAttribute("imports", osgiElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional);
        ScaXmlElement osgiPropertiesElement = new ScaXmlElement("properties", osgiElement);
        new ScaXmlAttribute("service", osgiPropertiesElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional);
        new ScaXmlAttribute("reference", osgiPropertiesElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional);
        new ScaXmlAttribute("serviceCallback", osgiPropertiesElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional);
        new ScaXmlAttribute("referenceCallback", osgiPropertiesElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional);
        ScaXmlElement resourceElement = new ScaXmlElement("implementation.resource", this.tuscany);
        new ScaXmlAttribute("location", resourceElement, ScaXmlAttribute.ScaXmlAttributeProperty.required);
        ScaXmlElement scriptElement = new ScaXmlElement("implementation.script", this.tuscany);
        new ScaXmlAttribute("script", scriptElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional);
        new ScaXmlAttribute("language", scriptElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional);
        ScaXmlElement xqueryElement = new ScaXmlElement("implementation.xquery", this.tuscany);
        new ScaXmlAttribute("location", xqueryElement, ScaXmlAttribute.ScaXmlAttributeProperty.required);
        ScaXmlElement widgetElement = new ScaXmlElement("implementation.widget", this.tuscany);
        new ScaXmlAttribute("location", widgetElement, ScaXmlAttribute.ScaXmlAttributeProperty.required);
        ScaXmlElement springElement = new ScaXmlElement("implementation.spring", this.tuscany);
        ArrayList<ScaXmlElement> elements = new ArrayList<ScaXmlElement>();
        elements.add(bpelElement);
        elements.add(dasElement);
        elements.add(dataElement);
        elements.add(nodeElement);
        elements.add(notificationElement);
        elements.add(osgiElement);
        elements.add(resourceElement);
        elements.add(scriptElement);
        elements.add(xqueryElement);
        elements.add(widgetElement);
        elements.add(springElement);
        this.tuscany.implementations.addAll(elements);
        this.tuscany.nsToImplementations.put(this.tuscanyNs, elements);
    }

    private void addTuscanyDefaultInterfaces() {
        ScaXmlElement cppElement = new ScaXmlElement("interface.cpp", this.tuscany);
        ArrayList<ScaXmlElement> elements = new ArrayList<ScaXmlElement>();
        elements.add(cppElement);
        this.tuscany.interfaces.addAll(elements);
        this.tuscany.nsToInterfaces.put(this.tuscanyNs, elements);
    }
}

