/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.xmleditor.preferences.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stp.sca.xmleditor.Messages;
import org.eclipse.stp.sca.xmleditor.preferences.beans.ScaXmlAttribute;
import org.eclipse.stp.sca.xmleditor.preferences.beans.ScaXmlElement;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AttributeEditionDialog
extends Dialog {
    private ScaXmlElement element;
    private ScaXmlAttribute newAttribute;
    private Text nameText;
    private Text defaultText;
    private Combo useCombo;
    private Text fixedValueText;
    private Label errorLabel;

    public AttributeEditionDialog(Shell parentShell, ScaXmlElement element) {
        super(parentShell);
        this.element = element;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        this.getShell().setText(NLS.bind((String)Messages.AttributeEditionDialog_0, (Object)this.element.getName()));
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 20;
        layout.marginHeight = 20;
        layout.horizontalSpacing = 20;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        new Label(container, 0).setText(Messages.AttributeEditionDialog_2);
        this.nameText = new Text(container, 2052);
        if (this.newAttribute != null && this.newAttribute.getName() != null) {
            this.nameText.setText(this.newAttribute.getName());
        } else {
            this.nameText.setText(Messages.AttributeEditionDialog_3);
        }
        this.nameText.setLayoutData((Object)new GridData(768));
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AttributeEditionDialog.this.validate();
            }
        });
        new Label(container, 0).setText(Messages.AttributeEditionDialog_4);
        this.defaultText = new Text(container, 2052);
        this.defaultText.setLayoutData((Object)new GridData(768));
        if (this.newAttribute != null && this.newAttribute.getDefaultValue() != null) {
            this.defaultText.setText(this.newAttribute.getDefaultValue());
        }
        new Label(container, 0).setText(Messages.AttributeEditionDialog_5);
        this.useCombo = new Combo(container, 2052);
        this.useCombo.setItems(new String[]{"Optional", "Required", "Fixed"});
        if (this.newAttribute == null) {
            this.useCombo.select(0);
        } else {
            switch (this.newAttribute.getUse()) {
                case optional: {
                    this.useCombo.select(0);
                    break;
                }
                case required: {
                    this.useCombo.select(1);
                    break;
                }
                case fixed: {
                    this.useCombo.select(2);
                }
            }
        }
        this.useCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AttributeEditionDialog.this.useCombo.getText().equals("Fixed")) {
                    AttributeEditionDialog.this.fixedValueText.setEnabled(true);
                    AttributeEditionDialog.this.defaultText.setEnabled(false);
                } else {
                    AttributeEditionDialog.this.fixedValueText.setEnabled(false);
                    AttributeEditionDialog.this.defaultText.setEnabled(true);
                }
                AttributeEditionDialog.this.validate();
            }
        });
        GridData layoutData = new GridData();
        layoutData.widthHint = 60;
        this.useCombo.setLayoutData((Object)layoutData);
        new Label(container, 0).setText(Messages.AttributeEditionDialog_10);
        this.fixedValueText = new Text(container, 2052);
        this.fixedValueText.setLayoutData((Object)new GridData(768));
        this.fixedValueText.setEnabled(false);
        if (this.newAttribute != null && this.newAttribute.getFixedValue() != null) {
            this.fixedValueText.setText(this.newAttribute.getFixedValue());
        }
        this.fixedValueText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AttributeEditionDialog.this.validate();
            }
        });
        layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        layoutData.verticalIndent = 7;
        this.errorLabel = new Label(container, 0);
        this.errorLabel.setLayoutData((Object)layoutData);
        this.nameText.setFocus();
        this.nameText.setSelection(this.nameText.getText().length());
        return container;
    }

    protected Point getInitialSize() {
        return new Point(400, 230);
    }

    protected void okPressed() {
        if (this.newAttribute == null) {
            this.newAttribute = new ScaXmlAttribute();
            this.newAttribute.setElement(this.element);
        }
        this.newAttribute.setName(this.nameText.getText());
        this.newAttribute.setDefaultValue(this.defaultText.getText());
        this.newAttribute.setFixedValue(this.fixedValueText.getText());
        ScaXmlAttribute.ScaXmlAttributeProperty use = ScaXmlAttribute.ScaXmlAttributeProperty.valueOf(this.useCombo.getText().toLowerCase());
        this.newAttribute.setUse(use);
        super.okPressed();
    }

    public ScaXmlAttribute getNewAttribute() {
        return this.newAttribute;
    }

    public void setNewAttribute(ScaXmlAttribute newAttribute) {
        this.newAttribute = newAttribute;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    public void validate() {
        String fixedValue;
        String name = this.nameText.getText();
        if (name.length() == 0 || !Character.isJavaIdentifierStart(name.charAt(0))) {
            this.updateStatus(Messages.AttributeEditionDialog_11);
            return;
        }
        for (ScaXmlAttribute attr : this.element.attributes) {
            if (!attr.getName().equalsIgnoreCase(name)) continue;
            this.updateStatus(Messages.AttributeEditionDialog_12);
            return;
        }
        if (this.useCombo.getText().equals("Fixed") && ((fixedValue = this.fixedValueText.getText()).length() == 0 || !Character.isJavaIdentifierStart(fixedValue.charAt(0)))) {
            this.updateStatus(Messages.AttributeEditionDialog_14);
            return;
        }
        this.updateStatus(null);
    }

    public void updateStatus(String msg) {
        if (msg != null) {
            this.errorLabel.setText(msg);
            this.errorLabel.getParent().layout();
            this.getButton(0).setEnabled(false);
        } else {
            this.errorLabel.setText("");
            this.errorLabel.getParent().layout();
            this.getButton(0).setEnabled(true);
        }
    }
}

