/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.xmleditor.preferences.viewers;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.stp.sca.xmleditor.ImageRegistry;
import org.eclipse.stp.sca.xmleditor.preferences.beans.ScaXmlAttribute;
import org.eclipse.stp.sca.xmleditor.preferences.beans.ScaXmlElement;
import org.eclipse.stp.sca.xmleditor.preferences.beans.ScaXmlNamespace;
import org.eclipse.stp.sca.xmleditor.preferences.beans.ScaXmlPlatform;
import org.eclipse.swt.graphics.Image;

public class ScaXmlLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    public Image getColumnImage(Object object, int index) {
        if (object == null || index != 0) {
            return null;
        }
        if (object instanceof ScaXmlElement) {
            return ImageRegistry.getInstance().elementImg;
        }
        if (object instanceof ScaXmlPlatform) {
            return ImageRegistry.getInstance().serverImg;
        }
        if (object instanceof ScaXmlAttribute) {
            return ImageRegistry.getInstance().attributeImg;
        }
        return null;
    }

    public String getColumnText(Object object, int index) {
        if (object == null) {
            return "";
        }
        if (object instanceof ScaXmlElement) {
            ScaXmlElement element = (ScaXmlElement)object;
            switch (index) {
                case 0: {
                    String name = element.getName();
                    String nameToLowerCase = name.toLowerCase();
                    if (nameToLowerCase.startsWith("binding.")) {
                        name = name.substring("binding.".length());
                    } else if (nameToLowerCase.startsWith("implementation.")) {
                        name = name.substring("implementation.".length());
                    } else if (nameToLowerCase.startsWith("interface.")) {
                        name = name.substring("interface.".length());
                    }
                    return name;
                }
                case 1: {
                    if (element.getPlatform() == null) {
                        return String.valueOf(element.getMinOccurs()) + "-" + (element.isUnbounded() ? "*" : Integer.valueOf(element.getMaxOccurs()));
                    }
                    return "";
                }
            }
        } else if (object instanceof ScaXmlAttribute) {
            ScaXmlAttribute attribute = (ScaXmlAttribute)object;
            switch (index) {
                case 0: {
                    return attribute.getName();
                }
                case 1: {
                    String result = attribute.getUse().toString();
                    if (attribute.getUse() == ScaXmlAttribute.ScaXmlAttributeProperty.fixed) {
                        result = String.valueOf(result) + "=" + attribute.getFixedValue();
                    }
                    return result;
                }
            }
        } else {
            if (index == 0 && object instanceof ScaXmlPlatform) {
                return ((ScaXmlPlatform)object).getName();
            }
            if (index == 0 && object instanceof ScaXmlNamespace) {
                return ((ScaXmlNamespace)object).getName();
            }
        }
        return "";
    }
}

