/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.xmleditor.utils;

import java.util.Arrays;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ScaUtils {
    private static XPath X_PATH = XPathFactory.newInstance().newXPath();

    public static Node getScaTopNode(Document domDoc) {
        Node node;
        NodeList nodes = domDoc.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            node = nodes.item(i);
            if (node.getLocalName() != null && node.getLocalName().equalsIgnoreCase("composite")) {
                return node;
            }
            ++i;
        }
        i = 0;
        while (i < nodes.getLength()) {
            node = nodes.item(i);
            if (node.getLocalName() != null && node.getLocalName().equalsIgnoreCase("componenttype")) {
                return node;
            }
            ++i;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static QName getIncludeQName(Node node) {
        try {
            String namespaceUri;
            String name;
            block11: {
                block10: {
                    Node nameNode = node.getAttributes().getNamedItem("name");
                    if (nameNode == null) {
                        return null;
                    }
                    name = nameNode.getNodeValue();
                    String prefix = null;
                    int colonPosition = name.lastIndexOf(":");
                    if (colonPosition == 0) return null;
                    if (colonPosition >= name.length()) {
                        return null;
                    }
                    if (colonPosition > 0) {
                        prefix = name.substring(0, colonPosition);
                        name = name.substring(colonPosition + 1);
                    }
                    namespaceUri = null;
                    if (prefix == null) break block10;
                    Node namespaceNode = node.getAttributes().getNamedItem("xmlns:" + prefix);
                    if (namespaceNode != null) {
                        namespaceUri = namespaceNode.getNodeValue();
                        break block11;
                    } else {
                        Node compositeNode = ScaUtils.getScaTopNode(node.getOwnerDocument());
                        if (compositeNode == null) {
                            return null;
                        }
                        namespaceNode = compositeNode.getAttributes().getNamedItem("xmlns:" + prefix);
                        if (namespaceNode != null) {
                            namespaceUri = namespaceNode.getNodeValue();
                        }
                    }
                    break block11;
                }
                Node compositeNode = ScaUtils.getScaTopNode(node.getOwnerDocument());
                if (compositeNode != null) {
                    namespaceUri = compositeNode.getNamespaceURI();
                }
            }
            if ("".equals(name)) return null;
            if ("".equals(namespaceUri)) return null;
            return new QName(namespaceUri, name);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String removeNamespacePrefix(String nodeName) {
        String[] splits = nodeName.split(":");
        if (splits.length == 1) {
            return nodeName;
        }
        return splits[1];
    }

    public static String getNamespacePrefix(String element) {
        String[] splits = element.split(":");
        if (splits.length == 1) {
            return null;
        }
        return splits[0];
    }

    public static String capitalize(String text) {
        if (text == null || text.length() == 0) {
            return text;
        }
        Character firstLetter = Character.valueOf(Character.toUpperCase(text.charAt(0)));
        return firstLetter + text.substring(1);
    }

    public static boolean isIncludeNode(Object node) {
        if (node == null || !Node.class.isAssignableFrom(node.getClass())) {
            return false;
        }
        return ScaUtils.isIncludeNode((Node)node);
    }

    public static boolean isIncludeNode(Node node) {
        String name = node.getNodeName();
        if (name == null) {
            return false;
        }
        return ScaUtils.removeNamespacePrefix(name).toLowerCase().equals("include");
    }

    public static String getAttributeValue(Node node, String attributeName) {
        try {
            NamedNodeMap attributes = node.getAttributes();
            int i = 0;
            while (i < attributes.getLength()) {
                String attrName = attributes.item(i).getNodeName().toLowerCase();
                if (attrName.equals(attributeName.toLowerCase())) {
                    return attributes.item(i).getNodeValue();
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String[] getPromotions(Document doc, boolean forService) {
        String expr = forService ? "/*[local-name()='composite']/*[local-name()='component']/*[local-name()='service']" : "/*[local-name()='composite']/*[local-name()='component']/*[local-name()='reference']";
        try {
            Object o = X_PATH.evaluate(expr, doc, XPathConstants.NODESET);
            if (o instanceof NodeList) {
                NodeList nodes = (NodeList)o;
                Object[] result = new String[nodes.getLength()];
                int i = 0;
                while (i < result.length) {
                    Node node = nodes.item(i);
                    String name = ScaUtils.getAttributeValue(node, "name");
                    String parentName = ScaUtils.getAttributeValue(node.getParentNode(), "name");
                    result[i] = String.valueOf(parentName) + "/" + name;
                    ++i;
                }
                Arrays.sort(result);
                return result;
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        return new String[0];
    }
}

