/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.actions;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.ui.action.ActionMenuManager;
import org.eclipse.gmf.runtime.diagram.ui.actions.DiagramAction;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.stp.bpmn.SequenceEdge;
import org.eclipse.stp.bpmn.Vertex;
import org.eclipse.stp.bpmn.diagram.BpmnDiagramMessages;
import org.eclipse.stp.bpmn.diagram.edit.parts.ActivityEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SequenceEdgeEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessEditPart;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramEditorPlugin;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class ChangeEdgeOrderMenuManager
extends ActionMenuManager {
    public static final String ID = "changeEdgeOrderMenu";
    public static final String SUB_MENU_SOURCE = "changeEdgeOrderMenu_source";
    public static final String SUB_MENU_TARGET = "changeEdgeOrderMenu_target";
    public static final String EDGE_ORDER_TARGET_UP = "changeEdgeOrderMenu_target_up";
    public static final String EDGE_ORDER_TARGET_DOWN = "changeEdgeOrderMenu_target_down";
    public static final String EDGE_ORDER_SOURCE_UP = "changeEdgeOrderMenu_source_up";
    public static final String EDGE_ORDER_SOURCE_DOWN = "changeEdgeOrderMenu_source_down";

    public ChangeEdgeOrderMenuManager() {
        super(ID, (IAction)new DummyMenuAction());
    }

    public static ActionMenuManager createSubmenu(String text, String id) {
        return new ActionMenuManager(id, (IAction)new DummyMenuAction(text, id));
    }

    public static IAction createAction(IWorkbenchPage workbenchPage, String actionId) {
        return new ChangeEdgeOrderAction(workbenchPage, actionId);
    }

    private static class ChangeEdgeOrderAction
    extends DiagramAction {
        private boolean isTarget = false;
        private boolean isUp = false;

        public ChangeEdgeOrderAction(IWorkbenchPage workbenchPage, String id) {
            super(workbenchPage);
            this.setId(id);
        }

        public ChangeEdgeOrderAction(IWorkbenchPart workbenchPart, String id) {
            super(workbenchPart);
            this.setId(id);
        }

        public void init() {
            super.init();
            if (ChangeEdgeOrderMenuManager.EDGE_ORDER_SOURCE_DOWN.equals(this.getId())) {
                this.isTarget = false;
                this.isUp = false;
                this.setText(BpmnDiagramMessages.ChangeEdgeOrderMenuManager_down);
            } else if (ChangeEdgeOrderMenuManager.EDGE_ORDER_SOURCE_UP.equals(this.getId())) {
                this.isTarget = false;
                this.isUp = true;
                this.setText(BpmnDiagramMessages.ChangeEdgeOrderMenuManager_up);
            } else if (ChangeEdgeOrderMenuManager.EDGE_ORDER_TARGET_DOWN.equals(this.getId())) {
                this.isTarget = true;
                this.isUp = false;
                this.setText(BpmnDiagramMessages.ChangeEdgeOrderMenuManager_down);
            } else if (ChangeEdgeOrderMenuManager.EDGE_ORDER_TARGET_UP.equals(this.getId())) {
                this.isTarget = true;
                this.isUp = true;
                this.setText(BpmnDiagramMessages.ChangeEdgeOrderMenuManager_up);
            } else {
                throw new IllegalArgumentException("Invalid id: " + this.getId());
            }
            if (this.isUp) {
                this.setImageDescriptor(BpmnDiagramEditorPlugin.getBundledImageDescriptor("icons/obj16/up.png"));
            } else {
                this.setImageDescriptor(BpmnDiagramEditorPlugin.getBundledImageDescriptor("icons/obj16/down.png"));
            }
            this.refresh();
        }

        protected Request createTargetRequest() {
            return null;
        }

        protected Command getCommand() {
            EList edges;
            boolean wouldWork = true;
            Object sel = this.getStructuredSelection().getFirstElement();
            if (!(sel instanceof SequenceEdgeEditPart)) {
                return UnexecutableCommand.INSTANCE;
            }
            final SequenceEdge edge = (SequenceEdge)((SequenceEdgeEditPart)((Object)sel)).resolveSemanticElement();
            Vertex vertex = this.isTarget ? edge.getTarget() : edge.getSource();
            EList eList = edges = this.isTarget ? vertex.getIncomingEdges() : vertex.getOutgoingEdges();
            if (this.isUp) {
                if (edges.indexOf((Object)edge) == 0) {
                    wouldWork = false;
                }
            } else if (edges.size() - 1 == edges.indexOf((Object)edge)) {
                wouldWork = false;
            }
            if (!wouldWork) {
                return UnexecutableCommand.INSTANCE;
            }
            final SequenceEdgeEditPart seqEp = (SequenceEdgeEditPart)((Object)this.getStructuredSelection().getFirstElement());
            AbstractTransactionalCommand command = new AbstractTransactionalCommand((TransactionalEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)edge), BpmnDiagramMessages.ChangeEdgeOrderMenuManager_command_name, null){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    EditPart part;
                    Vertex vertex = ChangeEdgeOrderAction.this.isTarget ? edge.getTarget() : edge.getSource();
                    EList edges = ChangeEdgeOrderAction.this.isTarget ? vertex.getIncomingEdges() : vertex.getOutgoingEdges();
                    int oldIndex = edges.indexOf((Object)edge);
                    int newIndex = 0;
                    newIndex = ChangeEdgeOrderAction.this.isUp ? oldIndex - 1 : oldIndex + 1;
                    edges.move(newIndex, oldIndex);
                    EditPart editPart = part = ChangeEdgeOrderAction.this.isTarget ? seqEp.getTarget() : seqEp.getSource();
                    if (part instanceof ActivityEditPart) {
                        ((ActivityEditPart)part).refreshSourceConnections();
                        ((ActivityEditPart)part).refreshTargetConnections();
                    } else if (part instanceof SubProcessEditPart) {
                        ((SubProcessEditPart)part).refreshSourceConnections();
                        ((SubProcessEditPart)part).refreshTargetConnections();
                    }
                    return CommandResult.newOKCommandResult();
                }
            };
            CompoundCommand compound = new CompoundCommand();
            compound.add((Command)new ICommandProxy((ICommand)command));
            compound.add(((SequenceEdgeEditPart)((Object)sel)).getCommand(new Request((Object)"refresh")));
            return compound;
        }

        protected boolean isSelectionListener() {
            return true;
        }
    }

    private static class DummyMenuAction
    extends Action {
        public DummyMenuAction() {
            this.setText(BpmnDiagramMessages.ChangeEdgeOrderMenuManager_menu_label);
            this.setId(ChangeEdgeOrderMenuManager.ID);
        }

        public DummyMenuAction(String text, String id) {
            this.setText(text);
            this.setId(id);
        }
    }
}

