/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.edit.parts;

import org.eclipse.draw2d.DelegatingLayout;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayeredPane;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.gef.ui.internal.parts.TextCellEditorEx;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.stp.bpmn.diagram.edit.parts.Activity2EditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.ActivityEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.ActivityName2EditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.ActivityNameEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.AssociationEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.BpmnDiagramEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.DataObject2EditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.DataObjectEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.DataObjectName2EditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.DataObjectNameEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.Group2EditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.GroupEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.GroupName2EditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.GroupNameEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.LaneEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.LaneNameEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.MessagingEdgeEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.MessagingEdgeNameEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.PoolEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.PoolNameEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.PoolPoolCompartmentEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SequenceEdgeEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SequenceEdgeNameEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessNameEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessSubProcessBodyCompartmentEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessSubProcessBorderCompartmentEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.TextAnnotation2EditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.TextAnnotationEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.TextAnnotationName2EditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.TextAnnotationNameEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.WrapTextCellEditorEx;
import org.eclipse.stp.bpmn.diagram.part.BpmnVisualIDRegistry;
import org.eclipse.stp.bpmn.figures.ConnectionLayerExEx;
import org.eclipse.stp.gmf.runtime.draw2d.ui.figures.WrapLabel;
import org.eclipse.stp.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Text;

public class BpmnEditPartFactory
implements EditPartFactory {
    public static final String EXTERNAL_NODE_LABELS_LAYER = "External Node Labels";

    public EditPart createEditPart(EditPart context, Object model) {
        if (model instanceof View) {
            View view = (View)model;
            int viewVisualID = BpmnVisualIDRegistry.getVisualID(view);
            switch (viewVisualID) {
                case 1001: {
                    return new PoolEditPart(view);
                }
                case 4008: {
                    return new PoolNameEditPart(view);
                }
                case 1002: {
                    return new TextAnnotation2EditPart(view);
                }
                case 4009: {
                    return new TextAnnotationName2EditPart(view);
                }
                case 1003: {
                    return new DataObject2EditPart(view);
                }
                case 4010: {
                    return new DataObjectName2EditPart(view);
                }
                case 1004: {
                    return new Group2EditPart(view);
                }
                case 4011: {
                    return new GroupName2EditPart(view);
                }
                case 2001: {
                    return new ActivityEditPart(view);
                }
                case 4001: {
                    return new ActivityNameEditPart(view);
                }
                case 2002: {
                    return new SubProcessEditPart(view);
                }
                case 4006: {
                    return new SubProcessNameEditPart(view);
                }
                case 2003: {
                    return new Activity2EditPart(view);
                }
                case 4002: {
                    return new ActivityName2EditPart(view);
                }
                case 2004: {
                    return new TextAnnotationEditPart(view);
                }
                case 4003: {
                    return new TextAnnotationNameEditPart(view);
                }
                case 2005: {
                    return new DataObjectEditPart(view);
                }
                case 4004: {
                    return new DataObjectNameEditPart(view);
                }
                case 2006: {
                    return new GroupEditPart(view);
                }
                case 4005: {
                    return new GroupNameEditPart(view);
                }
                case 2007: {
                    return new LaneEditPart(view);
                }
                case 4007: {
                    return new LaneNameEditPart(view);
                }
                case 5001: {
                    return new PoolPoolCompartmentEditPart(view);
                }
                case 5002: {
                    return new SubProcessSubProcessBodyCompartmentEditPart(view);
                }
                case 5003: {
                    return new SubProcessSubProcessBorderCompartmentEditPart(view);
                }
                case 79: {
                    return new BpmnDiagramEditPart(view);
                }
                case 3001: {
                    return new SequenceEdgeEditPart(view);
                }
                case 4012: {
                    return new SequenceEdgeNameEditPart(view);
                }
                case 3002: {
                    return new MessagingEdgeEditPart(view);
                }
                case 4013: {
                    return new MessagingEdgeNameEditPart(view);
                }
                case 3003: {
                    return new AssociationEditPart(view);
                }
            }
        }
        return this.createUnrecognizedEditPart(context, model);
    }

    public static void setupConnectionLayerExEx(DiagramRootEditPart root) {
        LayeredPane printableLayers = (LayeredPane)root.getLayer((Object)"Printable Layers");
        Layer connlayer = printableLayers.getLayer((Object)"Connection Layer");
        if (connlayer == null || connlayer instanceof ConnectionLayerExEx) {
            return;
        }
        printableLayers.removeLayer((Object)"Connection Layer");
        Layer decorationLayer = printableLayers.getLayer((Object)"Decoration Printable Layer");
        printableLayers.removeLayer((Object)"Decoration Printable Layer");
        printableLayers.addLayerBefore((Layer)new ConnectionLayerExEx(), (Object)"Connection Layer", (Object)printableLayers.getLayer((Object)"Primary Layer"));
        printableLayers.addLayerBefore(decorationLayer, (Object)"Decoration Printable Layer", (Object)printableLayers.getLayer((Object)"Connection Layer"));
        FreeformLayer extLabelsLayer = new FreeformLayer();
        extLabelsLayer.setLayoutManager((LayoutManager)new DelegatingLayout());
        printableLayers.addLayerAfter((Layer)extLabelsLayer, (Object)EXTERNAL_NODE_LABELS_LAYER, (Object)"Primary Layer");
        LayeredPane scalableLayers = (LayeredPane)root.getLayer((Object)"Scalable Layers");
        FreeformLayer scaledFeedbackLayer = new FreeformLayer();
        scaledFeedbackLayer.setEnabled(false);
        scalableLayers.addLayerAfter((Layer)scaledFeedbackLayer, (Object)"Scaled Feedback Layer", (Object)"Decoration Unprintable Layer");
    }

    private EditPart createUnrecognizedEditPart(EditPart context, Object model) {
        return null;
    }

    public static CellEditorLocator getTextCellEditorLocator(ITextAwareEditPart source) {
        if (source.getFigure() instanceof WrappingLabel) {
            return new TextCellEditorLocator((WrappingLabel)source.getFigure());
        }
        if (source.getFigure() instanceof WrapLabel) {
            return new TextCellEditorLocator((WrapLabel)source.getFigure());
        }
        IFigure figure = source.getFigure();
        return new LabelCellEditorLocator((Label)figure);
    }

    public static final Class getTextCellEditorClass(GraphicalEditPart source) {
        IFigure figure = source.getFigure();
        if (figure instanceof WrappingLabel && ((WrappingLabel)figure).isTextWrapOn()) {
            return WrapTextCellEditorEx.class;
        }
        return TextCellEditorEx.class;
    }

    private static class LabelCellEditorLocator
    implements CellEditorLocator {
        private Label label;

        public LabelCellEditorLocator(Label label) {
            this.label = label;
        }

        public Label getLabel() {
            return this.label;
        }

        public void relocate(CellEditor celleditor) {
            Text text = (Text)celleditor.getControl();
            Rectangle rect = this.getLabel().getTextBounds().getCopy();
            this.getLabel().translateToAbsolute((Translatable)rect);
            int avr = FigureUtilities.getFontMetrics((Font)text.getFont()).getAverageCharWidth();
            rect.setSize(new Dimension(text.computeSize(-1, -1)).expand(avr * 2, 0));
            if (!rect.equals((Object)new Rectangle(text.getBounds()))) {
                text.setBounds(rect.x, rect.y, rect.width, rect.height);
            }
        }
    }

    private static class TextCellEditorLocator
    implements CellEditorLocator {
        private Figure wrapLabel;

        public TextCellEditorLocator(Figure wrapLabel) {
            this.wrapLabel = wrapLabel;
        }

        public Figure getWrapLabel() {
            return this.wrapLabel;
        }

        private Rectangle getTextBounds() {
            if (this.wrapLabel instanceof WrappingLabel) {
                return ((WrappingLabel)this.wrapLabel).getTextBounds();
            }
            return ((WrapLabel)this.wrapLabel).getTextBounds();
        }

        private boolean isTextWrapOn() {
            if (this.wrapLabel instanceof WrappingLabel) {
                return ((WrappingLabel)this.wrapLabel).isTextWrapOn();
            }
            return ((WrapLabel)this.wrapLabel).isTextWrapped();
        }

        private String getText() {
            if (this.wrapLabel instanceof WrappingLabel) {
                return ((WrappingLabel)this.wrapLabel).getText();
            }
            return ((WrapLabel)this.wrapLabel).getText();
        }

        public void relocate(CellEditor celleditor) {
            Text text = (Text)celleditor.getControl();
            Rectangle rect = this.getTextBounds().getCopy();
            this.getWrapLabel().translateToAbsolute((Translatable)rect);
            if (this.isTextWrapOn() && this.getText().length() > 0) {
                rect.setSize(new Dimension(text.computeSize(rect.width, -1)));
            } else {
                int avr = FigureUtilities.getFontMetrics((Font)text.getFont()).getAverageCharWidth();
                rect.setSize(new Dimension(text.computeSize(-1, -1)).expand(avr * 2, 0));
            }
            if (!rect.equals((Object)new Rectangle(text.getBounds()))) {
                text.setBounds(rect.x, rect.y, rect.width, rect.height);
            }
        }
    }
}

