/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gmf.runtime.diagram.ui.menus.PopupMenu;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.stp.bpmn.diagram.ui.IMenuItemWithDisableSupport;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class PopupMenuWithDisableSupport
extends PopupMenu {
    public PopupMenuWithDisableSupport(List aContent, ILabelProvider aLabelProvider) {
        super(aContent, aLabelProvider);
    }

    protected void createMenuItems(Menu parentMenu, PopupMenu root, final List resultThusFar) {
        final PopupMenuWithDisableSupport rootMenu = (PopupMenuWithDisableSupport)root;
        Assert.isNotNull((Object)this.getContent());
        Assert.isNotNull((Object)this.getLabelProvider());
        for (Object contentObject : this.getContent()) {
            MenuItem menuItem;
            if (contentObject instanceof CascadingMenuWithDisableSupport) {
                PopupMenuWithDisableSupport subMenu = ((CascadingMenuWithDisableSupport)((Object)contentObject)).getSubMenu();
                contentObject = ((PopupMenu.CascadingMenu)contentObject).getParentMenuItem();
                if (subMenu.getContent().isEmpty()) {
                    menuItem = new MenuItem(parentMenu, 0);
                    menuItem.setEnabled(false);
                } else {
                    ArrayList thisResult = new ArrayList(resultThusFar);
                    thisResult.add(contentObject);
                    menuItem = new MenuItem(parentMenu, 64);
                    menuItem.setMenu(new Menu(parentMenu));
                    subMenu.createMenuItems(menuItem.getMenu(), rootMenu, thisResult);
                }
            } else {
                menuItem = new MenuItem(parentMenu, 0);
            }
            final Object fContentObject = contentObject;
            String text = this.getLabelProvider().getText(contentObject);
            menuItem.setText(text == null ? "" : text);
            menuItem.setImage(this.getLabelProvider().getImage(contentObject));
            if (contentObject instanceof IMenuItemWithDisableSupport) {
                menuItem.setEnabled(((IMenuItemWithDisableSupport)contentObject).isEnabled());
            }
            menuItem.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    resultThusFar.add(fContentObject);
                    rootMenu.setResult(resultThusFar);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    resultThusFar.add(fContentObject);
                    rootMenu.setResult(resultThusFar);
                }
            });
        }
    }

    public static class CascadingMenuWithDisableSupport
    extends PopupMenu.CascadingMenu {
        private PopupMenuWithDisableSupport subMenu;

        public CascadingMenuWithDisableSupport(Object aParentMenuItem, PopupMenuWithDisableSupport aSubMenu) {
            super(aParentMenuItem, (PopupMenu)aSubMenu);
            this.subMenu = aSubMenu;
        }

        public PopupMenuWithDisableSupport getSubMenu() {
            return this.subMenu;
        }
    }
}

