/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.figures;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.diagram.ui.figures.ShapeCompartmentFigure;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.stp.bpmn.diagram.edit.parts.PoolEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.PoolPoolCompartmentEditPart;
import org.eclipse.stp.bpmn.figures.GroupFigure;
import org.eclipse.stp.bpmn.figures.activities.LaneFigure;

public class PoolPoolCompartmentFigure
extends ShapeCompartmentFigure {
    private Set<Integer> _coordsOnLastUpdate = new HashSet<Integer>();
    private static final Point PRIVATE_POINT = new Point();

    public PoolPoolCompartmentFigure(String title, IMapMode mm) {
        super(title, mm);
    }

    public void paint(Graphics graphics) {
        graphics.pushState();
        graphics.setForegroundColor(PoolEditPart.BORDER);
        List figs = ((IFigure)((IFigure)((IFigure)this.getChildren().get(1)).getChildren().get(0)).getChildren().get(0)).getChildren();
        Point theBottom = this.getBounds().getBottom();
        this.translateToAbsolute((Translatable)theBottom);
        boolean doUpdateRestOfPool = false;
        HashSet<Integer> newCoordsOnLastUpdate = new HashSet<Integer>();
        for (IFigure fig : figs) {
            if (!(fig instanceof LaneFigure)) continue;
            Point bottom = fig.getBounds().getBottom().getCopy();
            fig.translateToAbsolute((Translatable)bottom);
            this.translateToRelative((Translatable)bottom);
            graphics.pushState();
            if (fig.getForegroundColor() != null) {
                graphics.setForegroundColor(fig.getForegroundColor());
            } else {
                graphics.setForegroundColor(ColorConstants.black);
            }
            graphics.setLineWidth((int)(4.0 * graphics.getAbsoluteScale()));
            graphics.setBackgroundColor(fig.getBackgroundColor());
            Rectangle rectangle = new Rectangle();
            rectangle.width = this.getBounds().width;
            rectangle.x = this.getBounds().x;
            rectangle.height = fig.getBounds().height;
            rectangle.y = bottom.y - rectangle.height;
            if (rectangle.y - PoolPoolCompartmentEditPart.INSETS.getHeight() <= this.getBounds().y) {
                rectangle.height += PoolPoolCompartmentEditPart.INSETS.getHeight();
                rectangle.y -= PoolPoolCompartmentEditPart.INSETS.getHeight();
            }
            if (bottom.y + PoolPoolCompartmentEditPart.INSETS.getHeight() >= this.getBounds().y + this.getBounds().height) {
                rectangle.height += PoolPoolCompartmentEditPart.INSETS.getHeight();
            }
            graphics.fillRectangle(rectangle);
            bottom = fig.getBounds().getBottom().getCopy();
            fig.translateToAbsolute((Translatable)bottom);
            if (bottom.y + 35 < theBottom.y) {
                this.translateToRelative((Translatable)bottom);
                graphics.drawLine(this.getBounds().x, bottom.y, this.getBounds().x + this.getBounds().width, bottom.y);
                newCoordsOnLastUpdate.add(bottom.y);
                if (!doUpdateRestOfPool && !this._coordsOnLastUpdate.contains(bottom.y)) {
                    doUpdateRestOfPool = true;
                }
            }
            graphics.popState();
        }
        doUpdateRestOfPool = doUpdateRestOfPool || this._coordsOnLastUpdate.size() != newCoordsOnLastUpdate.size();
        this._coordsOnLastUpdate = newCoordsOnLastUpdate;
        graphics.popState();
        if (doUpdateRestOfPool) {
            this.getUpdateManager().addDirtyRegion((IFigure)this, this.getBounds().x, this.getBounds().y, this.getBounds().width, this.getBounds().height);
        }
        super.paint(graphics);
    }

    protected IFigure findMouseEventTargetInDescendantsAt(int x, int y) {
        PRIVATE_POINT.setLocation(x, y);
        this.translateFromParent((Translatable)PRIVATE_POINT);
        if (!this.getClientArea(Rectangle.SINGLETON).contains(PRIVATE_POINT)) {
            return null;
        }
        int i = this.getChildren().size();
        while (i > 0) {
            IFigure fig = (IFigure)this.getChildren().get(--i);
            if (!fig.isVisible() || !fig.isEnabled() || !fig.containsPoint(PoolPoolCompartmentFigure.PRIVATE_POINT.x, PoolPoolCompartmentFigure.PRIVATE_POINT.y)) continue;
            if ((fig = fig.findMouseEventTargetAt(PoolPoolCompartmentFigure.PRIVATE_POINT.x, PoolPoolCompartmentFigure.PRIVATE_POINT.y)) instanceof GroupFigure || fig != null && fig.getParent() instanceof GroupFigure) {
                return null;
            }
            return fig;
        }
        return null;
    }
}

