/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.layouts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessEditPart;
import org.eclipse.stp.bpmn.diagram.ui.RoundedSchemeBorder;
import org.eclipse.stp.bpmn.figures.SubProcessBodyFigure;
import org.eclipse.stp.bpmn.figures.SubProcessBorderFigure;

public class SubProcessLayout
extends StackLayout {
    public static final int NAME = 0;
    public static final int BODY = 1;
    public static final int BORDER = 2;
    private IFigure name;
    private SubProcessBodyFigure body;
    private SubProcessBorderFigure border;

    public SubProcessLayout() {
        super.setObserveVisibility(true);
    }

    public void layout(IFigure container) {
        SubProcessEditPart.SubProcessFigure spFigure = (SubProcessEditPart.SubProcessFigure)container;
        Rectangle area = container.getClientArea().getCopy();
        Dimension borderPrefSize = this.border.getMinimumSize(container.getSize().width, container.getSize().height);
        this.name.invalidate();
        Dimension namePrefSize = this.name.getPreferredSize();
        Dimension selfSize = area.getSize().getCopy();
        Dimension bodyPrefSize = this.body.getSize().getCopy();
        int maxWidth = Math.max(selfSize.width, borderPrefSize.width);
        borderPrefSize.width = maxWidth = Math.max(namePrefSize.width, maxWidth);
        namePrefSize.width = maxWidth;
        bodyPrefSize.width = maxWidth;
        selfSize.width = maxWidth;
        Dimension minSize = new Dimension(Math.max(maxWidth, SubProcessEditPart.COLLAPSED_SIZE.width), borderPrefSize.height + namePrefSize.height + 20);
        if (spFigure.isCollapsed()) {
            minSize.width = Math.max(minSize.width, SubProcessEditPart.COLLAPSED_SIZE.width);
            minSize.height = Math.max(minSize.height, SubProcessEditPart.COLLAPSED_SIZE.height + borderPrefSize.height - 25);
            this.name.setLocation(area.getLocation().getCopy());
            this.name.setSize(minSize.width, namePrefSize.height);
            this.body.setLocation(new Point(area.x, area.y));
            this.body.setSize(bodyPrefSize);
            this.border.setLocation(new Point(area.x, area.y + minSize.height - borderPrefSize.height));
            this.border.setSize(minSize.width, borderPrefSize.height);
            container.setSize(minSize);
            container.getParent().setSize(container.getSize());
            return;
        }
        minSize.width = Math.max(minSize.width, bodyPrefSize.width + SubProcessEditPart.INSETS.getWidth());
        minSize.width = Math.max(minSize.width, SubProcessEditPart.EXPANDED_SIZE.width);
        minSize.height = Math.max(minSize.height, SubProcessEditPart.EXPANDED_SIZE.height);
        borderPrefSize.width = minSize.width;
        namePrefSize.width = minSize.width;
        bodyPrefSize.width = minSize.width;
        selfSize.width = minSize.width;
        selfSize.height = bodyPrefSize.height + borderPrefSize.height - 15;
        if (selfSize.height < minSize.height) {
            selfSize.height = minSize.height;
        }
        if (selfSize.width < minSize.width) {
            selfSize.width = minSize.width;
        }
        this.name.setLocation(new Point(area.x, area.y));
        this.name.setSize(namePrefSize);
        this.body.setLocation(new Point(area.x, area.y));
        this.body.setSize(bodyPrefSize);
        this.border.setLocation(new Point(area.x, area.y + selfSize.height - borderPrefSize.height - RoundedSchemeBorder.INSETS.bottom));
        this.border.setSize(borderPrefSize);
        container.setSize(selfSize.width, selfSize.height);
        container.getParent().setSize(selfSize.width, selfSize.height);
    }

    public void remove(IFigure figure) {
        if (this.body == figure) {
            this.body = null;
        } else if (this.border == figure) {
            this.border = null;
        } else if (this.name == figure) {
            this.name = null;
        }
    }

    public void setConstraint(IFigure figure, Object constraint) {
        this.remove(figure);
        switch ((Integer)constraint) {
            case 1: {
                this.body = (SubProcessBodyFigure)figure;
                break;
            }
            case 2: {
                this.border = (SubProcessBorderFigure)figure;
                break;
            }
            case 0: {
                this.name = figure;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid constraint");
            }
        }
    }
}

