/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.policies;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.stp.bpmn.Artifact;
import org.eclipse.stp.bpmn.BpmnDiagram;
import org.eclipse.stp.bpmn.diagram.BpmnDiagramMessages;
import org.eclipse.stp.bpmn.diagram.edit.parts.PoolEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.PoolPoolCompartmentEditPart;
import org.eclipse.stp.bpmn.diagram.part.BpmnVisualIDRegistry;
import org.eclipse.stp.bpmn.diagram.providers.BpmnElementTypes;

public class BpmnDiagramXYLayoutEditPolicy
extends XYLayoutEditPolicy {
    public static final int DEFAULT_POOL_X_COORD = 16;

    protected Command getResizeChildrenCommand(ChangeBoundsRequest request) {
        if (request.getEditParts() == null || request.getEditParts().isEmpty()) {
            return null;
        }
        if ((request.getMoveDelta() == null || request.getMoveDelta().equals((Object)new Point(0, 0))) && (request.getSizeDelta() == null || request.getSizeDelta().equals((Object)new Dimension(0, 0)))) {
            return null;
        }
        boolean onlyContainsArtifacts = true;
        for (Object o : request.getEditParts()) {
            boolean bl = onlyContainsArtifacts = onlyContainsArtifacts && o instanceof IGraphicalEditPart && ((IGraphicalEditPart)o).resolveSemanticElement() instanceof Artifact;
        }
        if (onlyContainsArtifacts) {
            return super.getResizeChildrenCommand(request);
        }
        int maxWidth = 200;
        LinkedHashMap<Rectangle, IGraphicalEditPart> toSortBounds = new LinkedHashMap<Rectangle, IGraphicalEditPart>();
        ZoomManager zoom = ((DiagramRootEditPart)this.getHost().getRoot()).getZoomManager();
        for (Object child : this.getHost().getChildren()) {
            IGraphicalEditPart childPart = (IGraphicalEditPart)child;
            if (!(child instanceof PoolEditPart)) continue;
            Rectangle rect = childPart.getFigure().getBounds().getCopy();
            if (request.getEditParts() != null && request.getEditParts().contains(child)) {
                if (request.getSizeDelta() != null) {
                    rect.width = (int)((double)rect.width + (double)request.getSizeDelta().width / zoom.getZoom());
                    rect.height = (int)((double)rect.height + (double)request.getSizeDelta().height / zoom.getZoom());
                }
                if (request.getMoveDelta() != null) {
                    rect.y = (int)((double)rect.y + (double)request.getMoveDelta().y / zoom.getZoom());
                    rect.x = (int)((double)rect.x + (double)request.getMoveDelta().x / zoom.getZoom());
                }
            }
            maxWidth = maxWidth < rect.width ? rect.width : maxWidth;
            while (toSortBounds.keySet().contains(rect)) {
                ++rect.y;
            }
            toSortBounds.put(rect, childPart);
        }
        LinkedList keys = new LinkedList(toSortBounds.keySet());
        Collections.sort(keys, new Comparator<Rectangle>(){

            @Override
            public int compare(Rectangle o1, Rectangle o2) {
                if (o1.y <= o2.y) {
                    return -1;
                }
                return 1;
            }
        });
        int y = 0;
        CompoundCommand command = new CompoundCommand(BpmnDiagramMessages.BpmnDiagramXYLayoutEditPolicy_command_name);
        for (Rectangle key : keys) {
            IGraphicalEditPart comp;
            PoolPoolCompartmentEditPart compartment;
            IGraphicalEditPart part = (IGraphicalEditPart)toSortBounds.get(key);
            key.y = y = key.y < y + 16 ? y + 16 : key.y;
            if (part instanceof PoolEditPart) {
                key.x = 16;
                key.width = maxWidth;
            }
            Command co = this.createChangeConstraintCommand((EditPart)part, key);
            command.add(co);
            if (request.getEditParts().contains(part) && request.getSizeDelta().height != 0 && (compartment = (PoolPoolCompartmentEditPart)part.getChildBySemanticHint(BpmnVisualIDRegistry.getType(5001))) != null) {
                ChangeBoundsRequest laneUpdateRequest = new ChangeBoundsRequest((Object)"resize children");
                laneUpdateRequest.setEditParts((EditPart)part);
                laneUpdateRequest.setMoveDelta(request.getMoveDelta().getCopy());
                laneUpdateRequest.setSizeDelta(request.getSizeDelta().getCopy());
                command.add(compartment.getCommand((Request)laneUpdateRequest));
            }
            y += key.height;
            if (request.getSizeDelta().height != -request.getMoveDelta().y || request.getSizeDelta().height == 0 || request.getEditParts() == null || !request.getEditParts().contains(part) || (comp = part.getChildBySemanticHint(BpmnVisualIDRegistry.getType(5001))) == null) continue;
            ChangeBoundsRequest move = new ChangeBoundsRequest((Object)"move children");
            move.setMoveDelta(new Point(0, request.getSizeDelta().height));
            move.setEditParts(comp.getChildren());
            Command c = comp.getCommand((Request)move);
            if (c == null || !c.canExecute()) continue;
            command.add(c);
        }
        return command;
    }

    protected Object getConstraintFor(CreateRequest request) {
        Object constraint = super.getConstraintFor(request);
        if (request == null || request.getNewObject() == null || ((List)request.getNewObject()).isEmpty() || ((List)request.getNewObject()).get(0) == null || ((CreateViewRequest.ViewDescriptor)((List)request.getNewObject()).get(0)).getElementAdapter() == null || ((List)request.getNewObject()).get(0) == null) {
            return constraint;
        }
        IElementType type = (IElementType)((CreateViewRequest.ViewDescriptor)((List)request.getNewObject()).get(0)).getElementAdapter().getAdapter(IElementType.class);
        int maxWidth = 200;
        if (((BpmnDiagram)((IGraphicalEditPart)this.getHost()).resolveSemanticElement()).getPools().isEmpty()) {
            maxWidth = 1500;
        }
        for (Object child : this.getHost().getChildren()) {
            IGraphicalEditPart childPart = (IGraphicalEditPart)child;
            Rectangle rect = childPart.getFigure().getBounds().getCopy();
            int n = maxWidth = maxWidth < rect.width ? rect.width : maxWidth;
        }
        if (type == BpmnElementTypes.Pool_1001) {
            ((Rectangle)constraint).x = 16;
            ((Rectangle)constraint).width = maxWidth;
            ((Rectangle)constraint).height = 200;
            return constraint;
        }
        return constraint;
    }

    protected Command getCreateCommand(CreateRequest request) {
        if (request instanceof CreateViewAndElementRequest) {
            String type = ((CreateViewAndElementRequest.ViewAndElementDescriptor)((CreateViewAndElementRequest)request).getViewDescriptors().iterator().next()).getSemanticHint();
            if (BpmnVisualIDRegistry.getType(1004).equals(type) || BpmnVisualIDRegistry.getType(1003).equals(type) || BpmnVisualIDRegistry.getType(1002).equals(type)) {
                return super.getCreateCommand(request);
            }
        }
        CompoundCommand co = new CompoundCommand();
        co.add(super.getCreateCommand(request));
        ChangeBoundsRequest req = new ChangeBoundsRequest();
        req.setType((Object)"resize children");
        Rectangle addedThing = (Rectangle)this.getConstraintFor(request);
        List children = ((IGraphicalEditPart)this.getHost()).getChildren();
        LinkedList<IGraphicalEditPart> parts = new LinkedList<IGraphicalEditPart>();
        Point location = request.getLocation().getCopy();
        this.getHostFigure().translateToRelative((Translatable)location);
        for (Object child : children) {
            Rectangle rect = ((IGraphicalEditPart)child).getFigure().getBounds();
            if (rect.y <= location.y) continue;
            parts.add((IGraphicalEditPart)child);
        }
        if (!parts.isEmpty()) {
            req.setEditParts(parts);
            req.setConstrainedMove(true);
            req.setMoveDelta(new Point(addedThing.x, ((Rectangle)this.getConstraintFor((CreateRequest)request)).height + 16));
            co.add(this.getResizeChildrenCommand(req));
        }
        return co;
    }
}

