/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.policies;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.OpenEditPolicy;
import org.eclipse.stp.bpmn.diagram.BpmnDiagramMessages;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramEditorPlugin;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class OpenFileEditPolicy
extends OpenEditPolicy {
    protected Command getOpenCommand(Request request) {
        EObject object;
        if (request instanceof SelectionRequest) {
            return null;
        }
        EditPart part = this.getTargetEditPart(request);
        if (part == null) {
            return null;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        final IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        if (part instanceof IGraphicalEditPart && (object = ((IGraphicalEditPart)part).getNotationView().getElement()) instanceof EModelElement) {
            EAnnotation ann = ((EModelElement)object).getEAnnotation("genericFile");
            if (ann == null) {
                return null;
            }
            String filePath = (String)ann.getDetails().get((Object)"projectRelativePath");
            String line = (String)ann.getDetails().get((Object)"lineNumber");
            final IFile ourFile = WorkspaceSynchronizer.getFile((Resource)object.eResource()).getProject().getFile(filePath);
            IMarker marker = null;
            if (line != null) {
                try {
                    marker = ourFile.createMarker("org.eclipse.core.resources.marker");
                    marker.setAttribute("transient", true);
                    marker.setAttribute("lineNumber", Integer.valueOf(line).intValue());
                }
                catch (CoreException coreException) {
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (marker == null) {
                Command co = new Command(BpmnDiagramMessages.OpenFileEditPolicy_command_name){

                    public void execute() {
                        try {
                            IDE.openEditor((IWorkbenchPage)page, (IFile)ourFile);
                        }
                        catch (PartInitException e) {
                            BpmnDiagramEditorPlugin.getInstance().getLog().log((IStatus)new Status(4, "org.eclipse.stp.bpmn.diagram", 4, e.getMessage(), (Throwable)e));
                        }
                    }
                };
                return co;
            }
            final IMarker finalMarker = marker;
            Command co = new Command(BpmnDiagramMessages.bind((String)BpmnDiagramMessages.OpenFileEditPolicy_command_name_with_line, (Object)line)){

                public void execute() {
                    try {
                        IDE.openEditor((IWorkbenchPage)page, (IMarker)finalMarker);
                    }
                    catch (PartInitException e) {
                        BpmnDiagramEditorPlugin.getInstance().getLog().log((IStatus)new Status(4, "org.eclipse.stp.bpmn.diagram", 4, e.getMessage(), (Throwable)e));
                    }
                }
            };
            return co;
        }
        return null;
    }
}

