/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.common.validator.base;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.eclipse.stp.common.validator.base.FSValidationContextFactory;
import org.eclipse.stp.common.validator.core.BaseValidationObject;
import org.eclipse.stp.common.validator.core.IValidationContext;
import org.eclipse.stp.common.validator.core.IValidationObject;
import org.eclipse.stp.common.validator.core.ValidationObjectID;
import org.eclipse.stp.common.validator.core.ValidationObjectTypeEnum;
import org.eclipse.stp.common.validator.exception.ContextInitializationException;

public class FSValidationContext
implements IValidationContext {
    private static final Logger LOG = Logger.getLogger(FSValidationContext.class);
    private URI contextURI = null;
    private URI objectRelativeURI = null;
    private BaseValidationObject object = null;

    protected FSValidationContext(URI contextUri, URI relativeObjectUri) {
        this.contextURI = contextUri;
        this.objectRelativeURI = relativeObjectUri;
    }

    public IValidationContext[] getAllNestedValidationContexts() {
        return null;
    }

    public IValidationContext getNestedValidationContext(ValidationObjectID pObjectID) {
        URI fullObjectURI;
        IValidationContext nestedContext = null;
        FSValidationContextFactory factory = FSValidationContextFactory.getInstance();
        URI nestedURI = pObjectID.getURI();
        if (nestedURI != null && (fullObjectURI = this.contextURI.resolve(nestedURI)) != null) {
            try {
                nestedContext = factory.createContext(fullObjectURI.getPath());
            }
            catch (ContextInitializationException e) {
                e.printStackTrace();
            }
        }
        return nestedContext;
    }

    public static String getStringFromStream(InputStream is) {
        if (is != null) {
            InputStreamReader reader = null;
            try {
                reader = new InputStreamReader(is);
            }
            catch (Exception e1) {
                LOG.error((Object)"Unexpected exception in getStreamFromString", (Throwable)e1);
                return null;
            }
            StringBuffer sb = new StringBuffer();
            char[] b = new char[1024];
            try {
                int n;
                while ((n = reader.read(b)) > 0) {
                    sb.append(b, 0, n);
                }
            }
            catch (IOException e) {
                LOG.error((Object)("Can't read String from " + is), (Throwable)e);
            }
            return sb.toString();
        }
        return null;
    }

    public IValidationObject getObject() {
        if (this.object == null) {
            URI fullObjectURI = this.contextURI.resolve(this.objectRelativeURI);
            File objectFile = new File(fullObjectURI);
            ValidationObjectTypeEnum objectType = null;
            objectType = BaseValidationObject.resolveObjectTypeFromFileName(objectFile.getName());
            QName fileQName = new QName("", objectFile.getName());
            ValidationObjectID objectID = new ValidationObjectID(objectFile.getName(), fileQName, fullObjectURI, objectType);
            LOG.debug((Object)("Object URI = [" + fullObjectURI + "], object type = [" + objectID.getType().getName() + "]"));
            this.object = new BaseValidationObject(objectID, objectFile);
        }
        return this.object;
    }

    public void setProperty(String propName, Object propObj) {
    }

    public Object getProperty(String propName) {
        return null;
    }
}

