/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.common.validator.cli;

import java.io.FileNotFoundException;
import org.eclipse.stp.common.validator.base.FSValidationContextFactory;
import org.eclipse.stp.common.validator.base.SimpleFileReporter;
import org.eclipse.stp.common.validator.core.IValidationContext;
import org.eclipse.stp.common.validator.core.IValidator;
import org.eclipse.stp.common.validator.core.ValidatorTypeEnum;
import org.eclipse.stp.common.validator.core.impl.ValidatorFactoryDefImpl;
import org.eclipse.stp.common.validator.exception.ConfigurationException;
import org.eclipse.stp.common.validator.exception.ContextInitializationException;
import org.eclipse.stp.common.validator.exception.SOPValidationException;

public class ValidatorCLI {
    public static void main(String[] args) {
        if (args.length != 0) {
            System.out.println("Processing [" + args[0] + "]");
            FSValidationContextFactory contextFactory = FSValidationContextFactory.getInstance();
            IValidationContext context = null;
            try {
                IValidator genericValidator = ValidatorFactoryDefImpl.getInstance().getValidator(ValidatorTypeEnum.GENERIC_VALIDATOR);
                IValidator msvValidator = ValidatorFactoryDefImpl.getInstance().getValidator(ValidatorTypeEnum.MULTISCHEMA_VALIDATOR);
                String filePath = args[0];
                context = contextFactory.createContext(filePath);
                SimpleFileReporter reporterObj = null;
                try {
                    reporterObj = new SimpleFileReporter("report.txt");
                }
                catch (FileNotFoundException e) {
                    System.out.println("Unable to open the Reporter object: " + e.toString());
                }
                System.out.println("Validating using MSV validator");
                msvValidator.validate(context, reporterObj);
                if (reporterObj.getErrorsCount() == 0) {
                    System.out.println("Validating using generic validator");
                    genericValidator.validate(context, reporterObj);
                    System.out.println("Done");
                }
                System.out.println("Done, [" + reporterObj.getErrorsCount() + "] errors, [" + reporterObj.getWarningsCount() + "] warning detected");
            }
            catch (ContextInitializationException e) {
                System.out.println("Context Initialization Problem");
                e.printStackTrace();
            }
            catch (SOPValidationException e) {
                System.out.println("SOPERA Validation Problem");
                e.printStackTrace();
            }
            catch (ConfigurationException e) {
                System.out.println("Validator Configuration Problem");
                e.printStackTrace();
            }
        } else {
            System.out.println("Usage: validator <fileName>");
        }
    }
}

