/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.common.validator.core.impl.service;

import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.PortType;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import org.apache.log4j.Logger;
import org.eclipse.stp.common.validator.base.ValidationMessage;
import org.eclipse.stp.common.validator.core.IReporter;
import org.eclipse.stp.common.validator.core.IValidationContext;
import org.eclipse.stp.common.validator.core.IValidationObject;
import org.eclipse.stp.common.validator.core.IValidator;
import org.eclipse.stp.common.validator.core.MessageTypeEnum;
import org.eclipse.stp.common.validator.core.ValidationObjectTypeEnum;
import org.eclipse.stp.common.validator.core.impl.service.XPathHelper;
import org.eclipse.stp.common.validator.exception.ContextInitializationException;
import org.eclipse.stp.common.validator.exception.SOPValidationException;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class CompatibilityValidator
implements IValidator {
    private static final Logger LOG = Logger.getLogger(CompatibilityValidator.class);
    private static final String MSG_BUNDLE_NAME = "messages";
    private IReporter reporter = null;

    private void setReporter(IReporter ref) {
        this.reporter = ref;
    }

    private void reportWarningMessage(MessageTypeEnum msgID, String[] params, Object cause) {
        if (this.reporter != null) {
            this.reportMessage(2, msgID, params, cause);
        }
    }

    private void reportErrorMessage(MessageTypeEnum msgID, String[] params, Object cause) {
        if (this.reporter != null) {
            this.reportMessage(1, msgID, params, cause);
        }
    }

    private void reportMessage(int severity, MessageTypeEnum msgID, String[] params, Object cause) {
        if (this.reporter != null) {
            ValidationMessage msg = new ValidationMessage(MSG_BUNDLE_NAME, severity, msgID, params);
            if (cause != null) {
                msg.setAttribute("cause", cause);
            }
            this.reporter.addMessage(msg);
        }
    }

    public void checkSOPwareConstraints(Document inputDocument, String selectedPortType) {
        WSDLFactory factory = null;
        WSDLReader reader = null;
        LOG.debug((Object)("Checking for SOPERA constraints for [" + selectedPortType + "] port type"));
        try {
            NodeList nl;
            Map portTypes;
            factory = WSDLFactory.newInstance();
            reader = factory.newWSDLReader();
            reader.setFeature("javax.wsdl.verbose", true);
            reader.setFeature("javax.wsdl.importDocuments", false);
            Definition def = reader.readWSDL(null, inputDocument);
            Map messages = def.getMessages();
            if (messages != null) {
                for (Message msg : messages.values()) {
                    LOG.debug((Object)("Checking [" + msg.getQName().toString() + "] message"));
                    Map parts = msg.getParts();
                    int cParts = parts.size();
                    boolean bNonLiteral = false;
                    for (Part part : parts.values()) {
                        if (part.getElementName() != null) continue;
                        bNonLiteral = true;
                    }
                    if (bNonLiteral) {
                        this.reportWarningMessage(MessageTypeEnum.SOP_NON_LITERAL_MESSAGES_PRESENT, new String[]{msg.getQName().toString()}, null);
                    }
                    if (cParts <= 1) continue;
                    this.reportWarningMessage(MessageTypeEnum.SOP_MULTIPLE_MESSAGE_PARTS_PRESENT, new String[]{msg.getQName().toString(), String.valueOf(cParts)}, null);
                }
            }
            if ((portTypes = def.getPortTypes()) != null) {
                for (PortType portType : portTypes.values()) {
                    String portLocalName = portType.getQName().getLocalPart();
                    if (selectedPortType != null && (selectedPortType == null || portLocalName.compareTo(selectedPortType) != 0)) continue;
                    LOG.debug((Object)("Checking [" + selectedPortType + "] port type"));
                    List operations = portType.getOperations();
                    if (operations == null) continue;
                    for (Operation op : operations) {
                        Map faults = op.getFaults();
                        if (faults == null || faults.size() <= 1) continue;
                        this.reportWarningMessage(MessageTypeEnum.SOP_MULTIPLE_FAULTS_PRESENT, new String[]{op.getName(), portType.getQName().toString(), String.valueOf(faults.size())}, null);
                    }
                }
            }
            if ((nl = XPathHelper.getXPathResultList(inputDocument.getDocumentElement(), "/wsdl:definitions/wsdl:portType")).getLength() == 0) {
                this.reportErrorMessage(MessageTypeEnum.COMPATIBILITY_ERROR_NO_PORTTYPES, new String[]{""}, null);
            }
            if (selectedPortType.equals("")) {
                this.reportErrorMessage(MessageTypeEnum.COMPATIBILITY_ERROR_NO_SELECTED_PORTTYPES, new String[]{""}, null);
            } else {
                nl = XPathHelper.getXPathResultList(inputDocument.getDocumentElement(), "/wsdl:definitions/wsdl:portType[@name='" + selectedPortType + "']/wsdl:operation[count(wsdl:fault) > 1]");
                if (nl.getLength() != 0) {
                    this.reportWarningMessage(MessageTypeEnum.COMPATIBILITY_MESSAGE_WSDL_CONTAINS_MULTIPLE_FAULTS, new String[]{selectedPortType}, null);
                }
            }
            nl = XPathHelper.getXPathResultList(inputDocument.getDocumentElement(), "/wsdl:definitions/wsdl:types/xsd:schema/xsd:import[not(@schemaLocation)]");
            if (nl.getLength() != 0) {
                this.reportErrorMessage(MessageTypeEnum.COMPATIBILITY_ERROR_IMPORT_WITHOUT_LOCATION, new String[]{""}, null);
            }
            if ((nl = XPathHelper.getXPathResultList(inputDocument.getDocumentElement(), "/wsdl:definitions/wsdl:import")).getLength() != 0) {
                this.reportErrorMessage(MessageTypeEnum.COMPATIBILITY_ERROR_WSDL_CONTAINS_IMPORTS, new String[]{""}, null);
            }
        }
        catch (WSDLException e) {
            LOG.error((Object)("WSDL problem while performing validation: " + e.getMessage()), (Throwable)e);
            this.reportWarningMessage(MessageTypeEnum.SOP_INVALID_WSDL_DOCUMENT, new String[]{e.getMessage()}, null);
        }
    }

    public void validate(IValidationContext pValidationContext, IReporter pReporter) throws SOPValidationException {
        try {
            try {
                this.setReporter(pReporter);
                IValidationObject valObj = pValidationContext.getObject();
                if (valObj == null) {
                    LOG.error((Object)"Empty object as input for validation");
                    throw new ContextInitializationException("Empty object as input for validation");
                }
                Document inputDocument = null;
                try {
                    inputDocument = valObj.getInput();
                }
                catch (ContextInitializationException e) {
                    LOG.error((Object)("Unable to initialize context before validation: " + e.toString()));
                    throw new SOPValidationException("Unable to initialize context before validation", e);
                }
                if (valObj.getID().getType().equals(ValidationObjectTypeEnum.WSDL_TYPE)) {
                    String portType = (String)pValidationContext.getProperty("portType");
                    this.checkSOPwareConstraints(inputDocument, portType);
                } else {
                    LOG.error((Object)"Unsupported type of the validation object");
                }
            }
            catch (SOPValidationException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Object)("Unexpected error during validation: [" + e.getMessage() + "]"), (Throwable)e);
                throw new SOPValidationException("Unexpected error during validation: [" + e.getMessage() + "]", e);
            }
        }
        finally {
            this.setReporter(null);
        }
    }
}

