/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.eid.datamodel.diagram.edit.commands;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.CreateElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.stp.eid.datamodel.ComponentInstance;
import org.eclipse.stp.eid.datamodel.ComponentInstanceProperty;
import org.eclipse.stp.eid.datamodel.Connection;
import org.eclipse.stp.eid.datamodel.PropertyModel;
import org.eclipse.stp.eid.datamodel.cimero2Factory;
import org.eclipse.stp.eid.datamodel.cimero2Package;
import org.eclipse.stp.eid.datamodel.diagram.edit.policies.Cimero2EditorBaseItemSemanticEditPolicy;
import org.eclipse.stp.eid.datamodel.util.LoggerTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionCreateCommand
extends CreateElementCommand {
    private final EObject source;
    private final EObject target;
    private ComponentInstance container;

    public ConnectionCreateCommand(CreateRelationshipRequest request, EObject source, EObject target) {
        super((CreateElementRequest)request);
        this.source = source;
        this.target = target;
        if (request.getContainmentFeature() == null) {
            this.setContainmentFeature(cimero2Package.eINSTANCE.getComponentInstance_SourceConnections());
        }
        EObject element = source;
        while (element != null) {
            if (element instanceof ComponentInstance) {
                this.container = (ComponentInstance)element;
                super.setElementToEdit((EObject)this.container);
                break;
            }
            element = element.eContainer();
        }
    }

    public boolean canExecute() {
        if (this.source == null && this.target == null) {
            return false;
        }
        if (this.source != null && !(this.source instanceof ComponentInstance)) {
            return false;
        }
        if (this.target != null && !(this.target instanceof ComponentInstance)) {
            return false;
        }
        if (this.getSource() == null) {
            return true;
        }
        if (this.getContainer() == null) {
            return false;
        }
        return Cimero2EditorBaseItemSemanticEditPolicy.LinkConstraints.canCreateConnection_3001(this.getContainer(), this.getSource(), this.getTarget());
    }

    protected EObject doDefaultElementCreation() {
        Connection newElement = cimero2Factory.eINSTANCE.createConnection();
        this.getContainer().getSourceConnections().add((Object)newElement);
        newElement.setSource(this.getSource());
        newElement.setTarget(this.getTarget());
        newElement.setMEPValue(newElement.calculateConnectionMepValue());
        if (newElement.getSource().getTheUniqueRoleProperty() != null) {
            newElement.getSource().getTheUniqueRoleProperty().setValue(newElement.getSource().getRole());
        }
        if (newElement.getTarget().getTheUniqueRoleProperty() != null) {
            newElement.getTarget().getTheUniqueRoleProperty().setValue(newElement.getTarget().getRole());
        }
        this.setTargetServiceInterfaceEndpoint(newElement);
        int i = 0;
        while (i < this.getSource().getProperties().size()) {
            ((ComponentInstanceProperty)this.getSource().getProperties().get(i)).reInit();
            ++i;
        }
        i = 0;
        while (i < this.getTarget().getProperties().size()) {
            ((ComponentInstanceProperty)this.getTarget().getProperties().get(i)).reInit();
            ++i;
        }
        return newElement;
    }

    private void setTargetServiceInterfaceEndpoint(Connection newConnection) {
        List targetReferencesProperty = newConnection.getSource().getFreeReferencesToExternalComponents();
        if (targetReferencesProperty.size() > 0) {
            this.setConnectionPropertyAndPropertyReferenceToExternalComponentsValue(targetReferencesProperty, newConnection);
            if (((ComponentInstanceProperty)targetReferencesProperty.get(0)).getParentMEPValue() != null) {
                newConnection.setMEPValue(((ComponentInstanceProperty)targetReferencesProperty.get(0)).getParentMEPValue());
            }
        } else {
            PropertyModel repeatablePropertyWithTargetService = newConnection.getSource().getModel().getTheUniqueRepetableTargetProperty(newConnection.getSource().getRole());
            if (repeatablePropertyWithTargetService != null) {
                ComponentInstanceProperty father = newConnection.getSource().getComponentInstancePropertyFromPropertyModel((PropertyModel)repeatablePropertyWithTargetService.getSuperProperty(), true);
                ComponentInstanceProperty newComponentInstanceProperty = repeatablePropertyWithTargetService.getComponentInstanceProperty(father);
                newComponentInstanceProperty.setName(String.valueOf(newComponentInstanceProperty.getName()) + father.getIdForSubProperties());
                father.setIdForSubProperties(father.getIdForSubProperties() + 1);
                father.getSubProperties().add((Object)newComponentInstanceProperty);
                targetReferencesProperty = father.getFreeReferencesToExternalComponents();
                if (targetReferencesProperty.size() > 0) {
                    this.setConnectionPropertyAndPropertyReferenceToExternalComponentsValue(targetReferencesProperty, newConnection);
                } else {
                    LoggerTool.logger.severe("Unable to find a free target service !");
                }
            }
        }
    }

    private void setConnectionPropertyAndPropertyReferenceToExternalComponentsValue(List<ComponentInstanceProperty> targetReferenceProperty, Connection connection) {
        int i = 0;
        while (i < targetReferenceProperty.size()) {
            connection.getProperties().add((Object)targetReferenceProperty.get(i));
            targetReferenceProperty.get(i).setConnection(connection);
            targetReferenceProperty.get(i).setValue(targetReferenceProperty.get(i).getConnection().getTarget().getReferenceValue(targetReferenceProperty.get(i).getModel().getType()));
            ++i;
        }
    }

    protected EClass getEClassToEdit() {
        return cimero2Package.eINSTANCE.getComponentInstance();
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in create link command");
        }
        return super.doExecuteWithResult(monitor, info);
    }

    protected ConfigureRequest createConfigureRequest() {
        ConfigureRequest request = super.createConfigureRequest();
        request.setParameter("CreateRelationshipRequest.source", (Object)this.getSource());
        request.setParameter("CreateRelationshipRequest.target", (Object)this.getTarget());
        return request;
    }

    protected void setElementToEdit(EObject element) {
        throw new UnsupportedOperationException();
    }

    protected ComponentInstance getSource() {
        return (ComponentInstance)this.source;
    }

    protected ComponentInstance getTarget() {
        return (ComponentInstance)this.target;
    }

    public ComponentInstance getContainer() {
        return this.container;
    }
}

