/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.eid.datamodel.diagram.part;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.gef.Tool;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gmf.runtime.diagram.ui.tools.UnspecifiedTypeConnectionTool;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.stp.eid.datamodel.ComponentModel;
import org.eclipse.stp.eid.datamodel.ComponentType;
import org.eclipse.stp.eid.datamodel.cimero2Factory;
import org.eclipse.stp.eid.datamodel.diagram.part.Messages;
import org.eclipse.stp.eid.datamodel.diagram.part.MyUnspecifiedTypeCreationTool;
import org.eclipse.stp.eid.datamodel.diagram.providers.Cimero2EditorElementTypes;
import org.eclipse.stp.eid.datamodel.diagram.providers.Cimero2EditorIconProvider;
import org.eclipse.stp.eid.datamodel.util.Parser;

public class Cimero2EditorPaletteFactory {
    private void fillPalette(PaletteRoot paletteRoot) {
        paletteRoot.add((PaletteEntry)this.createDataModel1Group());
    }

    private PaletteContainer createDataModel1Group() {
        PaletteGroup paletteContainer = new PaletteGroup(Messages.DataModel1Group_title);
        paletteContainer.add((PaletteEntry)this.createComponentInstance1CreationTool());
        paletteContainer.add((PaletteEntry)this.createConnection2CreationTool());
        return paletteContainer;
    }

    private ToolEntry createComponentInstance1CreationTool() {
        ArrayList<IElementType> types = new ArrayList<IElementType>(1);
        types.add(Cimero2EditorElementTypes.ComponentInstance_1001);
        NodeToolEntry entry = new NodeToolEntry(Messages.ComponentInstance1CreationTool_title, Messages.ComponentInstance1CreationTool_desc, types);
        entry.setSmallIcon(Cimero2EditorElementTypes.getImageDescriptor((IAdaptable)Cimero2EditorElementTypes.ComponentInstance_1001));
        entry.setLargeIcon(entry.getSmallIcon());
        return entry;
    }

    private ToolEntry createConnection2CreationTool() {
        ArrayList<IElementType> types = new ArrayList<IElementType>(1);
        types.add(Cimero2EditorElementTypes.Connection_3001);
        LinkToolEntry entry = new LinkToolEntry(Messages.Connection2CreationTool_title, Messages.Connection2CreationTool_desc, types);
        entry.setSmallIcon(Cimero2EditorElementTypes.getImageDescriptor((IAdaptable)Cimero2EditorElementTypes.Connection_3001));
        entry.setLargeIcon(entry.getSmallIcon());
        return entry;
    }

    public void fillPalette(PaletteRoot paletteRoot, String esbName) {
        PaletteContainer[] myContainers = Cimero2EditorPaletteFactory.createDataModelGroup(esbName);
        int i = 0;
        while (i < myContainers.length) {
            paletteRoot.add((PaletteEntry)myContainers[i]);
            ++i;
        }
    }

    private static PaletteContainer[] createDataModelGroup(String esbName) {
        PaletteContainer[] myContainer = new PaletteContainer[3];
        Parser.initComponentModel();
        Vector componentModelList = cimero2Factory.eINSTANCE.getComponentModelByEsbName(esbName);
        PaletteGroup paletteContainerConnection = new PaletteGroup(Messages.DataModel1Group_title);
        PaletteGroup paletteContainerBC = new PaletteGroup("BC");
        PaletteGroup paletteContainerSE = new PaletteGroup("SE");
        paletteContainerConnection.add((PaletteEntry)Cimero2EditorPaletteFactory.createConnectionCreationTool());
        int i = 0;
        while (i < componentModelList.size()) {
            if (((ComponentModel)componentModelList.get(i)).getType() == ComponentType.BC) {
                paletteContainerBC.add((PaletteEntry)Cimero2EditorPaletteFactory.createComponentInstanceCreationTool(((ComponentModel)componentModelList.get(i)).getName(), ((ComponentModel)componentModelList.get(i)).getPicture()));
            } else {
                paletteContainerSE.add((PaletteEntry)Cimero2EditorPaletteFactory.createComponentInstanceCreationTool(((ComponentModel)componentModelList.get(i)).getName(), ((ComponentModel)componentModelList.get(i)).getPicture()));
            }
            ++i;
        }
        myContainer[0] = paletteContainerConnection;
        myContainer[1] = paletteContainerSE;
        myContainer[2] = paletteContainerBC;
        return myContainer;
    }

    public static ToolEntry createComponentInstanceCreationTool(String componentName, String componentPicture) {
        ArrayList<IElementType> types = new ArrayList<IElementType>(1);
        ImageDescriptor smallImage = Cimero2EditorIconProvider.getIconDescriptor(componentPicture);
        types.add(Cimero2EditorElementTypes.ComponentInstance_1001);
        NodeToolEntry entry = new NodeToolEntry(componentName, "Create new " + componentName, types);
        entry.setSmallIcon(smallImage);
        entry.setLargeIcon(entry.getSmallIcon());
        entry.setId(componentName);
        return entry;
    }

    private static ToolEntry createConnectionCreationTool() {
        ArrayList<IElementType> types = new ArrayList<IElementType>(1);
        types.add(Cimero2EditorElementTypes.Connection_3001);
        LinkToolEntry entry = new LinkToolEntry("Connection", "Create new Connection", types);
        entry.setSmallIcon(Cimero2EditorIconProvider.getIconDescriptor("Connection"));
        entry.setLargeIcon(entry.getSmallIcon());
        return entry;
    }

    private static class LinkToolEntry
    extends ToolEntry {
        private final List relationshipTypes;

        private LinkToolEntry(String title, String description, List relationshipTypes) {
            super(title, description, null, null);
            this.relationshipTypes = relationshipTypes;
        }

        public Tool createTool() {
            UnspecifiedTypeConnectionTool tool = new UnspecifiedTypeConnectionTool(this.relationshipTypes);
            tool.setProperties(this.getToolProperties());
            return tool;
        }
    }

    private static class NodeToolEntry
    extends ToolEntry {
        private final List elementTypes;
        private final String currentComponentName;

        private NodeToolEntry(String title, String description, List elementTypes) {
            super(title, description, null, null);
            this.currentComponentName = title;
            this.elementTypes = elementTypes;
        }

        public Tool createTool() {
            MyUnspecifiedTypeCreationTool tool = new MyUnspecifiedTypeCreationTool(this.elementTypes, this.currentComponentName);
            tool.setProperties(this.getToolProperties());
            return tool;
        }
    }
}

