/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.eid.datamodel.diagram.windows;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.stp.eid.datamodel.Container;
import org.eclipse.stp.eid.datamodel.Graph;
import org.eclipse.stp.eid.datamodel.diagram.part.Cimero2EditorDiagramEditorPlugin;
import org.eclipse.stp.eid.datamodel.diagram.part.Cimero2EditorDiagramEditorUtil;
import org.eclipse.stp.eid.datamodel.diagram.windows.ContainerContentProvider;
import org.eclipse.stp.eid.datamodel.diagram.windows.ContainerLabelProvider;
import org.eclipse.stp.eid.datamodel.diagram.windows.NewContainerWindow;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ManageContainerWindow
extends TitleAreaDialog {
    private Button deleteButton = null;
    private Button editButton = null;
    private SashForm internalSash = null;
    private Table tableContainer = null;
    private TableViewer tbvContainer = null;
    private List<Container> listContainer = new ArrayList<Container>();
    public static final int NEW_CONTAINER_ID = 99002;
    public static final int DELETE_CONTAINER_ID = 99003;
    public static final int EDIT_CONTAINER_ID = 99004;
    private Container selectedContainer = null;

    public ManageContainerWindow(Shell parentShell) {
        super(parentShell);
    }

    public final void create() {
        super.create();
        this.setTitle("Container Repository");
        this.setMessage("Container Repository");
    }

    protected final Control createContents(Composite parent) {
        Control ctrl = super.createContents(parent);
        return ctrl;
    }

    protected final Control createDialogArea(Composite parent) {
        this.internalSash = new SashForm(parent, 0x800200);
        this.internalSash.setLayoutData((Object)new GridData(1808));
        this.tableContainer = new Table((Composite)this.internalSash, 67586);
        this.tableContainer.setLinesVisible(true);
        this.tableContainer.setHeaderVisible(true);
        TableColumn column = null;
        column = new TableColumn(this.tableContainer, 16384);
        column.setText("Host");
        column.setWidth(200);
        column = new TableColumn(this.tableContainer, 16384);
        column.setText("Port");
        column.setWidth(400);
        this.tbvContainer = new TableViewer(this.tableContainer);
        this.tbvContainer.setContentProvider((IContentProvider)new ContainerContentProvider());
        this.tbvContainer.setLabelProvider((IBaseLabelProvider)new ContainerLabelProvider());
        new Cimero2EditorDiagramEditorUtil();
        Graph graph = (Graph)Cimero2EditorDiagramEditorUtil.getModelResource().getContents().get(0);
        this.listContainer = graph.getContainers();
        this.tbvContainer.setInput(this.listContainer);
        ManageContainerWindow theDialog = this;
        this.tableContainer.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                int cfr_ignored_0 = e.keyCode;
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.tbvContainer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TableItem[] selections = theDialog.tableContainer.getSelection();
                if (selections.length > 0) {
                    theDialog.selectedContainer = (Container)selections[0].getData();
                    ManageContainerWindow.this.setMessage("Selected Container " + theDialog.selectedContainer.getId());
                    if (ManageContainerWindow.this.selectedContainer != null) {
                        ManageContainerWindow.this.deleteButton.setEnabled(true);
                        ManageContainerWindow.this.editButton.setEnabled(true);
                    }
                }
            }
        });
        return parent;
    }

    protected final void okPressed() {
        super.okPressed();
    }

    protected final void buttonPressed(int buttonId) {
        if (buttonId == 99002) {
            NewContainerWindow aNewContainerWindow = new NewContainerWindow(this.getShell());
            aNewContainerWindow.open();
            new Cimero2EditorDiagramEditorUtil();
            Graph graph = (Graph)Cimero2EditorDiagramEditorUtil.getModelResource().getContents().get(0);
            this.tbvContainer.setInput((Object)graph.getContainers());
            this.tbvContainer.refresh(true);
            this.internalSash.layout();
        } else if (buttonId == 99003) {
            if (this.selectedContainer != null) {
                this.deleteContainer();
                new Cimero2EditorDiagramEditorUtil();
                Graph graph = (Graph)Cimero2EditorDiagramEditorUtil.getModelResource().getContents().get(0);
                this.tbvContainer.setInput((Object)graph.getContainers());
                this.tbvContainer.refresh(true);
                this.internalSash.layout();
                this.deleteButton.setEnabled(false);
                this.editButton.setEnabled(false);
            }
        } else if (buttonId == 99004 && this.selectedContainer != null) {
            NewContainerWindow aNewContainerWindow = new NewContainerWindow(this.getShell());
            aNewContainerWindow.setCurrentContainer(this.selectedContainer);
            aNewContainerWindow.open();
            new Cimero2EditorDiagramEditorUtil();
            Graph graph = (Graph)Cimero2EditorDiagramEditorUtil.getModelResource().getContents().get(0);
            this.tbvContainer.setInput((Object)graph.getContainers());
            this.tbvContainer.refresh(true);
            this.internalSash.layout();
        }
        super.buttonPressed(buttonId);
    }

    private void deleteContainer() {
        new Cimero2EditorDiagramEditorUtil();
        Graph graph = (Graph)Cimero2EditorDiagramEditorUtil.getModelResource().getContents().get(0);
        TransactionalEditingDomain editingDomain = GMFEditingDomainFactory.INSTANCE.getEditingDomain(new Cimero2EditorDiagramEditorUtil().getResourceSet());
        AbstractTransactionalCommand command = new AbstractTransactionalCommand(editingDomain, "Delete Container", Collections.EMPTY_LIST){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                graph.getContainers().remove((Object)ManageContainerWindow.this.selectedContainer);
                return CommandResult.newOKCommandResult();
            }
        };
        try {
            OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)command, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            Cimero2EditorDiagramEditorPlugin.getInstance().logError("Unable to delete the container " + this.selectedContainer.getId(), e);
        }
    }

    protected final void createButtonsForButtonBar(Composite parent) {
        this.deleteButton = this.createButton(parent, 99003, "Delete Container", true);
        this.deleteButton.setEnabled(false);
        this.editButton = this.createButton(parent, 99004, "Edit Container", true);
        this.editButton.setEnabled(false);
        this.createButton(parent, 99002, "New Container", true);
        this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
    }
}

