/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.eid.datamodel.diagram.windows;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.stp.eid.datamodel.Graph;
import org.eclipse.stp.eid.datamodel.Namespace;
import org.eclipse.stp.eid.datamodel.diagram.part.Cimero2EditorDiagramEditorPlugin;
import org.eclipse.stp.eid.datamodel.diagram.part.Cimero2EditorDiagramEditorUtil;
import org.eclipse.stp.eid.datamodel.diagram.windows.NamespaceContentProvider;
import org.eclipse.stp.eid.datamodel.diagram.windows.NamespaceLabelProvider;
import org.eclipse.stp.eid.datamodel.diagram.windows.NewNamespaceWindow;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ManageNamespaceWindow
extends TitleAreaDialog {
    private Button deleteButton = null;
    private Button editButton = null;
    private SashForm internalSash = null;
    private Table tableNs = null;
    private TableViewer tbvNs = null;
    private List<Namespace> listNs = new ArrayList<Namespace>();
    public static final int NEW_NS_ID = 99002;
    public static final int DELETE_NS_ID = 99003;
    public static final int EDIT_NS_ID = 99004;
    private Namespace selectedNamespace = null;

    public ManageNamespaceWindow(Shell parentShell) {
        super(parentShell);
    }

    public final void create() {
        super.create();
        this.setTitle("Namespace Repository");
        this.setMessage("Namespace Repository");
    }

    protected final Control createContents(Composite parent) {
        Control ctrl = super.createContents(parent);
        return ctrl;
    }

    protected final Control createDialogArea(Composite parent) {
        this.internalSash = new SashForm(parent, 0x800200);
        this.internalSash.setLayoutData((Object)new GridData(1808));
        this.tableNs = new Table((Composite)this.internalSash, 67586);
        this.tableNs.setLinesVisible(true);
        this.tableNs.setHeaderVisible(true);
        TableColumn column = null;
        column = new TableColumn(this.tableNs, 16384);
        column.setText("Prefix");
        column.setWidth(200);
        column = new TableColumn(this.tableNs, 16384);
        column.setText("Value");
        column.setWidth(400);
        this.tbvNs = new TableViewer(this.tableNs);
        this.tbvNs.setContentProvider((IContentProvider)new NamespaceContentProvider());
        this.tbvNs.setLabelProvider((IBaseLabelProvider)new NamespaceLabelProvider());
        new Cimero2EditorDiagramEditorUtil();
        Graph graph = (Graph)Cimero2EditorDiagramEditorUtil.getModelResource().getContents().get(0);
        this.listNs = graph.getNamespaces();
        this.tbvNs.setInput(this.listNs);
        ManageNamespaceWindow theDialog = this;
        this.tableNs.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                int cfr_ignored_0 = e.keyCode;
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.tbvNs.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TableItem[] selections = theDialog.tableNs.getSelection();
                if (selections.length > 0) {
                    theDialog.selectedNamespace = (Namespace)selections[0].getData();
                    ManageNamespaceWindow.this.setMessage("Selected Namespace " + theDialog.selectedNamespace.getPrefix());
                    if (ManageNamespaceWindow.this.selectedNamespace != null) {
                        ManageNamespaceWindow.this.deleteButton.setEnabled(true);
                        ManageNamespaceWindow.this.editButton.setEnabled(true);
                    }
                }
            }
        });
        return parent;
    }

    protected final void okPressed() {
        super.okPressed();
    }

    protected final void buttonPressed(int buttonId) {
        if (buttonId == 99002) {
            NewNamespaceWindow aNewNamespaceWindow = new NewNamespaceWindow(this.getShell());
            aNewNamespaceWindow.open();
            new Cimero2EditorDiagramEditorUtil();
            Graph graph = (Graph)Cimero2EditorDiagramEditorUtil.getModelResource().getContents().get(0);
            this.tbvNs.setInput((Object)graph.getNamespaces());
            this.tbvNs.refresh(true);
            this.internalSash.layout();
        } else if (buttonId == 99003) {
            if (this.selectedNamespace != null) {
                this.deleteNamespace();
                new Cimero2EditorDiagramEditorUtil();
                Graph graph = (Graph)Cimero2EditorDiagramEditorUtil.getModelResource().getContents().get(0);
                this.tbvNs.setInput((Object)graph.getNamespaces());
                this.tbvNs.refresh(true);
                this.internalSash.layout();
                this.deleteButton.setEnabled(false);
                this.editButton.setEnabled(false);
            }
        } else if (buttonId == 99004 && this.selectedNamespace != null) {
            NewNamespaceWindow aNewNamespaceWindow = new NewNamespaceWindow(this.getShell());
            aNewNamespaceWindow.setCurrentNamespace(this.selectedNamespace);
            aNewNamespaceWindow.open();
            new Cimero2EditorDiagramEditorUtil();
            Graph graph = (Graph)Cimero2EditorDiagramEditorUtil.getModelResource().getContents().get(0);
            this.tbvNs.setInput((Object)graph.getNamespaces());
            this.tbvNs.refresh(true);
            this.internalSash.layout();
        }
        super.buttonPressed(buttonId);
    }

    private void deleteNamespace() {
        new Cimero2EditorDiagramEditorUtil();
        Graph graph = (Graph)Cimero2EditorDiagramEditorUtil.getModelResource().getContents().get(0);
        TransactionalEditingDomain editingDomain = GMFEditingDomainFactory.INSTANCE.getEditingDomain(new Cimero2EditorDiagramEditorUtil().getResourceSet());
        AbstractTransactionalCommand command = new AbstractTransactionalCommand(editingDomain, "Delete Namespace", Collections.EMPTY_LIST){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                graph.getNamespaces().remove((Object)ManageNamespaceWindow.this.selectedNamespace);
                return CommandResult.newOKCommandResult();
            }
        };
        try {
            OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)command, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            Cimero2EditorDiagramEditorPlugin.getInstance().logError("Unable to delete the namespace " + this.selectedNamespace.getPrefix(), e);
        }
    }

    protected final void createButtonsForButtonBar(Composite parent) {
        this.deleteButton = this.createButton(parent, 99003, "Delete Namespace", true);
        this.deleteButton.setEnabled(false);
        this.editButton = this.createButton(parent, 99004, "Edit Namespace", true);
        this.editButton.setEnabled(false);
        this.createButton(parent, 99002, "New Namespace", true);
        this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
    }
}

