/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.eid.datamodel.diagram.windows;

import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.stp.eid.datamodel.Container;
import org.eclipse.stp.eid.datamodel.Graph;
import org.eclipse.stp.eid.datamodel.cimero2Factory;
import org.eclipse.stp.eid.datamodel.diagram.part.Cimero2EditorDiagramEditorPlugin;
import org.eclipse.stp.eid.datamodel.diagram.part.Cimero2EditorDiagramEditorUtil;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewContainerWindow
extends TitleAreaDialog {
    private Composite aComposite = null;
    private CLabel containerHostLabel = null;
    private Text containerHostText = null;
    private CLabel containerPortLabel = null;
    private Text containerPortTextField = null;
    private Container selectedContainer = null;

    public NewContainerWindow(Shell parentShell) {
        super(parentShell);
    }

    public final void create() {
        super.create();
        this.setTitle("Edit Container");
        this.setMessage("Edit Container ");
    }

    protected final Control createContents(Composite parent) {
        Control ctrl = super.createContents(parent);
        return ctrl;
    }

    protected final Control createDialogArea(Composite parent) {
        this.aComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 15;
        layout.marginHeight = 10;
        layout.numColumns = 5;
        this.aComposite.setLayout((Layout)layout);
        this.aComposite.setLayoutData((Object)new GridData(768));
        GridData data = new GridData(768);
        data.widthHint = 200;
        data.horizontalSpan = 4;
        this.containerHostLabel = new CLabel(this.aComposite, 131072);
        this.containerHostLabel.setText(" Host ");
        this.containerHostText = new Text(this.aComposite, 0x800800);
        data = new GridData(768);
        data.widthHint = 200;
        data.horizontalSpan = 4;
        this.containerHostText.setLayoutData((Object)data);
        if (this.selectedContainer != null) {
            this.containerHostText.setText(this.selectedContainer.getHostName());
        }
        this.containerPortLabel = new CLabel(this.aComposite, 131072);
        this.containerPortLabel.setText(" Port ");
        this.containerPortTextField = new Text(this.aComposite, 0x800800);
        data = new GridData(768);
        data.widthHint = 200;
        data.horizontalSpan = 4;
        this.containerPortTextField.setLayoutData((Object)data);
        if (this.selectedContainer != null) {
            this.containerPortTextField.setText(String.valueOf(this.selectedContainer.getPort()));
        }
        return parent;
    }

    protected final void okPressed() {
        if (this.containerHostText.getText().trim().length() > 0 && this.containerPortTextField.getText().trim().length() > 0) {
            try {
                new Cimero2EditorDiagramEditorUtil();
                Graph graph = (Graph)Cimero2EditorDiagramEditorUtil.getModelResource().getContents().get(0);
                TransactionalEditingDomain editingDomain = GMFEditingDomainFactory.INSTANCE.getEditingDomain(new Cimero2EditorDiagramEditorUtil().getResourceSet());
                AbstractTransactionalCommand command = new AbstractTransactionalCommand(editingDomain, "New Container", Collections.EMPTY_LIST){

                    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                        if (NewContainerWindow.this.selectedContainer == null) {
                            Container container = cimero2Factory.eINSTANCE.createContainer();
                            container.setHostName(NewContainerWindow.this.containerHostText.getText());
                            container.setPort(Integer.parseInt(NewContainerWindow.this.containerPortTextField.getText()));
                            graph.getContainers().add((Object)container);
                        } else {
                            NewContainerWindow.this.selectedContainer.setHostName(NewContainerWindow.this.containerHostText.getText());
                            NewContainerWindow.this.selectedContainer.setPort(Integer.parseInt(NewContainerWindow.this.containerPortTextField.getText()));
                        }
                        return CommandResult.newOKCommandResult();
                    }
                };
                try {
                    OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)command, (IProgressMonitor)new NullProgressMonitor(), null);
                }
                catch (ExecutionException e) {
                    Cimero2EditorDiagramEditorPlugin.getInstance().logError("Unable to add container ", e);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            super.okPressed();
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)"CimeroEditor Plug-in", (String)"To add a container you must set the host name and the port");
        }
    }

    protected final void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
    }

    public final void setCurrentContainer(Container theSelectedContainer) {
        this.selectedContainer = theSelectedContainer;
    }
}

