/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.eid;

import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.stp.eid.IComponent;
import org.eclipse.stp.eid.internal.ComponentImpl;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentRegistry {
    private HashMap<String, IComponent> componentMap;
    private static final String PLUGIN_ID = "org.eclipse.stp.eid";
    private static final String EXTENSION_EIP_COMPONENT = "eipComponent";
    private static ComponentRegistry registry;

    public ComponentRegistry() {
        registry = this;
        this.componentMap = new HashMap();
    }

    public static ComponentRegistry getInstance() {
        return registry;
    }

    public void initialize() {
        this.initializeComponentRegistry();
    }

    public Collection<IComponent> getComponents() {
        return this.componentMap.values();
    }

    private void initializeComponentRegistry() {
        IExtensionRegistry extregistry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = extregistry.getConfigurationElementsFor(PLUGIN_ID, EXTENSION_EIP_COMPONENT);
        int i = 0;
        while (i < cf.length) {
            ComponentImpl compo;
            String bundleId = cf[i].getContributor().getName();
            Bundle provider = Platform.getBundle((String)bundleId);
            String name = cf[i].getAttribute("name");
            String id = cf[i].getAttribute("id");
            String category = cf[i].getAttribute("category");
            if (!this.componentMap.containsKey(id)) {
                compo = new ComponentImpl(name, category);
                this.componentMap.put(id, compo);
            } else {
                compo = (ComponentImpl)this.componentMap.get(id);
            }
            compo.setModelResource(provider.getResource(cf[i].getAttribute("model")));
            compo.setLargeIconResource(provider.getResource(cf[i].getAttribute("largeIcon")));
            compo.setSmallIconResource(provider.getResource(cf[i].getAttribute("smallIcon")));
            IConfigurationElement[] desc = cf[i].getChildren("description");
            StringBuilder description = new StringBuilder();
            int j = 0;
            while (i < desc.length) {
                description.append(desc[j].getValue());
                ++j;
            }
            compo.setDescription(description.toString());
            ++i;
        }
    }
}

