/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.eid;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.stp.eid.datamodel.ComponentInstance;
import org.eclipse.stp.eid.datamodel.ComponentInstanceProperty;

public class ModelHelpers {
    public static String getEndpointURI(ComponentInstance compo) {
        if (compo != null) {
            for (ComponentInstanceProperty prop : compo.getProperties()) {
                if (!prop.getModel().getType().equals("URI")) continue;
                return ModelHelpers.expandVariables(prop.getValue());
            }
        }
        return null;
    }

    private static String expandVariables(String value) {
        try {
            VariablesPlugin vp = VariablesPlugin.getDefault();
            if (vp != null) {
                value = vp.getStringVariableManager().performStringSubstitution(value);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        value = value.replace('\\', '/');
        return value;
    }
}

