/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.eid.datamodel;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum RoleType implements Enumerator
{
    PROVIDER(0, "Provider", "Provider"),
    CONSUMER(1, "Consumer", "Consumer"),
    BOTH(2, "Both", "Both");

    public static final int PROVIDER_VALUE = 0;
    public static final int CONSUMER_VALUE = 1;
    public static final int BOTH_VALUE = 2;
    private static final RoleType[] VALUES_ARRAY;
    public static final List<RoleType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new RoleType[]{PROVIDER, CONSUMER, BOTH};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static RoleType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RoleType result = VALUES_ARRAY[i];
            if (result.toString().compareTo(literal) == 0) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RoleType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RoleType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RoleType get(int value) {
        switch (value) {
            case 0: {
                return PROVIDER;
            }
            case 1: {
                return CONSUMER;
            }
            case 2: {
                return BOTH;
            }
        }
        return null;
    }

    private RoleType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

