/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.im.tool.in.bpmneditor.dnd.handler;

import java.util.HashMap;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.DataObject;
import org.eclipse.stp.bpmn.MessagingEdge;
import org.eclipse.stp.bpmn.NamedBpmnObject;
import org.eclipse.stp.bpmn.Pool;
import org.eclipse.stp.bpmn.SequenceEdge;
import org.eclipse.stp.bpmn.TextAnnotation;
import org.eclipse.stp.bpmn.dnd.AbstractEAnnotationDnDHandler;
import org.eclipse.stp.im.runtime.IExpression;
import org.eclipse.stp.im.runtime.IProperty;
import org.eclipse.stp.im.runtime.IRuntime;
import org.eclipse.stp.im.runtime.ImRuntimeActivator;
import org.eclipse.stp.im.tool.in.bpmneditor.BpmnEditorExtensionActivator;
import org.eclipse.stp.im.tool.in.bpmneditor.view.ExpressionTreeElement;
import org.eclipse.swt.graphics.Image;

public class ExpressionDndHandler
extends AbstractEAnnotationDnDHandler {
    private String expressionName = null;
    private String runtimeID = null;
    private String expressionType = null;

    public ExpressionDndHandler(ExpressionTreeElement expressionTreeElement) {
        this.runtimeID = expressionTreeElement.getRuntimeId();
        this.expressionName = expressionTreeElement.getName();
        this.expressionType = expressionTreeElement.getType();
    }

    public Command getDropCommand(IGraphicalEditPart hoverPart, int index, Point dropLocation) {
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("im.pool.runtimeID", this.runtimeID);
        details.put("im.transition.conditionname", this.expressionName);
        details.put("im.transition.type", this.expressionType);
        IRuntime runtime = ImRuntimeActivator.getRuntime((String)this.runtimeID);
        IExpression expression = runtime.getExpressionWithName(this.expressionName);
        for (IProperty property : expression.getDefinedProperties()) {
            if (property.isMap()) continue;
            String value = property.getDefaultValue() != null ? property.getDefaultValue() : "";
            details.put(property.getName(), value);
        }
        return this.createEAnnotationDropCommand(this.createAnnotation("imtransition", details), (EModelElement)hoverPart.resolveSemanticElement());
    }

    public int getItemCount() {
        return 1;
    }

    public Image getMenuItemImage(IGraphicalEditPart hoverPart, int index) {
        return BpmnEditorExtensionActivator.getImageDescriptor("icons/ico_condition.gif").createImage();
    }

    public String getMenuItemLabel(IGraphicalEditPart hoverPart, int index) {
        EObject element = hoverPart.resolveSemanticElement();
        String suffix = " on " + this.getShapeLabel((NamedBpmnObject)element);
        return "Attach Condition [" + this.expressionName + "] on " + suffix;
    }

    public int getPriority() {
        return 0;
    }

    protected String getShapeLabel(NamedBpmnObject namedElement) {
        String name;
        String string = name = namedElement.getName() != null && namedElement.getName().length() > 0 ? namedElement.getName() : "";
        if (name.length() > 18) {
            name = String.valueOf(name.substring(0, 12)) + "...";
        }
        if (namedElement instanceof Pool) {
            if (name.indexOf("pool") == -1) {
                return "pool " + name;
            }
            return name;
        }
        if (namedElement instanceof Activity) {
            String shape = ((Activity)namedElement).getActivityType().getLiteral();
            if (name.indexOf(shape) == -1) {
                return String.valueOf(shape) + " " + name;
            }
            return name;
        }
        if (namedElement instanceof MessagingEdge) {
            String shape = "message";
            if (name.indexOf(shape) == -1) {
                return String.valueOf(shape) + " " + name;
            }
            return name;
        }
        if (namedElement instanceof SequenceEdge) {
            String shape = "sequence";
            if (name.indexOf(shape) == -1) {
                return String.valueOf(shape) + " " + name;
            }
            return name;
        }
        if (namedElement instanceof Diagram) {
            String shape = "diagram";
            if (name.indexOf(shape) == -1) {
                return String.valueOf(shape) + " " + name;
            }
            return name;
        }
        if (namedElement instanceof TextAnnotation) {
            String shape = "annotation";
            if (name.indexOf(shape) == -1) {
                return "text " + shape + " " + name;
            }
            return name;
        }
        if (namedElement instanceof DataObject) {
            String shape = "object";
            if (name.indexOf(shape) == -1) {
                return "data " + shape + " " + name;
            }
            return name;
        }
        return name;
    }

    public boolean isEnabled(IGraphicalEditPart hoverPart, int index) {
        EModelElement emodelElement = (EModelElement)hoverPart.resolveSemanticElement();
        return emodelElement instanceof SequenceEdge || emodelElement instanceof MessagingEdge;
    }
}

