/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.im.tool.in.bpmneditor.section;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.properties.sections.AdvancedPropertySection;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.MessagingEdge;
import org.eclipse.stp.bpmn.SequenceEdge;
import org.eclipse.stp.im.runtime.IElementDefiningProperties;
import org.eclipse.stp.im.runtime.IProperty;
import org.eclipse.stp.im.runtime.IRuntime;
import org.eclipse.stp.im.runtime.ImRuntimeActivator;
import org.eclipse.stp.im.runtime.comboproviders.ComboEntries;
import org.eclipse.stp.im.runtime.comboproviders.CustomComboPropertyDescriptor;
import org.eclipse.stp.im.runtime.comboproviders.IComboProvider;
import org.eclipse.stp.im.runtime.comboproviders.ValuesProvidedByInContextExtractorComboProvider;
import org.eclipse.stp.im.runtime.property.listeners.IPropertyListener;
import org.eclipse.stp.im.tool.in.bpmneditor.extractor.IBpmnModelExtractor;
import org.eclipse.stp.im.util.ImLogger;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class IntermediateModelPropertySection
extends AdvancedPropertySection
implements IPropertySourceProvider {
    public IPropertySource getPropertySource(Object object) {
        EAnnotation ea = null;
        if (object instanceof Activity) {
            ea = ((Activity)object).getEAnnotation("im");
        } else if (object instanceof SequenceEdge) {
            ea = ((SequenceEdge)object).getEAnnotation("imtransition");
        } else if (object instanceof MessagingEdge) {
            ea = ((MessagingEdge)object).getEAnnotation("imtransition");
        } else {
            return null;
        }
        if (ea != null) {
            return new IntermediateModelAnnotationPropertySource((EObject)object, ea);
        }
        return null;
    }

    protected Object transformSelection(Object selected) {
        View view;
        if (selected instanceof EditPart) {
            Object model = ((EditPart)selected).getModel();
            return model instanceof View ? ((View)model).getElement() : null;
        }
        if (selected instanceof View) {
            return ((View)selected).getElement();
        }
        if (selected instanceof IAdaptable && (view = (View)((IAdaptable)selected).getAdapter(View.class)) != null) {
            return view.getElement();
        }
        return selected;
    }

    protected IPropertySourceProvider getPropertySourceProvider() {
        return this;
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        Object unknownInput = ((IStructuredSelection)selection).getFirstElement();
        if (unknownInput == null) {
            return;
        }
        Object newInput = this.transformSelection(unknownInput);
        if (newInput == null) {
            return;
        }
        super.setInput(part, (ISelection)new StructuredSelection(newInput));
    }

    protected AdapterFactory getAdapterFactory(Object object) {
        if (this.getEditingDomain() instanceof AdapterFactoryEditingDomain) {
            return ((AdapterFactoryEditingDomain)this.getEditingDomain()).getAdapterFactory();
        }
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((Object)object);
        if (editingDomain != null) {
            return ((AdapterFactoryEditingDomain)editingDomain).getAdapterFactory();
        }
        return null;
    }

    public class IntermediateModelAnnotationPropertySource
    implements IPropertySource {
        private transient List<IPropertyDescriptor> descriptorList = null;
        private static final String IM_CATEGORY = "00 - IntermediateModel";
        private static final String DEFAULT_PROP_CATEGORY = "01 - Step Properties";
        private EAnnotation ea = null;
        private EObject emfObject = null;
        private IRuntime imRuntime = null;
        private IElementDefiningProperties elementDefiningProperties = null;

        public IntermediateModelAnnotationPropertySource(EObject emfObject, EAnnotation ea) {
            this.ea = ea;
            this.emfObject = emfObject;
            if (ea.getSource().equalsIgnoreCase("im")) {
                String runtimeId = (String)ea.getDetails().get((Object)"im.pool.runtimeID");
                String serviceBindingName = (String)ea.getDetails().get((Object)"im.servicebindingname");
                this.imRuntime = ImRuntimeActivator.getRuntime((String)runtimeId);
                this.elementDefiningProperties = (IElementDefiningProperties)this.imRuntime.getServiceBindings().get(serviceBindingName);
                if (this.elementDefiningProperties == null) {
                    System.out.println(" Binding [" + serviceBindingName + "] Not found");
                }
            } else if (ea.getSource().equalsIgnoreCase("imtransition")) {
                String runtimeId = (String)ea.getDetails().get((Object)"im.pool.runtimeID");
                String expressionName = (String)ea.getDetails().get((Object)"im.transition.conditionname");
                this.imRuntime = ImRuntimeActivator.getRuntime((String)runtimeId);
                this.elementDefiningProperties = this.imRuntime.getExpressionWithName(expressionName);
                if (this.elementDefiningProperties == null) {
                    System.out.println(" Expression [" + expressionName + "] Not found");
                }
            }
        }

        public Object getEditableValue() {
            return this;
        }

        public IPropertyDescriptor[] getPropertyDescriptors() {
            this.descriptorList = new ArrayList<IPropertyDescriptor>();
            this.createDescriptorForBindingAnnotation();
            IPropertyDescriptor[] myDescTable = new IPropertyDescriptor[this.descriptorList.size()];
            int indice = 0;
            for (IPropertyDescriptor it : this.descriptorList) {
                myDescTable[indice++] = it;
            }
            return myDescTable;
        }

        protected void createDescriptorForBindingAnnotation() {
            HashMap<String, Integer> counterForCategoryMap = new HashMap<String, Integer>();
            this.addReadOnlyTextDescriptor("im.pool.runtimeID", "01 - Runtime", IM_CATEGORY);
            if (this.ea.getSource().equalsIgnoreCase("im")) {
                this.addReadOnlyTextDescriptor("im.servicename", "02 - Service", IM_CATEGORY);
                this.addReadOnlyTextDescriptor("im.servicebindingname", "03 - Service Binding", IM_CATEGORY);
            }
            if (this.ea.getSource().equalsIgnoreCase("imtransition")) {
                this.addReadOnlyTextDescriptor("im.transition.conditionname", "02 - Condition Expression", IM_CATEGORY);
            }
            counterForCategoryMap.clear();
            Integer counter = null;
            String counterString = null;
            String category = DEFAULT_PROP_CATEGORY;
            counterForCategoryMap.put(DEFAULT_PROP_CATEGORY, 0);
            for (IProperty prop : this.elementDefiningProperties.getDefinedProperties()) {
                if (prop.getUiCategoratory() != null) {
                    category = prop.getUiCategoratory();
                }
                if (!this.isVisible(prop)) continue;
                counter = counterForCategoryMap.containsKey(category) ? (Integer)counterForCategoryMap.get(category) : Integer.valueOf(0);
                counter = counter + 1;
                counterForCategoryMap.put(category, counter);
                counterString = this.getCounterString(counter);
                if (prop.isText()) {
                    if (prop.isEditable()) {
                        this.addTextDescriptor(prop.getName(), String.valueOf(counterString) + " - " + prop.getLabel(), category);
                        continue;
                    }
                    this.addReadOnlyTextDescriptor(prop.getName(), String.valueOf(counterString) + " - " + prop.getLabel(), category);
                    continue;
                }
                if (!prop.isCombo()) continue;
                IComboProvider comboProvider = prop.getComboProvider();
                if (comboProvider instanceof ValuesProvidedByInContextExtractorComboProvider) {
                    String extractorClassName = (String)comboProvider.getParams().get("inContextExtractorClassName");
                    try {
                        IBpmnModelExtractor bpmnModelExtractor = (IBpmnModelExtractor)Class.forName(extractorClassName).newInstance();
                        bpmnModelExtractor.setContextObject(this.emfObject);
                        ((ValuesProvidedByInContextExtractorComboProvider)comboProvider).setValues(bpmnModelExtractor.getValues());
                        ((ValuesProvidedByInContextExtractorComboProvider)comboProvider).setLabels(bpmnModelExtractor.getLabels());
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        ImLogger.error((String)"org.eclipse.stp.im.tool.in.bpmneditor", (String)t.getMessage(), (Throwable)t);
                    }
                }
                ComboEntries ce = comboProvider.getComboEntries();
                this.addComboBoxDescriptor(prop.getName(), String.valueOf(counterString) + " - " + prop.getLabel(), ce, category);
            }
            category = null;
            String idxMapPropertyString = null;
            String displayName = null;
            IProperty mapProp = null;
            Map mapPropertiesFieldsEditorMap = null;
            String mapFieldEditor = null;
            String mapPropertyName = null;
            for (String s : this.ea.getDetails().keySet()) {
                if (s.indexOf("[") <= 0) continue;
                mapPropertyName = category = s.substring(0, s.indexOf("["));
                displayName = s.substring(s.indexOf("]") + 2);
                idxMapPropertyString = s.substring(s.indexOf("[") + 1, s.indexOf("]"));
                category = String.valueOf(category) + " - " + idxMapPropertyString;
                mapProp = this.elementDefiningProperties.getDefinedPropertyByName(mapPropertyName);
                mapPropertiesFieldsEditorMap = mapProp.getMapFieldsEditorsMap();
                if (mapPropertiesFieldsEditorMap != null && mapPropertiesFieldsEditorMap.containsKey(displayName)) {
                    mapFieldEditor = (String)mapPropertiesFieldsEditorMap.get(displayName);
                    if (mapFieldEditor.startsWith("combo")) {
                        String comboName = mapFieldEditor.substring(mapFieldEditor.indexOf("(") + 1, mapFieldEditor.indexOf(")"));
                        IComboProvider comboProvider = this.imRuntime.getNamedComboProvider(comboName);
                        ComboEntries ce = comboProvider.getComboEntries();
                        this.addComboBoxDescriptor(s, displayName, ce, category);
                        continue;
                    }
                    this.addTextDescriptor(s, displayName, category);
                    continue;
                }
                this.addTextDescriptor(s, displayName, category);
            }
        }

        public final void addDescriptor(IPropertyDescriptor myDescr) {
            this.descriptorList.add(myDescr);
        }

        protected final void addReadOnlyTextDescriptor(String id, String displayName) {
            this.descriptorList.add((IPropertyDescriptor)new PropertyDescriptor((Object)id, displayName));
        }

        protected final void addReadOnlyTextDescriptor(String id, String displayName, String category) {
            PropertyDescriptor pDescr = new PropertyDescriptor((Object)id, displayName);
            pDescr.setCategory(category);
            this.descriptorList.add((IPropertyDescriptor)pDescr);
        }

        protected final void addTextDescriptor(String id, String displayName) {
            this.descriptorList.add((IPropertyDescriptor)new TextPropertyDescriptor((Object)id, displayName));
        }

        protected final void addTextDescriptor(String id, String displayName, String category) {
            TextPropertyDescriptor pDescr = new TextPropertyDescriptor((Object)id, displayName);
            pDescr.setCategory(category);
            this.descriptorList.add((IPropertyDescriptor)pDescr);
        }

        protected final void addComboBoxDescriptor(String id, String displayName, ComboEntries entries) {
            this.descriptorList.add((IPropertyDescriptor)new CustomComboPropertyDescriptor(id, displayName, entries, 0));
        }

        protected final void addComboBoxDescriptor(String id, String displayName, ComboEntries entries, String category) {
            CustomComboPropertyDescriptor pDescr = new CustomComboPropertyDescriptor(id, displayName, entries, 0);
            pDescr.setCategory(category);
            this.descriptorList.add((IPropertyDescriptor)pDescr);
        }

        public Object getPropertyValue(Object propertyID) {
            return this.getAnnotationProperty((String)propertyID);
        }

        public boolean isPropertySet(Object propertyId) {
            System.out.println(" Is PropertySet(" + propertyId + ")");
            return true;
        }

        public void resetPropertyValue(Object propertyId) {
            System.out.println(" resetPropertyValue (" + propertyId + ")");
        }

        public void setPropertyValue(Object propertyID, Object propertyValue) {
            String thePropertyID = (String)propertyID;
            if (thePropertyID.equalsIgnoreCase("im.pool.runtimeID") || thePropertyID.equalsIgnoreCase("im.servicebindingname") || thePropertyID.equalsIgnoreCase("im.servicename")) {
                this.setAnnotationProperty((String)propertyID, propertyValue);
                return;
            }
            if (!this.isMapEntry(thePropertyID)) {
                IProperty propertyDef = this.elementDefiningProperties.getDefinedPropertyByName(thePropertyID);
                String dependentPropertyName = null;
                if (propertyDef != null) {
                    dependentPropertyName = propertyDef.getDependentProperty();
                } else {
                    ImLogger.warning((String)"org.eclipse.stp.im.tool.in.bpmneditor", (String)(" Not found property with name [" + propertyID + "]"));
                }
                if (dependentPropertyName != null) {
                    IProperty dependentProperty = this.elementDefiningProperties.getDefinedPropertyByName(dependentPropertyName);
                    IPropertyListener listener = propertyDef.getPropertyListener();
                    if (listener != null) {
                        System.out.println(" Notifyng Listener ");
                        listener.handleUpdate((String)propertyValue, propertyDef.getDependentProperty(), dependentProperty, this.ea);
                    }
                }
            }
            this.setAnnotationProperty((String)propertyID, propertyValue);
        }

        protected Object getAnnotationProperty(String propertyName) {
            return this.ea.getDetails().get((Object)propertyName);
        }

        protected void setAnnotationProperty(String propertyName, Object value) {
            this.ea.getDetails().put((Object)propertyName, (Object)((String)value));
        }

        protected boolean isMapEntry(String propertyID) {
            return propertyID.indexOf("[") > 0;
        }

        protected boolean isVisible(IProperty prop) {
            if (!prop.isVisibleUnderCondition()) {
                return true;
            }
            return this.evaluateVisibilityCondition(prop.getVisibleCondition());
        }

        protected boolean evaluateVisibilityCondition(String visibleCondition) {
            if (visibleCondition.startsWith("if-is-true")) {
                String propName = visibleCondition.substring(visibleCondition.indexOf("(") + 1, visibleCondition.indexOf(")"));
                String value = (String)this.ea.getDetails().get((Object)propName);
                return Boolean.valueOf(value);
            }
            if (visibleCondition.startsWith("if-is-false")) {
                String propName = visibleCondition.substring(visibleCondition.indexOf("(") + 1, visibleCondition.indexOf(")"));
                String value = (String)this.ea.getDetails().get((Object)propName);
                return Boolean.valueOf(value) == false;
            }
            if (visibleCondition.startsWith("if-has-value")) {
                String propName = visibleCondition.substring(visibleCondition.indexOf("(") + 1, visibleCondition.indexOf(","));
                String valueToEnableVisibility = visibleCondition.substring(visibleCondition.indexOf(",") + 1, visibleCondition.indexOf(")"));
                String value = (String)this.ea.getDetails().get((Object)propName);
                return valueToEnableVisibility.equalsIgnoreCase(value);
            }
            if (visibleCondition.startsWith("if-isone-of")) {
                String propName = visibleCondition.substring(visibleCondition.indexOf("(") + 1, visibleCondition.indexOf(","));
                String valueToEnableVisibility = visibleCondition.substring(visibleCondition.indexOf(",") + 1, visibleCondition.indexOf(")"));
                String arrValues = valueToEnableVisibility.substring(1, valueToEnableVisibility.length() - 1);
                System.out.println("values -> " + arrValues);
                String[] splitterArr = arrValues.split(";");
                List<String> splittedValues = Arrays.asList(splitterArr);
                String value = (String)this.ea.getDetails().get((Object)propName);
                return splittedValues.contains(value);
            }
            return false;
        }

        protected String getCounterString(int counter) {
            if (counter > 9) {
                return String.valueOf(counter);
            }
            return "0" + String.valueOf(counter);
        }
    }
}

