/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.im.tool.in.bpmneditor.view;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stp.bpmn.Pool;
import org.eclipse.stp.im.runtime.IExpression;
import org.eclipse.stp.im.runtime.IRuntime;
import org.eclipse.stp.im.runtime.IService;
import org.eclipse.stp.im.runtime.ImRuntimeActivator;
import org.eclipse.stp.im.tool.in.bpmneditor.BpmnEditorExtensionActivator;
import org.eclipse.stp.im.tool.in.bpmneditor.view.ConditionsTreeElement;
import org.eclipse.stp.im.tool.in.bpmneditor.view.ExpressionTreeElement;
import org.eclipse.stp.im.tool.in.bpmneditor.view.RubberTreeElement;
import org.eclipse.stp.im.tool.in.bpmneditor.view.ServiceBindingTreeElement;
import org.eclipse.stp.im.tool.in.bpmneditor.view.ServiceTreeElement;
import org.eclipse.stp.im.tool.in.bpmneditor.view.ServiceTreeModel;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class ImView
extends ViewPart
implements ISelectionListener {
    private static Object[] EMPTY_ARRAY = new Object[0];
    private TreeViewer tree = null;
    private IWorkbenchPage page = null;

    public ImView() {
        System.out.println(" ---> ( - ImView - ) ");
        if (PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() != null) {
            this.page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            this.page.addSelectionListener((ISelectionListener)this);
            System.out.println(" ---> ( - Added Bindings Views as Selction Listener on Workbench - )");
        }
        System.out.println(" ---> ( - End Constructor - )");
    }

    public void dispose() {
        System.out.println(" ---> ( - ImView - ) disposed ");
        if (this.page != null) {
            this.page.removeSelectionListener((ISelectionListener)this);
        }
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        System.out.println(" Bindings View Create Part Control");
        this.tree = new TreeViewer(parent);
        this.tree.setContentProvider((IContentProvider)new ImViewContentProvider());
        this.tree.setLabelProvider((IBaseLabelProvider)new ImViewLabelProvider());
        int ops = 3;
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        ImDragAdapter drag = new ImDragAdapter();
        this.tree.addDragSupport(ops, transfers, (DragSourceListener)drag);
    }

    public ServiceTreeElement getInputForRuntime(IRuntime runtime) {
        ServiceTreeElement root = new ServiceTreeElement();
        if (runtime == null) {
            ServiceTreeElement noRuntimeNode = new ServiceTreeElement("No Runtime Selected");
            root.addServiceTreeElement(noRuntimeNode);
            root.addServiceTreeElement(new RubberTreeElement("Delete Annotations"));
            return root;
        }
        ServiceTreeElement runtimeNode = new ServiceTreeElement("Runtime - " + runtime.getName());
        for (IService iService : runtime.getServices()) {
            ServiceTreeElement aServiceTreeElement = new ServiceTreeElement(iService.getName());
            ServiceBindingTreeElement aServiceBindingTreeElement = null;
            for (String bindingStr : iService.getServiceBindingsName()) {
                aServiceBindingTreeElement = new ServiceBindingTreeElement(bindingStr);
                aServiceBindingTreeElement.setRuntimeId(runtime.getId());
                aServiceTreeElement.addServiceBindingTreeElement(aServiceBindingTreeElement);
            }
            runtimeNode.addServiceTreeElement(aServiceTreeElement);
        }
        ConditionsTreeElement conditions = new ConditionsTreeElement("Expressions");
        for (IExpression expression : runtime.getExpressions()) {
            ExpressionTreeElement expressionTreeElement = new ExpressionTreeElement(expression.getName(), expression.getType());
            expressionTreeElement.setRuntimeId(runtime.getId());
            conditions.addExpression(expressionTreeElement);
        }
        runtimeNode.addServiceTreeElement(conditions);
        root.addServiceTreeElement(runtimeNode);
        root.addServiceTreeElement(new RubberTreeElement("Delete Annotations"));
        return root;
    }

    public void setFocus() {
    }

    public void selectionChanged(IWorkbenchPart workbenchPart, ISelection selection) {
        System.out.println("Workbench Part -> " + workbenchPart + "Selection -> " + selection);
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        if (!((IStructuredSelection)selection).isEmpty()) {
            Pool pool;
            EAnnotation ea;
            Object unknownInput = ((IStructuredSelection)selection).getFirstElement();
            Object newInput = this.transformSelection(unknownInput);
            if (newInput instanceof Pool && (ea = (pool = (Pool)newInput).getEAnnotation("technology")) != null) {
                String runtimeID = (String)ea.getDetails().get((Object)"im.pool.runtimeID");
                System.out.println(" Runtime ID [" + runtimeID + "]");
                IRuntime selectedRuntime = ImRuntimeActivator.getRuntime((String)runtimeID);
                this.setTitle(" Bindings for Runtime " + selectedRuntime.getName());
                this.setContentDescription(" Bindings for Runtime " + selectedRuntime.getName());
                this.tree.setInput((Object)this.getInputForRuntime(selectedRuntime));
                this.tree.refresh(true);
            }
        } else {
            System.out.println(" Structured Selection Is Empty");
        }
    }

    protected Object transformSelection(Object selected) {
        View view;
        if (selected instanceof EditPart) {
            Object model = ((EditPart)selected).getModel();
            return model instanceof View ? ((View)model).getElement() : null;
        }
        if (selected instanceof View) {
            return ((View)selected).getElement();
        }
        if (selected instanceof IAdaptable && (view = (View)((IAdaptable)selected).getAdapter(View.class)) != null) {
            return view.getElement();
        }
        return selected;
    }

    private class ImDragAdapter
    extends DragSourceAdapter {
        private ImDragAdapter() {
        }

        public void dragStart(DragSourceEvent event) {
            System.out.println("**************************** Drag Start");
            LocalSelectionTransfer.getTransfer().setSelection(ImView.this.tree.getSelection());
        }
    }

    private class ImViewContentProvider
    implements ITreeContentProvider {
        private ImViewContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ServiceTreeElement) {
                if (parentElement instanceof ConditionsTreeElement) {
                    ConditionsTreeElement ct = (ConditionsTreeElement)parentElement;
                    return ct.getExpressions().toArray();
                }
                ServiceTreeElement st = (ServiceTreeElement)parentElement;
                return this.concat(st.getServices().toArray(), st.getBindings().toArray());
            }
            return EMPTY_ARRAY;
        }

        protected Object[] concat(Object[] object, Object[] more) {
            Object[] both = new Object[object.length + more.length];
            System.arraycopy(object, 0, both, 0, object.length);
            System.arraycopy(more, 0, both, object.length, more.length);
            return both;
        }

        public Object getParent(Object element) {
            if (element instanceof ServiceTreeModel) {
                return ((ServiceTreeModel)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
        }
    }

    private class ImViewLabelProvider
    extends LabelProvider {
        private Map<ImageDescriptor, Image> imageCache = new HashMap<ImageDescriptor, Image>(11);

        private ImViewLabelProvider() {
        }

        public Image getImage(Object element) {
            ImageDescriptor descriptor = null;
            if (element instanceof ConditionsTreeElement) {
                descriptor = BpmnEditorExtensionActivator.getImageDescriptor("icons/ico_condition.gif");
            } else if (element instanceof RubberTreeElement) {
                descriptor = BpmnEditorExtensionActivator.getImageDescriptor("icons/ico_disconnect.gif");
            } else if (element instanceof ServiceTreeElement) {
                descriptor = BpmnEditorExtensionActivator.getImageDescriptor("icons/ico_service.gif");
            } else if (element instanceof ServiceBindingTreeElement) {
                descriptor = BpmnEditorExtensionActivator.getImageDescriptor("icons/ico_servicebinding.gif");
            } else if (element instanceof ExpressionTreeElement) {
                descriptor = BpmnEditorExtensionActivator.getImageDescriptor("icons/ico_expression.gif");
            } else {
                throw this.unknownElement(element);
            }
            Image image = this.imageCache.get(descriptor);
            if (image == null) {
                image = descriptor.createImage();
                this.imageCache.put(descriptor, image);
            }
            return image;
        }

        public String getText(Object element) {
            if (element instanceof ServiceTreeElement) {
                if (((ServiceTreeElement)element).getName() == null) {
                    return "Service";
                }
                return ((ServiceTreeElement)element).getName();
            }
            if (element instanceof ServiceBindingTreeElement) {
                return ((ServiceBindingTreeElement)element).getName();
            }
            if (element instanceof ExpressionTreeElement) {
                return ((ExpressionTreeElement)element).getName();
            }
            throw this.unknownElement(element);
        }

        public void dispose() {
            Iterator<Image> i = this.imageCache.values().iterator();
            while (i.hasNext()) {
                i.next().dispose();
            }
            this.imageCache.clear();
        }

        protected RuntimeException unknownElement(Object element) {
            return new RuntimeException("Unknown type of element in tree of type " + element.getClass().getName());
        }
    }
}

