/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.policy.wtp.editor.editparts;

import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.Panel;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.stp.policy.wtp.editor.editparts.EditPartNavigationHandlerUtil;
import org.eclipse.stp.policy.wtp.editor.editparts.PolicyEditPart;
import org.eclipse.stp.policy.wtp.editor.figures.CollapsibleFigure;
import org.eclipse.stp.policy.wtp.editor.figures.ExpandFigure;
import org.eclipse.stp.policy.wtp.editor.figures.TopLineAbstractBackground;
import org.eclipse.stp.policy.wtp.editor.model.PolicyCompositeModel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.wst.wsdl.ui.internal.asd.design.DesignViewGraphicsConstants;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.BaseEditPart;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editpolicies.ASDSelectionEditPolicy;

public class PolicyCompositeEditPart
extends BaseEditPart {
    private IFigure contentPane;
    private Label label;
    private Color unselectedColor = null;
    private ExpandFigure expandFigure;

    protected IFigure createFigure() {
        Panel figure = new Panel();
        figure.setBorder((Border)new TopLineAbstractBackground());
        ToolbarLayout toolbarLayout = new ToolbarLayout(false);
        toolbarLayout.setStretchMinorAxis(true);
        figure.setLayoutManager((LayoutManager)toolbarLayout);
        Figure labelHolder = new Figure();
        toolbarLayout = new ToolbarLayout(true);
        labelHolder.setLayoutManager((LayoutManager)toolbarLayout);
        labelHolder.setBorder((Border)new MarginBorder(0, PolicyEditPart.getIdent((EditPart)this), 0, 0));
        figure.add((IFigure)labelHolder);
        this.expandFigure = new ExpandFigure();
        this.expandFigure.setBorder((Border)new MarginBorder(6, 3, 2, 2));
        labelHolder.add((IFigure)this.expandFigure);
        this.label = new Label();
        this.label.setBorder((Border)new MarginBorder(2, 2, 2, 2));
        this.label.setTextAlignment(1);
        labelHolder.add((IFigure)this.label);
        this.contentPane = new CollapsibleFigure();
        toolbarLayout = new ToolbarLayout(false);
        toolbarLayout.setStretchMinorAxis(true);
        this.contentPane.setLayoutManager((LayoutManager)toolbarLayout);
        figure.add(this.contentPane);
        if (this.isReadOnly()) {
            this.label.setForegroundColor(DesignViewGraphicsConstants.readOnlyLabelColor);
            figure.setBackgroundColor(DesignViewGraphicsConstants.readOnlyTableOperationHeadingColor);
        } else {
            this.label.setForegroundColor(ColorConstants.black);
            figure.setBackgroundColor(DesignViewGraphicsConstants.tableOperationHeadingColor);
        }
        return figure;
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("Selection Feedback", (EditPolicy)new ASDSelectionEditPolicy());
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        PolicyCompositeModel policyCompositeModel = (PolicyCompositeModel)((Object)this.getModel());
        this.label.setText(policyCompositeModel.getText());
        this.label.setIcon(policyCompositeModel.getImage());
        this.expandFigure.setVisible(!this.getModelChildren().isEmpty());
    }

    public IFigure getContentPane() {
        return this.contentPane;
    }

    protected List getModelChildren() {
        PolicyCompositeModel policyCompositeModel = (PolicyCompositeModel)((Object)this.getModel());
        return policyCompositeModel.getModelChildren();
    }

    public void addFeedback() {
        if (this.unselectedColor == null) {
            this.unselectedColor = this.getFigure().getBackgroundColor();
            this.getFigure().setBackgroundColor(DesignViewGraphicsConstants.tableCellSelectionColor);
        }
    }

    public void removeFeedback() {
        if (this.unselectedColor != null) {
            this.getFigure().setBackgroundColor(this.unselectedColor);
            this.unselectedColor = null;
        }
    }

    public EditPart getRelativeEditPart(int direction) {
        EditPart editPart = super.getRelativeEditPart(direction);
        editPart = EditPartNavigationHandlerUtil.translateOperationPolicyEditPart((EditPart)this, editPart, direction);
        return editPart;
    }

    public void performRequest(Request request) {
        if (request.getType() == "open") {
            this.expandFigure.setExpanded(!this.expandFigure.isExpanded());
            this.getContentPane().setVisible(this.expandFigure.isExpanded());
            this.refresh();
        }
    }
}

