/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.common.utils;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CXFUtil {
    private static final Set<String> KEYWORDS = new HashSet<String>((Collection)Arrays.asList("abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "true", "false", "null", "assert", "enum"));

    private CXFUtil() {
    }

    public static URL[] pathToURLs(String path) {
        StringTokenizer st = new StringTokenizer(path, File.pathSeparator);
        URL[] urls = new URL[st.countTokens()];
        int count = 0;
        while (st.hasMoreTokens()) {
            File file = new File(st.nextToken());
            URL url = null;
            try {
                url = file.toURL();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            if (url == null) continue;
            urls[count++] = url;
        }
        if (urls.length != count) {
            URL[] tmp = new URL[count];
            System.arraycopy(urls, 0, tmp, 0, count);
            urls = tmp;
        }
        return urls;
    }

    public static String parsePackageName(String namespace, String defaultPackageName) {
        String packageName;
        String string = packageName = defaultPackageName != null && defaultPackageName.trim().length() > 0 ? defaultPackageName : null;
        if (packageName == null) {
            packageName = CXFUtil.getPackageName(namespace);
        }
        return packageName;
    }

    public static String getPackageName(String nameSpaceURI) {
        List<String> r;
        String domain;
        String lastToken;
        List<String> tokens;
        int idx = nameSpaceURI.indexOf(58);
        String scheme = "";
        if (idx >= 0 && ("http".equalsIgnoreCase(scheme = nameSpaceURI.substring(0, idx)) || "urn".equalsIgnoreCase(scheme))) {
            nameSpaceURI = nameSpaceURI.substring(idx + 1);
        }
        if ((tokens = CXFUtil.tokenize(nameSpaceURI, "/: ")).size() == 0) {
            return null;
        }
        if (tokens.size() > 1 && (idx = (lastToken = tokens.get(tokens.size() - 1)).lastIndexOf(46)) > 0) {
            lastToken = lastToken.substring(0, idx);
            tokens.set(tokens.size() - 1, lastToken);
        }
        if ((idx = (domain = tokens.get(0)).indexOf(58)) >= 0) {
            domain = domain.substring(0, idx);
        }
        if ("www".equalsIgnoreCase((r = CXFUtil.reverse(CXFUtil.tokenize(domain, "urn".equals(scheme) ? ".-" : "."))).get(r.size() - 1))) {
            r.remove(r.size() - 1);
        }
        tokens.addAll(1, r);
        tokens.remove(0);
        int i = 0;
        while (i < tokens.size()) {
            String token = tokens.get(i);
            if (CXFUtil.containsReservedKeywords(token = CXFUtil.removeIllegalIdentifierChars(token))) {
                token = String.valueOf('_') + token;
            }
            tokens.set(i, token.toLowerCase());
            ++i;
        }
        return CXFUtil.combine(tokens, '.');
    }

    public static String getNamespace(String packageName) {
        String[] tokens;
        if (packageName == null || packageName.length() == 0) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(packageName, ".");
        if (tokenizer.countTokens() == 0) {
            tokens = new String[]{};
        } else {
            tokens = new String[tokenizer.countTokens()];
            int i = tokenizer.countTokens() - 1;
            while (i >= 0) {
                tokens[i] = tokenizer.nextToken();
                --i;
            }
        }
        StringBuffer namespace = new StringBuffer("http://");
        String dot = "";
        int i = 0;
        while (i < tokens.length) {
            if (i == 1) {
                dot = ".";
            }
            namespace.append(String.valueOf(dot) + tokens[i]);
            ++i;
        }
        namespace.append('/');
        return namespace.toString();
    }

    private static List<String> tokenize(String str, String sep) {
        StringTokenizer tokens = new StringTokenizer(str, sep);
        ArrayList<String> r = new ArrayList<String>();
        while (tokens.hasMoreTokens()) {
            r.add(tokens.nextToken());
        }
        return r;
    }

    private static String removeIllegalIdentifierChars(String token) {
        StringBuffer newToken = new StringBuffer();
        int i = 0;
        while (i < token.length()) {
            char c = token.charAt(i);
            if (i == 0 && !Character.isJavaIdentifierStart(c)) {
                newToken.append("_" + c);
            } else if (!Character.isJavaIdentifierPart(c)) {
                newToken.append('_');
            } else {
                newToken.append(c);
            }
            ++i;
        }
        return newToken.toString();
    }

    private static String combine(List r, char sep) {
        StringBuilder buf = new StringBuilder(r.get(0).toString());
        int i = 1;
        while (i < r.size()) {
            buf.append(sep);
            buf.append(r.get(i));
            ++i;
        }
        return buf.toString();
    }

    private static <T> List<T> reverse(List<T> a) {
        ArrayList<T> r = new ArrayList<T>();
        int i = a.size() - 1;
        while (i >= 0) {
            r.add(a.get(i));
            --i;
        }
        return r;
    }

    public static boolean containsReservedKeywords(String token) {
        return KEYWORDS.contains(token);
    }

    public static String normalize(String uri) {
        URL url = null;
        try {
            url = new URL(uri);
            return url.toString().replace("\\", "/");
        }
        catch (MalformedURLException e1) {
            try {
                String f = null;
                f = uri.indexOf(":") != -1 && !uri.startsWith("/") ? "file:/" + uri : "file:" + uri;
                url = new URL(f);
                return url.toString().replace("\\", "/");
            }
            catch (MalformedURLException e2) {
                return uri.replace("\\", "/");
            }
        }
    }

    public static String getAbsoluteURI(String arg) {
        try {
            URL url = new URL(CXFUtil.normalize(arg));
            if (url.toURI().isOpaque() && "file".equalsIgnoreCase(url.getProtocol())) {
                return new File("").toURI().resolve(url.getPath()).toString();
            }
            return CXFUtil.normalize(arg);
        }
        catch (MalformedURLException e1) {
            return CXFUtil.normalize(arg);
        }
        catch (URISyntaxException e2) {
            return CXFUtil.normalize(arg);
        }
    }
}

