/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.common.utils;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.stp.common.logging.LoggingProxy;

public class LaunchUtil {
    private static final LoggingProxy LOG = LoggingProxy.getlogger(LaunchUtil.class);

    public static void launchJavaProgram(IJavaProject javaProject, String mainClass, String[] vmArgs, String[] prgArgs, String[] clsPath) throws CoreException {
        IVMRunner vmRunner;
        IVMInstall vmInstall = JavaRuntime.getVMInstall((IJavaProject)javaProject);
        if (vmInstall == null) {
            vmInstall = JavaRuntime.getDefaultVMInstall();
        }
        if (vmInstall != null && (vmRunner = vmInstall.getVMRunner("run")) != null) {
            String[] prjDefaultClsPath = null;
            try {
                prjDefaultClsPath = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)javaProject);
            }
            catch (CoreException e) {
                prjDefaultClsPath = null;
            }
            String[] newClassPath = LaunchUtil.combinStringArray(prjDefaultClsPath, clsPath);
            if (newClassPath != null) {
                VMRunnerConfiguration vmConfig = new VMRunnerConfiguration(mainClass, newClassPath);
                if (vmArgs != null && vmArgs.length > 0) {
                    vmConfig.setVMArguments(vmArgs);
                }
                if (prgArgs != null && prgArgs.length > 0) {
                    vmConfig.setProgramArguments(prgArgs);
                }
                Launch launch = new Launch(null, "run", null);
                vmRunner.run(vmConfig, (ILaunch)launch, null);
                while (!launch.isTerminated()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ex) {
                        LOG.error((Object)ex);
                    }
                }
                IProcess[] processes = launch.getProcesses();
                String errMsg = processes[0].getStreamsProxy().getErrorStreamMonitor().getContents();
                if (errMsg != null && errMsg.length() > 0) {
                    LOG.info((Object)errMsg);
                }
            }
        }
    }

    public static String[] combinStringArray(String[] arg0, String[] arg1) {
        String[] returnValue = null;
        int size = 0;
        if (arg0 != null) {
            size = arg0.length;
        }
        if (arg1 != null) {
            size += arg1.length;
        }
        if (size > 0) {
            returnValue = new String[size];
            if (arg0 != null) {
                System.arraycopy(arg0, 0, returnValue, 0, arg0.length);
            }
            if (arg1 != null) {
                System.arraycopy(arg1, 0, returnValue, size - arg1.length, arg1.length);
            }
        }
        return returnValue;
    }
}

