/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.cxf.generators;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.cxf.generators.CxfJava2wsGenerator;
import org.eclipse.stp.sc.cxf.generators.ToolConstants;
import org.eclipse.stp.sc.jaxws.properties.ScJaxWsPropertyConstants;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IJavaToWsdlGenerator;

public class CeltixJavaToWsdlGenerator
implements IJavaToWsdlGenerator {
    private static final LoggingProxy LOG = LoggingProxy.getlogger(CeltixJavaToWsdlGenerator.class);

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    public void run(IPath path, IProject project) throws CoreException {
        try {
            String fileName = project.getPersistentProperty(ScJaxWsPropertyConstants.PROPERTY_KEY_STARTING_POINT);
            IFile file = project.getFile((IPath)new Path(fileName));
            LOG.info((Object)("generate WSDL for " + file.getLocation().toOSString()));
            CxfJava2wsGenerator generator = CxfJava2wsGenerator.getInstance();
            String genServer = project.getPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_SERVER);
            String genClient = project.getPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_CLIENT);
            String genWsdl = project.getPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_WSDL);
            project.setPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_WSDL, "true");
            project.setPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_SERVER, "false");
            project.setPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_CLIENT, "false");
            generator.run(project);
            project.setPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_WSDL, genWsdl);
            project.setPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_SERVER, genServer);
            project.setPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_CLIENT, genClient);
            project.refreshLocal(2, null);
        }
        catch (Throwable e) {
            LOG.error((Object)"Celtix Java To Wsdl Generation failure", e);
        }
    }
}

