/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.cxf.generators;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.cxf.CXFResources;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IParameterPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CeltixWsdlToJavaParameterPage
implements IParameterPage {
    public static final String KEY_BINDING_FILE_LIST = "KEY_BINDING_FILE_LIST";
    private static final LoggingProxy LOG = LoggingProxy.getlogger(CeltixWsdlToJavaParameterPage.class);
    Button btBindingFile = null;
    Text txtBindingFiles = null;
    Button btBrowse = null;
    Button btImpl = null;
    Button btServer = null;
    Button btClient = null;
    Button btExsh = null;
    Button btDns = null;
    Button btDex = null;
    Button btAnt = null;
    Button btVerbose = null;
    HashMap<String, Object> params = new HashMap();
    Shell parentShell = null;
    WizardPage hostPage = null;
    String wsdlUrl;

    public Control createContents(Composite parent) {
        this.parentShell = parent.getShell();
        Composite compBinding = new Composite(parent, 0);
        compBinding.setLayoutData((Object)new GridData(768));
        compBinding.setLayout((Layout)new GridLayout(2, false));
        this.btBindingFile = new Button(compBinding, 32);
        this.btBindingFile.setText(CXFResources.getString("Wsdl.To.Java.BindingFile.Checkbox.Text"));
        this.btBindingFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CeltixWsdlToJavaParameterPage.this.txtBindingFiles.setEnabled(CeltixWsdlToJavaParameterPage.this.btBindingFile.getSelection());
                CeltixWsdlToJavaParameterPage.this.btBrowse.setEnabled(CeltixWsdlToJavaParameterPage.this.btBindingFile.getSelection());
                CeltixWsdlToJavaParameterPage.this.validateParams();
            }
        });
        new Text(compBinding, 23).setVisible(false);
        this.txtBindingFiles = new Text(compBinding, 2052);
        this.txtBindingFiles.setLayoutData((Object)new GridData(768));
        this.txtBindingFiles.setEnabled(false);
        this.txtBindingFiles.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CeltixWsdlToJavaParameterPage.this.validateParams();
            }
        });
        this.btBrowse = new Button(compBinding, 8);
        this.btBrowse.setText(CXFResources.getString("Wsdl.To.Java.Browse.Binding.Button"));
        this.btBrowse.setEnabled(false);
        this.btBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LOG.debug((Object)"Browsing button is pressed");
                FileDialog fileChooser = new FileDialog(CeltixWsdlToJavaParameterPage.this.parentShell, 4098);
                String result = fileChooser.open();
                if (result != null) {
                    String[] names = fileChooser.getFileNames();
                    String path = fileChooser.getFilterPath();
                    StringBuffer sbValue = new StringBuffer();
                    int i = 0;
                    while (i < names.length) {
                        sbValue.append(String.valueOf(path) + names[i]);
                        if (i < names.length - 1) {
                            sbValue.append(", ");
                        }
                        ++i;
                    }
                    CeltixWsdlToJavaParameterPage.this.txtBindingFiles.setText(sbValue.toString());
                }
                CeltixWsdlToJavaParameterPage.this.validateParams();
            }
        });
        Group grpCodeGenCat = new Group(parent, 0);
        grpCodeGenCat.setLayoutData((Object)new GridData(768));
        grpCodeGenCat.setLayout((Layout)new GridLayout(3, true));
        grpCodeGenCat.setText(CXFResources.getString("Wsdl.To.Java.Code.Category.Group.Text"));
        this.btImpl = new Button((Composite)grpCodeGenCat, 32);
        this.btImpl.setText(CXFResources.getString("Wsdl.To.Java.Code.Gen.Impl.Button"));
        this.btImpl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CeltixWsdlToJavaParameterPage.this.btImpl.getSelection()) {
                    CeltixWsdlToJavaParameterPage.this.params.put("-impl", "");
                } else {
                    CeltixWsdlToJavaParameterPage.this.params.remove("-impl");
                }
                CeltixWsdlToJavaParameterPage.this.validateParams();
            }
        });
        this.btImpl.setSelection(true);
        this.params.put("-impl", "");
        this.btServer = new Button((Composite)grpCodeGenCat, 32);
        this.btServer.setText(CXFResources.getString("Wsdl.To.Java.Code.Gen.Server.Button"));
        this.btServer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CeltixWsdlToJavaParameterPage.this.btServer.getSelection()) {
                    CeltixWsdlToJavaParameterPage.this.params.put("-server", "");
                } else {
                    CeltixWsdlToJavaParameterPage.this.params.remove("-server");
                }
                CeltixWsdlToJavaParameterPage.this.validateParams();
            }
        });
        this.btServer.setSelection(true);
        this.params.put("-server", "");
        this.btClient = new Button((Composite)grpCodeGenCat, 32);
        this.btClient.setText(CXFResources.getString("Wsdl.To.Java.Code.Gen.Client.Button"));
        this.btClient.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CeltixWsdlToJavaParameterPage.this.btClient.getSelection()) {
                    CeltixWsdlToJavaParameterPage.this.params.put("-client", "");
                } else {
                    CeltixWsdlToJavaParameterPage.this.params.remove("-client");
                }
                CeltixWsdlToJavaParameterPage.this.validateParams();
            }
        });
        this.btClient.setSelection(true);
        this.params.put("-client", "");
        Composite compOthers = new Composite(parent, 0);
        compOthers.setLayoutData((Object)new GridData(768));
        compOthers.setLayout((Layout)new GridLayout(1, false));
        this.btExsh = new Button(compOthers, 32);
        this.btExsh.setText(CXFResources.getString("Wsdl.To.Java.Other.Exsh.Text"));
        this.btExsh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CeltixWsdlToJavaParameterPage.this.btExsh.getSelection()) {
                    CeltixWsdlToJavaParameterPage.this.params.put("-exsh", "");
                } else {
                    CeltixWsdlToJavaParameterPage.this.params.remove("-exsh");
                }
                CeltixWsdlToJavaParameterPage.this.validateParams();
            }
        });
        this.btExsh.setSelection(true);
        this.params.put("-exsh", "");
        this.btDns = new Button(compOthers, 32);
        this.btDns.setText(CXFResources.getString("Wsdl.To.Java.Other.Dns.Text"));
        this.btDns.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CeltixWsdlToJavaParameterPage.this.btDns.getSelection()) {
                    CeltixWsdlToJavaParameterPage.this.params.put("-dns", "");
                } else {
                    CeltixWsdlToJavaParameterPage.this.params.remove("-dns");
                }
                CeltixWsdlToJavaParameterPage.this.validateParams();
            }
        });
        this.btDns.setSelection(true);
        this.params.put("-dns", "");
        this.btDex = new Button(compOthers, 32);
        this.btDex.setText(CXFResources.getString("Wsdl.To.Java.Other.Dex.Text"));
        this.btDex.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CeltixWsdlToJavaParameterPage.this.btDex.getSelection()) {
                    CeltixWsdlToJavaParameterPage.this.params.put("-dex", "");
                } else {
                    CeltixWsdlToJavaParameterPage.this.params.remove("-dex");
                }
                CeltixWsdlToJavaParameterPage.this.validateParams();
            }
        });
        this.btDex.setSelection(true);
        this.params.put("-dex", "");
        Label lbSep = new Label(parent, 258);
        lbSep.setLayoutData((Object)new GridData(768));
        Composite compMisc = new Composite(parent, 0);
        compMisc.setLayoutData((Object)new GridData(768));
        compMisc.setLayout((Layout)new GridLayout(2, false));
        this.btAnt = new Button(compMisc, 32);
        this.btAnt.setText(CXFResources.getString("Wsdl.To.Java.Mist.Ant.Text"));
        this.btAnt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CeltixWsdlToJavaParameterPage.this.btAnt.getSelection()) {
                    CeltixWsdlToJavaParameterPage.this.params.put("-ant", "");
                } else {
                    CeltixWsdlToJavaParameterPage.this.params.remove("-ant");
                }
                CeltixWsdlToJavaParameterPage.this.validateParams();
            }
        });
        this.btVerbose = new Button(compMisc, 32);
        this.btVerbose.setText(CXFResources.getString("Wsdl.To.Java.Mist.Verbose.Text"));
        this.btVerbose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CeltixWsdlToJavaParameterPage.this.btVerbose.getSelection()) {
                    CeltixWsdlToJavaParameterPage.this.params.put("-verbose", "");
                } else {
                    CeltixWsdlToJavaParameterPage.this.params.remove("-verbose");
                }
                CeltixWsdlToJavaParameterPage.this.validateParams();
            }
        });
        return parent;
    }

    public Map<String, Object> getParameters() {
        return this.params;
    }

    public void performOK() {
        if (this.btBindingFile.getSelection()) {
            String bFileStr = this.btBindingFile.getText();
            StringTokenizer tkzr = new StringTokenizer(bFileStr, ",");
            ArrayList<String> listFiles = new ArrayList<String>();
            while (tkzr.hasMoreTokens()) {
                String fPath = tkzr.nextToken();
                listFiles.add(fPath);
            }
            this.params.put(KEY_BINDING_FILE_LIST, listFiles);
        }
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    public String validateParams() {
        String result = null;
        if (this.btBindingFile.getSelection()) {
            if (this.txtBindingFiles.getText().trim().equals("")) {
                result = CXFResources.getString("Wsdl.To.Java.Param.Binding.File.Empty");
            } else {
                String bFileStr = this.txtBindingFiles.getText();
                StringTokenizer tkzr = new StringTokenizer(bFileStr, ",");
                while (tkzr.hasMoreTokens()) {
                    String fPath = tkzr.nextToken();
                    LOG.debug((Object)("File Path: " + fPath));
                    File file = new File(fPath);
                    if (!file.exists()) {
                        result = String.valueOf(CXFResources.getString("Wsdl.To.Java.Param.File.Not.Exist")) + fPath;
                        break;
                    }
                    if (!file.isDirectory()) continue;
                    result = String.valueOf(CXFResources.getString("Wsdl.To.Java.Param.File.Is.Dir")) + fPath;
                    break;
                }
            }
        }
        if (!(result != null || this.btImpl.getSelection() || this.btServer.getSelection() || this.btClient.getSelection())) {
            result = CXFResources.getString("Wsdl.To.Java.Param.No.Gen.Type");
        }
        this.hostPage.setErrorMessage(result);
        this.hostPage.setPageComplete(result == null);
        return result;
    }

    public void setPage(WizardPage page) {
        this.hostPage = page;
    }

    public void setWsdlUrl(String url) {
        LOG.debug((Object)("set WsdlURL called:" + url));
        this.wsdlUrl = url;
    }
}

