/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.generators.types;

import java.util.ArrayList;
import java.util.List;
import javax.jws.Oneway;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.utils.JDTUtils;
import org.eclipse.stp.sc.jaxws.annotations.WebParamAnnInfo;
import org.eclipse.stp.sc.jaxws.annotations.WebResultAnnInfo;
import org.eclipse.stp.sc.jaxws.utils.JaxBindAnnotationUtils;
import org.eclipse.stp.sc.jaxws.utils.ScJDTUtils;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxBindTypeGenerator {
    public static final String ANNOTATION_WRAPPER_LOCALNAME = "localName";
    public static final String ANNOTATION_WRAPPER_CLASSNAME = "className";
    public static final String ANNOTATION_WRAPPER_TARGETNAMESPACE = "targetNamespace";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String DEFAULT_PACKAGE_NAME = "jaxws";
    private static final String DEFAULT_ARG_PREFIX = "arg";
    private static final int MODE_UNKNOWN = 0;
    private static final int MODE_REQUEST = 1;
    private static final int MODE_RESPONSE = 2;
    private static final LoggingProxy LOG = LoggingProxy.getlogger(JaxBindTypeGenerator.class);
    String className = "";
    String targetNamespace = "";
    String localName = "";
    ICompilationUnit sei;
    IPackageFragment pkgFragment = null;
    private ArrayList<String> xmlTypeList = new ArrayList();
    private ArrayList<String> importList = new ArrayList();

    public void createWrapperCls(ICompilationUnit seiUnit) {
        this.sei = seiUnit;
        try {
            IMethod[] methods;
            IMethod[] iMethodArray = methods = seiUnit.findPrimaryType().getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                List annotations = JDTUtils.getAnnotations((IMember)method);
                this.createWrappClsByAnnotations(method, annotations);
                ++n2;
            }
        }
        catch (Exception e) {
            LOG.error((Object)"error during generate java class", (Throwable)e);
        }
    }

    protected void createWrappClsByAnnotations(IMethod method, List<Annotation> annotations) throws Exception {
        boolean genRequestWrapper = false;
        boolean genResponseWrapper = false;
        boolean hasOneWayAnnotation = false;
        for (Annotation an : annotations) {
            int mode = 0;
            String name = an.getTypeName().getFullyQualifiedName();
            if (name.equals(RequestWrapper.class.getSimpleName())) {
                mode = 1;
                genRequestWrapper = true;
                this.setupDefaultValue(method, 1);
            } else if (name.equals(ResponseWrapper.class.getSimpleName())) {
                mode = 2;
                genResponseWrapper = true;
                this.setupDefaultValue(method, 2);
            } else {
                if (!name.equals(Oneway.class.getSimpleName())) continue;
                hasOneWayAnnotation = true;
                continue;
            }
            NormalAnnotation normalAnn = (NormalAnnotation)an;
            List list = normalAnn.values();
            for (MemberValuePair valuePair : list) {
                String attrKey = valuePair.getName().getFullyQualifiedName();
                String value = ((StringLiteral)valuePair.getValue()).getLiteralValue();
                if (attrKey.equals(ANNOTATION_WRAPPER_LOCALNAME)) {
                    this.localName = value;
                    continue;
                }
                if (attrKey.equals(ANNOTATION_WRAPPER_CLASSNAME)) {
                    this.className = value;
                    continue;
                }
                if (!attrKey.equals(ANNOTATION_WRAPPER_TARGETNAMESPACE)) continue;
                this.targetNamespace = value;
            }
            this.createWrapperCls(method, mode, null);
        }
        if (!genRequestWrapper) {
            this.setupDefaultValue(method, 1);
            this.createWrapperCls(method, 1, null);
        }
        if (!genResponseWrapper && !hasOneWayAnnotation) {
            this.setupDefaultValue(method, 2);
            this.createWrapperCls(method, 2, null);
        }
    }

    protected void setupDefaultValue(IMethod method, int mode) throws JavaModelException {
        this.localName = mode == 1 ? method.getElementName() : String.valueOf(method.getElementName()) + "Response";
        String pkgName = "";
        IPackageDeclaration[] pkgDecs = this.sei.getPackageDeclarations();
        if (pkgDecs.length == 0) {
            pkgName = "";
            this.className = "jaxws." + this.localName.substring(0, 1).toUpperCase() + this.localName.substring(1);
        } else {
            pkgName = this.sei.getPackageDeclarations()[0].getElementName();
            this.className = String.valueOf(pkgName) + "." + DEFAULT_PACKAGE_NAME + "." + this.localName.substring(0, 1).toUpperCase() + this.localName.substring(1);
        }
        LOG.debug((Object)("default wrapper cls name:" + this.className));
        this.targetNamespace = JDTUtils.getNamespace((String)pkgName);
        LOG.debug((Object)("default wrapper ns:" + this.targetNamespace));
    }

    protected void createWrapperCls(IMethod webMethod, int mode, IProgressMonitor monitor) throws Exception {
        this.xmlTypeList.clear();
        this.importList.clear();
        ICompilationUnit wrapperCls = this.createEmptyWrapperUnit(webMethod, monitor);
        this.addClsAnnotation(wrapperCls, webMethod);
        this.processFields(wrapperCls.getTypes()[0], webMethod, mode);
        this.addXmlTypeAnnotation(wrapperCls);
        this.addImport(wrapperCls);
        wrapperCls.save(monitor, true);
        LOG.debug((Object)("generated wrapper class:" + this.className));
    }

    private ICompilationUnit createEmptyWrapperUnit(IMethod webMethod, IProgressMonitor monitor) throws CoreException {
        String unitFileName;
        String unitName = this.className.substring(this.className.lastIndexOf(".") + 1);
        String packageName = this.className.substring(0, this.className.lastIndexOf("."));
        IPackageFragment pkg = this.getPackageFragment(webMethod.getResource(), packageName);
        ICompilationUnit oldCls = pkg.getCompilationUnit(unitFileName = String.valueOf(unitName) + ".java");
        if (oldCls.getResource().exists()) {
            oldCls.getResource().delete(true, null);
            LOG.debug((Object)("delete previous generated type file:" + unitFileName));
        }
        ICompilationUnit wrapperCls = pkg.createCompilationUnit(unitFileName, "", true, monitor);
        wrapperCls.createPackageDeclaration(packageName, null);
        wrapperCls.createImport(XmlAccessType.class.getName(), null, monitor);
        wrapperCls.createImport(XmlAccessorType.class.getName(), null, monitor);
        wrapperCls.createImport(XmlElement.class.getName(), null, monitor);
        wrapperCls.createImport(XmlRootElement.class.getName(), null, monitor);
        wrapperCls.createImport(XmlType.class.getName(), null, monitor);
        StringBuffer contents = new StringBuffer();
        contents.append("public class " + unitName + " {" + LINE_SEPARATOR);
        contents.append("}" + LINE_SEPARATOR);
        wrapperCls.createType(contents.toString(), null, true, monitor);
        return wrapperCls;
    }

    private IPackageFragment getPackageFragment(IResource seiFile, String packageName) throws JavaModelException {
        IJavaProject javaProject = JDTUtils.findJavaProject((String)seiFile.getProject().getName());
        IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
        IPackageFragmentRoot srcRoot = null;
        IPackageFragmentRoot[] iPackageFragmentRootArray = roots;
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
            if (root.getKind() == 1) {
                srcRoot = root;
                break;
            }
            ++n2;
        }
        this.pkgFragment = srcRoot.getPackageFragment(packageName);
        if (!this.pkgFragment.exists()) {
            this.pkgFragment = srcRoot.createPackageFragment(packageName, true, null);
        }
        if (!this.pkgFragment.isOpen()) {
            this.pkgFragment.open(null);
        }
        return this.pkgFragment;
    }

    private CompilationUnit createAstTree(ICompilationUnit unit) throws JavaModelException {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(unit);
        CompilationUnit astRoot = (CompilationUnit)parser.createAST(null);
        return astRoot;
    }

    private void addClsAnnotation(ICompilationUnit unit, IMethod method) throws JavaModelException, MalformedTreeException, BadLocationException {
        CompilationUnit astRoot = this.createAstTree(unit);
        AST ast = astRoot.getAST();
        QualifiedName qName = ast.newQualifiedName((Name)ast.newSimpleName("XmlAccessType"), ast.newSimpleName(XmlAccessType.FIELD.name()));
        SingleMemberAnnotation singleAnn = JaxBindAnnotationUtils.newXmlAccessorTypeAnnotation(astRoot, (Expression)qName);
        this.addAnnotation(unit, astRoot, (Annotation)singleAnn, (IMember)unit.findPrimaryType());
        NormalAnnotation xmlRootElementAnn = JaxBindAnnotationUtils.newXmlRootElemntAnnotation(astRoot, this.localName);
        this.addAnnotation(unit, astRoot, (Annotation)xmlRootElementAnn, (IMember)unit.findPrimaryType());
    }

    private void addXmlTypeAnnotation(ICompilationUnit unit) throws Exception {
        CompilationUnit astRoot = this.createAstTree(unit);
        NormalAnnotation xmlTypeAnn = JaxBindAnnotationUtils.newXmlTypeAnnotation(astRoot, "", this.xmlTypeList.toArray(new String[0]));
        this.addAnnotation(unit, astRoot, (Annotation)xmlTypeAnn, (IMember)unit.findPrimaryType());
    }

    private void processFields(IType wrapperClsType, IMethod method, int mode) throws Exception {
        String typeString;
        List annotations = JDTUtils.getAnnotations((IMember)method);
        boolean hasWebResultAnn = false;
        if (mode == 2) {
            for (Annotation an : annotations) {
                if (!an.getTypeName().getFullyQualifiedName().equals(WebResult.class.getSimpleName())) continue;
                WebResultAnnInfo resultAnn = new WebResultAnnInfo(an);
                if (resultAnn.getTargetNamespace() == null) {
                    resultAnn.setTargetNamespace(this.targetNamespace);
                }
                this.createOneField(wrapperClsType, method.getReturnType(), resultAnn.getName(), resultAnn.getTargetNamespace());
                hasWebResultAnn = true;
                break;
            }
        }
        String[] paraTypes = method.getParameterTypes();
        String[] paraNames = method.getParameterNames();
        int i = 0;
        while (i < paraNames.length) {
            WebParamAnnInfo webParamAnn = JaxBindTypeGenerator.getWebParamAnnotation(method, paraNames[i]);
            if (webParamAnn == null) {
                LOG.debug((Object)("missing @WebParam annotation for method:" + method.getElementName()));
                webParamAnn = this.createDefaultWebParam(paraNames[i], i);
            }
            if (!(mode == 1 && webParamAnn.getMode() == WebParam.Mode.OUT || mode == 2 && webParamAnn.getMode() == WebParam.Mode.IN)) {
                String paramName = webParamAnn.getName();
                if (paramName == null || paramName.equals("")) {
                    paramName = paraNames[i];
                }
                if (webParamAnn.getTargetNamespace() == null || webParamAnn.getTargetNamespace().equals("")) {
                    webParamAnn.setTargetNamespace(this.targetNamespace);
                }
                this.createOneField(wrapperClsType, paraTypes[i], paramName, webParamAnn.getTargetNamespace());
            }
            ++i;
        }
        if (mode == 2 && !hasWebResultAnn && !(typeString = Signature.getSignatureSimpleName((String)method.getReturnType())).toLowerCase().startsWith("void")) {
            WebResultAnnInfo resultAnn = this.createDefaultWebResult();
            LOG.debug((Object)("create default WebResult:" + resultAnn.getName()));
            this.createOneField(wrapperClsType, method.getReturnType(), resultAnn.getName(), resultAnn.getTargetNamespace());
        }
    }

    private WebResultAnnInfo createDefaultWebResult() {
        WebResultAnnInfo webResult = new WebResultAnnInfo();
        webResult.setName("return");
        webResult.setTargetNamespace(this.targetNamespace);
        return webResult;
    }

    private WebParamAnnInfo createDefaultWebParam(String paramName, int index) {
        LOG.debug((Object)("create default WebParam for parameter:" + paramName));
        WebParamAnnInfo annInfo = new WebParamAnnInfo();
        annInfo.setName(DEFAULT_ARG_PREFIX + index);
        annInfo.setTargetNamespace(this.targetNamespace);
        annInfo.setMode(WebParam.Mode.IN);
        return annInfo;
    }

    private void createOneField(IType wrapperClsType, String typeSignature, String paramName, String tns) throws Exception {
        if (paramName.equals("return")) {
            this.xmlTypeList.add("_" + paramName);
        } else {
            this.xmlTypeList.add(paramName);
        }
        String fieldDesc = Modifier.ModifierKeyword.PROTECTED_KEYWORD.toString();
        String typeString = Signature.getSignatureSimpleName((String)typeSignature);
        fieldDesc = String.valueOf(fieldDesc) + " " + typeString + " ";
        fieldDesc = paramName.equals("return") ? String.valueOf(fieldDesc) + "_" + paramName + ";" : String.valueOf(fieldDesc) + paramName + ";";
        LOG.debug((Object)("fielDesc:" + fieldDesc));
        IField field = wrapperClsType.createField(fieldDesc, null, true, null);
        CompilationUnit astRoot = this.createAstTree(wrapperClsType.getCompilationUnit());
        FieldDeclaration fieldDeclaration = JDTUtils.getFieldDeclaration((CompilationUnit)astRoot, (IField)field);
        LOG.debug((Object)("fieldDeclaration:" + fieldDeclaration));
        Type type = fieldDeclaration.getType();
        if (fieldDeclaration != null && type != null && !type.isPrimitiveType()) {
            String pkg;
            String importTypeStr = typeString;
            if (importTypeStr.indexOf("<") > 0) {
                importTypeStr = importTypeStr.substring(0, importTypeStr.indexOf("<"));
            }
            if (importTypeStr.indexOf("[]") > 0) {
                importTypeStr = importTypeStr.substring(0, importTypeStr.indexOf("[]"));
            }
            if ((pkg = Signature.getSignatureQualifier((String)typeSignature)).indexOf(".") < 0) {
                pkg = this.getPackageNameForClassType(this.sei.getTypes()[0], importTypeStr);
            }
            if (pkg != null && !pkg.startsWith("java.lang")) {
                String importStat = String.valueOf(pkg) + "." + importTypeStr;
                LOG.debug((Object)("import stat to add:" + importStat));
                this.importList.add(importStat);
            }
        }
        NormalAnnotation annotation = JaxBindAnnotationUtils.newXmlElementAnnotation(astRoot, paramName, null, tns, null, type);
        this.addAnnotation(wrapperClsType.getCompilationUnit(), astRoot, (Annotation)annotation, (IMember)field);
        this.createGetterSetter(wrapperClsType, typeString, paramName);
    }

    private void addImport(ICompilationUnit unit) throws JavaModelException, MalformedTreeException, BadLocationException {
        CompilationUnit astRoot = this.createAstTree(unit);
        for (String importStat : this.importList) {
            this.addImport(unit, astRoot, importStat);
        }
    }

    private boolean isClsDefined(String pkg, String type) {
        String clsName = pkg.equals("") ? type : String.valueOf(pkg) + "." + type;
        try {
            Class<?> cls = Class.forName(clsName);
            if (cls != null) {
                return true;
            }
        }
        finally {
            return false;
        }
    }

    private String getPackageNameForClassType(IType wrapperClsType, String type) throws JavaModelException {
        IImportDeclaration[] imports;
        if (this.isClsDefined("java.lang", type)) {
            return "java.lang";
        }
        IImportDeclaration[] iImportDeclarationArray = imports = wrapperClsType.getCompilationUnit().getImports();
        int n = imports.length;
        int n2 = 0;
        while (n2 < n) {
            IImportDeclaration importDesc = iImportDeclarationArray[n2];
            String importStat = importDesc.getElementName();
            if (importStat.endsWith(".*")) {
                String pkg = importStat.substring(0, importStat.lastIndexOf("."));
                if (this.isClsDefined(pkg, type)) {
                    return pkg;
                }
            } else if (importStat.endsWith(type)) {
                return importStat.substring(0, importStat.lastIndexOf("."));
            }
            ++n2;
        }
        if (this.pkgFragment.getCompilationUnit(String.valueOf(type) + ".java") != null) {
            return wrapperClsType.getPackageFragment().getElementName();
        }
        return null;
    }

    private void createGetterSetter(IType wrapperClsType, String type, String param) throws JavaModelException {
        String upperName = Character.toString(param.charAt(0)).toUpperCase();
        upperName = String.valueOf(upperName) + param.substring(1);
        StringBuffer sb = new StringBuffer();
        sb.append("public ");
        sb.append(type);
        sb.append(" get");
        sb.append(upperName);
        sb.append("(){");
        sb.append(LINE_SEPARATOR);
        sb.append("    return ");
        if (param.equals("return")) {
            sb.append("_" + param);
        } else {
            sb.append(param);
        }
        sb.append(";");
        sb.append(LINE_SEPARATOR);
        sb.append("}");
        sb.append(LINE_SEPARATOR);
        wrapperClsType.createMethod(sb.toString(), null, true, null);
        sb = new StringBuffer();
        sb.append("public void set").append(upperName).append("(").append(type).append(" value){").append(LINE_SEPARATOR).append("    this.");
        if (param.equals("return")) {
            sb.append("_" + param);
        } else {
            sb.append(param);
        }
        sb.append(" = value;").append(LINE_SEPARATOR).append("}").append(LINE_SEPARATOR);
        wrapperClsType.createMethod(sb.toString(), null, true, null);
    }

    private void addImport(ICompilationUnit unit, CompilationUnit astRoot, String importStat) throws JavaModelException, MalformedTreeException, BadLocationException {
        String source = unit.getBuffer().getContents();
        Document document = new Document(source);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        JDTUtils.addImport((CompilationUnit)astRoot, (String)importStat, (ASTRewrite)rewrite);
        TextEdit edits = rewrite.rewriteAST((IDocument)document, unit.getJavaProject().getOptions(true));
        edits.apply((IDocument)document);
        String newSource = document.get();
        unit.getBuffer().setContents(newSource);
    }

    private void addAnnotation(ICompilationUnit unit, CompilationUnit astRoot, Annotation annotation, IMember member) throws JavaModelException, MalformedTreeException, BadLocationException {
        String source = unit.getBuffer().getContents();
        Document document = new Document(source);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        if (member instanceof IField) {
            ScJDTUtils.addAnnotationOnField((CompilationUnit)astRoot, (Annotation)annotation, (IField)((IField)member), (ASTRewrite)rewrite);
        } else if (member instanceof IMethod) {
            ScJDTUtils.addAnnotationOnMethod((CompilationUnit)astRoot, (Annotation)annotation, (IMethod)((IMethod)member), (ASTRewrite)rewrite, (boolean)true);
        } else if (member instanceof IType) {
            ScJDTUtils.addAnnotationOnType((CompilationUnit)astRoot, (Annotation)annotation, (IType)((IType)member), (ASTRewrite)rewrite, (boolean)true);
        }
        TextEdit edits = rewrite.rewriteAST((IDocument)document, unit.getJavaProject().getOptions(true));
        edits.apply((IDocument)document);
        String newSource = document.get();
        unit.getBuffer().setContents(newSource);
    }

    public static WebParamAnnInfo getWebParamAnnotation(IMethod method, String parameterName) {
        List annList = JDTUtils.getParameterAnnotations((CompilationUnit)JDTUtils.getDomRootCompilationUnit((IMember)method), (IMethod)method, (String)parameterName);
        if (annList == null || annList.size() == 0) {
            return null;
        }
        for (Annotation an : annList) {
            String name = an.getTypeName().getFullyQualifiedName();
            if (!name.equals(WebParam.class.getSimpleName())) continue;
            return new WebParamAnnInfo(an);
        }
        return null;
    }
}

