/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.internal.wizards;

import java.util.HashSet;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.internal.viewers.StpRuntimeComposite;
import org.eclipse.stp.sc.jaxws.ScJaxWsResources;
import org.eclipse.stp.sc.jaxws.wizards.StartingPointWizardPage;
import org.eclipse.stp.sc.jaxws.wizards.WebServiceProjectWizard;
import org.eclipse.stp.sc.jaxws.wizards.WsdlFirstProjectWizard;
import org.eclipse.stp.sc.jaxws.wizards.WsdlGenPage;
import org.eclipse.stp.sc.jaxws.wizards.WsdlSettingPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.server.core.IRuntime;

public class RuntimeSelectionPage
extends WizardPage {
    private static final LoggingProxy LOG = LoggingProxy.getlogger(RuntimeSelectionPage.class);
    public StpRuntimeComposite runtimeComp;
    protected IRuntime selectedRuntime = null;

    public RuntimeSelectionPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)1808);
        composite.setLayout((Layout)new GridLayout());
        String[] moduleTypes = new String[]{"stp.jaxws.component"};
        this.runtimeComp = new StpRuntimeComposite(composite, 0, new StpRuntimeComposite.SelectionListener(){

            public void runtimeSelected(IRuntime runtime) {
                LOG.debug((Object)("runtime selected:" + runtime.getId()));
                RuntimeSelectionPage.this.selectedRuntime = runtime;
                RuntimeSelectionPage.this.setPageComplete(RuntimeSelectionPage.this.validatePage());
                RuntimeSelectionPage.this.getWizard().getContainer().updateButtons();
            }
        }, moduleTypes);
        this.runtimeComp.setLayoutData((Object)new GridData(1808));
        this.setControl((Control)composite);
        if (this.runtimeComp.getRuntimeCount() == 1) {
            this.selectedRuntime = this.runtimeComp.selectRuntimeByIndex(0);
        } else {
            this.setPageComplete(false);
        }
    }

    public int getRuntimeCount() {
        return this.runtimeComp.getRuntimeCount();
    }

    public IWizardPage getNextPage() {
        if (this.getWizard() instanceof WsdlFirstProjectWizard) {
            WsdlGenPage genPage = (WsdlGenPage)this.getWizard().getPage("genPage");
            genPage.updateControl(this.selectedRuntime.getRuntimeType().getId());
            WsdlSettingPage wsdlPage = (WsdlSettingPage)this.getWizard().getPage("wsdlPage");
            return wsdlPage;
        }
        if (this.getWizard() instanceof WebServiceProjectWizard) {
            StartingPointWizardPage startPointPage = (StartingPointWizardPage)this.getWizard().getPage("startingPointPage");
            startPointPage.updateControl(this.selectedRuntime.getRuntimeType().getId());
        }
        return super.getNextPage();
    }

    public boolean validatePage() {
        this.setMessage(null);
        this.setErrorMessage(null);
        if (this.selectedRuntime == null) {
            this.setErrorMessage(ScJaxWsResources.getString("runtimepage.error.noruntime"));
            return false;
        }
        return this.validateRuntimeJavaFacet();
    }

    private boolean validateRuntimeJavaFacet() {
        String jreVersion = this.getJREVersion(JavaRuntime.getDefaultVMInstall());
        LOG.debug((Object)("default jre version:" + jreVersion));
        String javaFacetVersion = this.getJavaFacetVersion(jreVersion);
        IProjectFacet pf = ProjectFacetsManager.getProjectFacet((String)"jst.java");
        IProjectFacetVersion fv = pf.getVersion(javaFacetVersion);
        LOG.debug((Object)("java facet version:" + javaFacetVersion));
        HashSet<IProjectFacetVersion> fvs = new HashSet<IProjectFacetVersion>();
        fvs.add(fv);
        Set runtimes = RuntimeManager.getRuntimes(fvs);
        for (org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime : runtimes) {
            if (!runtime.getName().equals(this.selectedRuntime.getName())) continue;
            LOG.debug((Object)"the selected runtime has passed java facet checking");
            return true;
        }
        LOG.debug((Object)("selected runtime doesn't support java " + fv));
        this.setErrorMessage(String.valueOf(ScJaxWsResources.getString("runtimepage.error.javafacet")) + javaFacetVersion);
        return false;
    }

    private String getJavaFacetVersion(String jreVersion) {
        return String.valueOf(jreVersion.substring(2, 3)) + ".0";
    }

    private String getJREVersion(IVMInstall install) {
        LibraryLocation[] libraryLocations = JavaRuntime.getLibraryLocations((IVMInstall)install);
        if (libraryLocations != null) {
            String libname = "rt.jar";
            if (System.getProperty("os.name").equals("Mac OS X")) {
                libname = "classes.jar";
            }
            int k = 0;
            while (k < libraryLocations.length) {
                IPath path = libraryLocations[k].getSystemLibraryPath();
                String jarName = path.lastSegment();
                if (libname.equals(jarName)) {
                    try {
                        JarFile jarFile = new JarFile(path.toFile());
                        Manifest manifest = jarFile.getManifest();
                        Attributes attributes = manifest.getMainAttributes();
                        return attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                ++k;
            }
        }
        return null;
    }

    public boolean canFlipToNextPage() {
        if (this.selectedRuntime == null) {
            return false;
        }
        return super.canFlipToNextPage();
    }

    public String getRuntimeType() {
        return this.selectedRuntime.getRuntimeType().getId();
    }

    public String getRuntimeID() {
        return this.selectedRuntime.getId();
    }

    public void selectRuntimeByIndex(int index) {
        LOG.debug((Object)("set select runtime by index:" + index));
        this.selectedRuntime = this.runtimeComp.selectRuntimeByIndex(index);
        LOG.debug((Object)("result runtime:" + this.selectedRuntime));
    }
}

