/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.wizards;

import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.wizards.AbstractScWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class ScWizardDialog
extends WizardDialog {
    private static final LoggingProxy LOG = LoggingProxy.getlogger(ScWizardDialog.class);
    boolean isMovingForward = true;

    public ScWizardDialog(Shell parentShell, IWizard newWizard) {
        super(parentShell, newWizard);
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        try {
            if (this.getWizard().getStartingPage() instanceof AbstractScWizardPage) {
                AbstractScWizardPage startingCeltixPage = (AbstractScWizardPage)this.getCurrentPage();
                startingCeltixPage.initializeFromData(startingCeltixPage.getWizardData());
                startingCeltixPage.updatePageState();
            }
        }
        catch (Exception e) {
            LOG.debug((Object)"data model handling failed", (Throwable)e);
        }
        return control;
    }

    public void showPage(IWizardPage page) {
        try {
            AbstractScWizardPage currentCeltixPage;
            if (this.getCurrentPage() instanceof AbstractScWizardPage) {
                currentCeltixPage = (AbstractScWizardPage)this.getCurrentPage();
                currentCeltixPage.applyToData(currentCeltixPage.getWizardData());
                if (this.isMovingForward) {
                    page = this.getCurrentPage().getNextPage();
                }
            }
            super.showPage(page);
            page.getControl().forceFocus();
            if (this.getCurrentPage() instanceof AbstractScWizardPage) {
                currentCeltixPage = (AbstractScWizardPage)this.getCurrentPage();
                currentCeltixPage.initializeBeforeDisplay();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void backPressed() {
        this.isMovingForward = false;
        super.backPressed();
    }

    protected void nextPressed() {
        this.isMovingForward = true;
        super.nextPressed();
    }

    protected void finishPressed() {
        try {
            if (this.getCurrentPage() instanceof AbstractScWizardPage) {
                AbstractScWizardPage currentCeltixPage = (AbstractScWizardPage)this.getCurrentPage();
                currentCeltixPage.applyToData(currentCeltixPage.getWizardData());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.finishPressed();
    }
}

