/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.common.preferences;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.preference.StringButtonFieldEditor;
import org.eclipse.stp.sca.common.preferences.JFaceResources;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;

public class URLFieldEditor
extends StringButtonFieldEditor {
    public URLFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
        this.setEmptyStringAllowed(false);
        this.setChangeButtonText(org.eclipse.jface.resource.JFaceResources.getString((String)JFaceResources.URLFieldEditor_0));
        this.setErrorMessage(JFaceResources.URLFieldEditor_1);
    }

    protected boolean doCheckState() {
        String text = this.getTextControl().getText();
        if (text != null && text.length() > 0) {
            return new File(text).exists();
        }
        return true;
    }

    protected String changePressed() {
        File d;
        URL url = null;
        try {
            url = new URL(this.getTextControl().getText());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        File f = null;
        if (url != null && !(f = new File(url.getFile())).exists()) {
            f = null;
        }
        if ((d = this.getDirectory(f)) == null) {
            return null;
        }
        return d.getAbsolutePath();
    }

    private File getDirectory(File startingDirectory) {
        String dir;
        DirectoryDialog fileDialog = new DirectoryDialog(this.getShell(), 4096);
        if (startingDirectory != null) {
            fileDialog.setFilterPath(startingDirectory.getPath());
        }
        if ((dir = fileDialog.open()) != null && (dir = dir.trim()).length() > 0) {
            return new File(dir);
        }
        return null;
    }
}

