/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.diagram.customactions;

import java.util.Collection;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramCommandStack;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.stp.sca.diagram.edit.parts.ComponentComponentPropertyCompartmentEditPart;
import org.eclipse.stp.sca.diagram.edit.parts.ComponentComponentReferenceCompartmentEditPart;
import org.eclipse.stp.sca.diagram.edit.parts.ComponentComponentServiceCompartmentEditPart;
import org.eclipse.stp.sca.diagram.edit.parts.ComponentEditPart;
import org.eclipse.stp.sca.diagram.edit.parts.CompositeCompositeAreaCompartmentEditPart;
import org.eclipse.stp.sca.diagram.edit.parts.CompositeEditPart;
import org.eclipse.ui.IActionDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoSizeAction
extends Action
implements IActionDelegate {
    private ShapeNodeEditPart myPart;
    private static final int BASE_SHIFT_HEIGHT = 125;
    private static final int SHIFT_BETWEEN_SERVICES = 40;
    private static final int BASE_SHIFT_WIDTH = 180;
    private static final int SHIFT_BETWEEN_PROPERTIES = 40;

    public void run() {
        if (this.myPart != null) {
            if (this.myPart instanceof CompositeEditPart) {
                this.resize((CompositeEditPart)this.myPart);
            } else if (this.myPart instanceof ComponentEditPart) {
                this.resize((ComponentEditPart)this.myPart);
            }
        }
    }

    private void resize(CompositeEditPart compositeEditPart) {
        for (Object o : compositeEditPart.getChildren()) {
            if (!(o instanceof CompositeCompositeAreaCompartmentEditPart)) continue;
            for (Object oo : ((CompositeCompositeAreaCompartmentEditPart)((Object)o)).getChildren()) {
                if (!(oo instanceof ComponentEditPart)) continue;
                this.resize((ComponentEditPart)((Object)oo));
            }
        }
    }

    private Collection<?> resize(ComponentEditPart componentEditPart) {
        ChangeBoundsRequest resizeRequest = new ChangeBoundsRequest((Object)"resize");
        resizeRequest.setEditParts((EditPart)componentEditPart);
        resizeRequest.setSizeDelta(new Dimension(this.computeDeltaWidth(componentEditPart, componentEditPart.getSize().width), this.computeDeltaHeight(componentEditPart, componentEditPart.getSize().height)));
        CompoundCommand cmd = new CompoundCommand("Resize");
        cmd.add(componentEditPart.getCommand((Request)resizeRequest));
        componentEditPart.getDiagramEditDomain().getDiagramCommandStack().execute((Command)cmd);
        return DiagramCommandStack.getReturnValues((Command)cmd);
    }

    private int computeDeltaWidth(ComponentEditPart componentEditPart, int oldWidth) {
        int properties = 0;
        for (Object o : componentEditPart.getChildren()) {
            if (!(o instanceof ComponentComponentPropertyCompartmentEditPart)) continue;
            properties = ((ComponentComponentPropertyCompartmentEditPart)((Object)o)).getChildren().size();
        }
        if (--properties < 0) {
            properties = 0;
        }
        return -oldWidth + properties * 40 + 180;
    }

    private int computeDeltaHeight(ComponentEditPart componentEditPart, int oldHeight) {
        int service = 0;
        int reference = 0;
        for (Object o : componentEditPart.getChildren()) {
            if (o instanceof ComponentComponentServiceCompartmentEditPart) {
                service = ((ComponentComponentServiceCompartmentEditPart)((Object)o)).getChildren().size();
                continue;
            }
            if (!(o instanceof ComponentComponentReferenceCompartmentEditPart)) continue;
            reference = ((ComponentComponentReferenceCompartmentEditPart)((Object)o)).getChildren().size();
        }
        int max = Math.max(service, reference);
        if (max >= 1) {
            --max;
        }
        return -oldHeight + max * 40 + 125;
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection iss;
        if (selection instanceof IStructuredSelection && (iss = (IStructuredSelection)selection).getFirstElement() instanceof ShapeNodeEditPart) {
            this.myPart = (ShapeNodeEditPart)iss.getFirstElement();
        }
    }
}

