/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.diagram.edit.parts;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Routing;
import org.eclipse.gmf.runtime.notation.RoutingStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.stp.sca.ComponentReference;
import org.eclipse.stp.sca.Wire;
import org.eclipse.stp.sca.diagram.edit.parts.ComponentReferenceEditPart;
import org.eclipse.stp.sca.diagram.edit.parts.ComponentServiceEditPart;
import org.eclipse.stp.sca.diagram.edit.policies.WireItemSemanticEditPolicy;
import org.eclipse.stp.sca.diagram.router.lib.ConnectionLayerExEx;
import org.eclipse.stp.sca.diagram.router.lib.RefConnectionAnchorLeft;
import org.eclipse.stp.sca.diagram.router.lib.RefConnectionAnchorRight;
import org.eclipse.stp.sca.diagram.router.lib.SCAPolylineConnectionEx;

public class WireEditPart
extends ConnectionNodeEditPart {
    public static final int VISUAL_ID = 3003;
    private ConnectionRouter rectilinearRouter = null;

    public WireEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new WireItemSemanticEditPolicy());
    }

    protected Connection createConnectionFigure() {
        return new WireFigure();
    }

    protected ConnectionAnchor getSourceConnectionAnchor() {
        return new RefConnectionAnchorLeft(((ComponentReferenceEditPart)this.getSource()).getFigure());
    }

    protected ConnectionAnchor getTargetConnectionAnchor() {
        return new RefConnectionAnchorRight(((ComponentServiceEditPart)this.getTarget()).getFigure());
    }

    public WireFigure getPrimaryShape() {
        return (WireFigure)this.getFigure();
    }

    protected void installRouter() {
        ConnectionLayer cLayer = (ConnectionLayer)this.getLayer("Connection Layer");
        RoutingStyle style = (RoutingStyle)((View)this.getModel()).getStyle(NotationPackage.Literals.ROUTING_STYLE);
        if (style != null && cLayer instanceof ConnectionLayerExEx) {
            ConnectionLayerExEx cLayerEx = (ConnectionLayerExEx)cLayer;
            if (Routing.RECTILINEAR_LITERAL == style.getRouting()) {
                if (this.rectilinearRouter == null) {
                    this.rectilinearRouter = cLayerEx.getScaWireEdgeRectilinearRouter();
                }
                this.getConnectionFigure().setConnectionRouter(this.rectilinearRouter);
                ((WireFigure)this.getFigure()).setRouterIsRectilinear(true);
                this.refreshRouterChange();
                return;
            }
        }
        ((WireFigure)this.getFigure()).setRouterIsRectilinear(false);
        super.installRouter();
    }

    protected void refreshVisuals() {
        Wire wire;
        EObject eObj = this.resolveSemanticElement();
        if (eObj != null && eObj instanceof Wire && (wire = (Wire)eObj).getSource() != null && wire.getSource2() != null) {
            if (wire.getSource2().isAutowire()) {
                this.getConnectionFigure().setForegroundColor(ColorConstants.red);
            } else {
                this.getConnectionFigure().setForegroundColor(ColorConstants.black);
            }
            this.refreshSourceAnchor();
            this.refreshTargetAnchor();
            super.refreshVisuals();
        }
    }

    public class WireFigure
    extends SCAPolylineConnectionEx {
        WireFigure() {
            this.setForegroundColor(ColorConstants.black);
        }

        public boolean isConditional() {
            ComponentReference src;
            EObject object = WireEditPart.this.getNotationView().getElement();
            return object instanceof Wire && (src = ((Wire)object).getSource2()) != null;
        }
    }
}

