/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.deploy.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.IConfigurablePackage;
import org.eclipse.stp.soas.deploy.core.IConfigurablePackageExtension;
import org.eclipse.stp.soas.deploy.core.IDeployTarget;
import org.eclipse.stp.soas.deploy.core.IPackage;
import org.eclipse.stp.soas.deploy.core.IPackageConfiguration;
import org.eclipse.stp.soas.deploy.core.IPackageExtension;
import org.eclipse.stp.soas.deploy.core.IPhysicalPackage;
import org.eclipse.stp.soas.deploy.core.IPhysicalPackageExtension;
import org.eclipse.stp.soas.deploy.core.IServiceDescriptor;
import org.eclipse.stp.soas.deploy.core.IServiceDescriptorExtension;
import org.eclipse.stp.soas.deploy.core.Utilities;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployConfiguration;
import org.eclipse.stp.soas.internal.deploy.ui.properties.DeployOutputFolderPropertyPage;

public class DeployPackageManager {
    public static final QualifiedName sPackageExtensionPropertyKey = new QualifiedName(DeployCorePlugin.getDefault().getBundle().getSymbolicName(), "packageExtensionID");
    Map mIdToLogicalExtension;
    SortedSet mLogicalExtensionByFileExtension;
    Map mIdToConfigurableExtension;
    SortedSet mConfigurableExtensionByFileExtension;
    Map mIdToPhysicalExtension;
    Map mPhysicalExtensionByFileExtension;

    public boolean isPackage(IFile file) {
        return this.getPackageExtension(file) != null;
    }

    public boolean isLogicalPackage(IFile file) {
        return this.getLogicalPackageExtension(file) != null;
    }

    public boolean isConfigurablePackage(IFile file) {
        return this.getConfigurablePackageExtension(file) != null;
    }

    public boolean isPhysicalPackage(IFile file) {
        return this.getPhysicalPackageExtension(file) != null;
    }

    public IPackage getPackage(IFile file) {
        IPackage pkg;
        IPackageExtension ipe = this.getPackageExtension(file);
        if (ipe == null) {
            pkg = null;
        } else if (ipe instanceof IConfigurablePackageExtension) {
            pkg = ((IConfigurablePackageExtension)ipe).adaptFile(file);
        } else if (ipe instanceof IServiceDescriptorExtension) {
            pkg = ((IServiceDescriptorExtension)ipe).adaptFile(file);
        } else if (ipe instanceof IPhysicalPackageExtension) {
            pkg = ((IPhysicalPackageExtension)ipe).adaptFile(file);
        } else {
            if (DeployCorePlugin.getDefault().isDebugging()) {
                System.err.println(DeployCorePlugin.getDefault().getResourceString("DeploymentExtensionManager.trace.error.unknownPackageExtension", new Object[]{ipe.getClass()}));
            }
            pkg = null;
        }
        return pkg;
    }

    public IPhysicalPackage getPhysicalPackage(IFile file) {
        IPackage pkg = this.getPackage(file);
        if (pkg != null && pkg instanceof IPhysicalPackage) {
            return (IPhysicalPackage)pkg;
        }
        return null;
    }

    public IFolder getOutputFolder(IServiceDescriptor pkg, DeployConfiguration deployConfig) {
        Path outputFolderPath;
        IWorkspaceRoot wsRoot = pkg.getFile().getWorkspace().getRoot();
        IDeployTarget target = Utilities.adaptToIDeployTarget((EObject)deployConfig);
        IPackageConfiguration pkgConfig = this.getPackageConfiguration(pkg, deployConfig);
        if (pkgConfig == null) {
            IFile pkgFile = pkg.getFile();
            IPath pkgFilePath = pkgFile.getProjectRelativePath();
            outputFolderPath = new Path(DeployOutputFolderPropertyPage.getOutputContainerPath(pkgFile.getProject()));
            outputFolderPath = outputFolderPath.append(pkgFilePath);
            outputFolderPath = outputFolderPath.append(target.getServer().getName());
        } else {
            IFile deployFile = wsRoot.getFile(new Path(deployConfig.eResource().getURI().path()).removeFirstSegments(1));
            outputFolderPath = new Path(DeployOutputFolderPropertyPage.getOutputContainerPath(deployFile.getProject()));
            outputFolderPath = outputFolderPath.append(deployFile.getProjectRelativePath());
            outputFolderPath = outputFolderPath.append(target.getServer().getName());
        }
        return wsRoot.getFolder((IPath)outputFolderPath);
    }

    public IFolder getOutputFolder(IServiceDescriptor pkg, String conName) {
        IFile pkgFile = pkg.getFile();
        IPath pkgFilePath = pkgFile.getProjectRelativePath();
        Path outputFolderPath = new Path(DeployOutputFolderPropertyPage.getOutputContainerPath(pkgFile.getProject()));
        outputFolderPath = outputFolderPath.append(pkgFilePath);
        outputFolderPath = outputFolderPath.append(conName);
        return pkgFile.getWorkspace().getRoot().getFolder((IPath)outputFolderPath);
    }

    private IPackageConfiguration getPackageConfiguration(IServiceDescriptor ilp, DeployConfiguration deployConfig) {
        IPackageConfiguration retVal;
        byte[] configData = deployConfig.getConfigOverride();
        if (ilp instanceof IConfigurablePackage) {
            if (configData == null || configData.length == 0) {
                retVal = null;
            } else {
                ByteArrayInputStream bais = new ByteArrayInputStream(configData);
                try {
                    try {
                        retVal = ((IConfigurablePackageExtension)ilp.getExtension()).getPackageConfigurationManager().createPackageConfiguration(ilp, bais);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        retVal = ((IConfigurablePackageExtension)ilp.getExtension()).getPackageConfigurationManager().createPackageConfiguration(ilp);
                        try {
                            bais.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                finally {
                    try {
                        bais.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        } else {
            if (configData != null && configData.length == 0) {
                System.err.println(DeployCorePlugin.getDefault().getResourceString("CreateDeployPackagesJob.error.configurationSpecifiedForLogicalPackage"));
            }
            retVal = null;
        }
        return retVal;
    }

    public IConfigurablePackage getConfigurablePackage(IFile file) {
        IPackage pkg = this.getPackage(file);
        if (pkg != null && pkg instanceof IConfigurablePackage) {
            return (IConfigurablePackage)pkg;
        }
        return null;
    }

    public IServiceDescriptor getLogicalPackage(IFile file) {
        IPackage pkg = this.getPackage(file);
        if (pkg != null && pkg instanceof IServiceDescriptor) {
            return (IServiceDescriptor)pkg;
        }
        return null;
    }

    public IPackageExtension getPackageExtension(IFile file) {
        IPackageExtension ipe = this.getConfigurablePackageExtension(file);
        if (ipe == null && (ipe = this.getLogicalPackageExtension(file)) == null) {
            ipe = this.getPhysicalPackageExtension(file);
        }
        return ipe;
    }

    public IServiceDescriptorExtension getLogicalPackageExtension(IFile file) {
        IServiceDescriptorExtension ilpe = null;
        String extensionID = null;
        try {
            extensionID = file.getPersistentProperty(sPackageExtensionPropertyKey);
            if (extensionID != null) {
                ilpe = this.getLogicalPackageExtension(extensionID);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (ilpe == null) {
            String fileExt = file.getFileExtension();
            if (fileExt != null) {
                List extensions = this.getLogicalExtensions(fileExt);
                Iterator it = extensions.iterator();
                while (ilpe == null && it.hasNext()) {
                    IServiceDescriptorExtension extension = (IServiceDescriptorExtension)it.next();
                    if (!extension.supportsFile(file)) continue;
                    ilpe = extension;
                }
            }
            if (ilpe != null && extensionID == null) {
                try {
                    file.setPersistentProperty(sPackageExtensionPropertyKey, ilpe.getID());
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        }
        return ilpe;
    }

    public IConfigurablePackageExtension getConfigurablePackageExtension(IFile file) {
        IConfigurablePackageExtension icpe = null;
        String extensionID = null;
        try {
            extensionID = file.getPersistentProperty(sPackageExtensionPropertyKey);
            if (extensionID != null) {
                icpe = this.getConfigurablePackageExtension(extensionID);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (icpe == null) {
            String fileExt = file.getFileExtension();
            if (fileExt != null) {
                List extensions = this.getConfigurableExtensions(fileExt);
                Iterator it = extensions.iterator();
                while (icpe == null && it.hasNext()) {
                    IConfigurablePackageExtension extension = (IConfigurablePackageExtension)it.next();
                    if (!extension.supportsFile(file)) continue;
                    icpe = extension;
                }
            }
            if (icpe != null && extensionID == null) {
                try {
                    file.setPersistentProperty(sPackageExtensionPropertyKey, icpe.getID());
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        }
        return icpe;
    }

    public IPhysicalPackageExtension getPhysicalPackageExtension(IFile file) {
        IPhysicalPackageExtension ippe = null;
        String extensionID = null;
        try {
            extensionID = file.getPersistentProperty(sPackageExtensionPropertyKey);
            if (extensionID != null) {
                ippe = this.getPhysicalPackageExtension(extensionID);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (ippe == null) {
            String fileExt = file.getFileExtension();
            List extensions = this.getPhysicalPackageExtensions(fileExt);
            Iterator it = extensions.iterator();
            while (ippe == null && it.hasNext()) {
                IPhysicalPackageExtension extension = (IPhysicalPackageExtension)it.next();
                if (!extension.supportsFile(file)) continue;
                ippe = extension;
            }
            if (ippe != null) {
                try {
                    file.setPersistentProperty(sPackageExtensionPropertyKey, ippe.getID());
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        }
        return ippe;
    }

    public IServiceDescriptorExtension getLogicalPackageExtension(String id) {
        IServiceDescriptorExtension ilpe = id == null || !this.mIdToLogicalExtension.containsKey(id) ? null : (IServiceDescriptorExtension)this.mIdToLogicalExtension.get(id);
        return ilpe;
    }

    public List getLogicalExtensions(String fileExtension) {
        return new ArrayList(this.mLogicalExtensionByFileExtension.subSet(fileExtension, String.valueOf(fileExtension) + '\u0000'));
    }

    public IConfigurablePackageExtension getConfigurablePackageExtension(String id) {
        IConfigurablePackageExtension icpe = id == null || !this.mIdToLogicalExtension.containsKey(id) ? null : (IConfigurablePackageExtension)this.mIdToConfigurableExtension.get(id);
        return icpe;
    }

    public List getConfigurableExtensions(String fileExtension) {
        return new ArrayList(this.mConfigurableExtensionByFileExtension.subSet(fileExtension, String.valueOf(fileExtension) + '\u0000'));
    }

    public IPhysicalPackageExtension getPhysicalPackageExtension(String id) {
        IPhysicalPackageExtension ippe = id == null || !this.mIdToPhysicalExtension.containsKey(id) ? null : (IPhysicalPackageExtension)this.mIdToPhysicalExtension.get(id);
        return ippe;
    }

    public List getPhysicalPackageExtensions(String fileExtension) {
        List retVal = fileExtension == null ? new ArrayList() : (this.mPhysicalExtensionByFileExtension.containsKey(fileExtension) ? (List)this.mPhysicalExtensionByFileExtension.get(fileExtension) : new ArrayList());
        return retVal;
    }
}

