/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.deploy.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.Assert;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.internal.model.RuntimeCore;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.DeployPackageManager;
import org.eclipse.stp.soas.deploy.core.IPackageConstructorExtension;
import org.eclipse.stp.soas.deploy.core.IPackageExtension;
import org.eclipse.stp.soas.deploy.core.IRuntimeDefinition;
import org.eclipse.stp.soas.deploy.core.IServerDefinition;
import org.eclipse.stp.soas.deploy.core.IServerType;
import org.eclipse.stp.soas.deploy.core.IServiceDescriptor;
import org.eclipse.stp.soas.deploy.core.ITechnologyDefinition;
import org.eclipse.stp.soas.internal.deploy.core.ConfigurablePackageExtension;
import org.eclipse.stp.soas.internal.deploy.core.PackageConstructorExtension;
import org.eclipse.stp.soas.internal.deploy.core.PackageExtensionException;
import org.eclipse.stp.soas.internal.deploy.core.PhysicalPackageExtension;
import org.eclipse.stp.soas.internal.deploy.core.RuntimeDefinition;
import org.eclipse.stp.soas.internal.deploy.core.ServerDefinition;
import org.eclipse.stp.soas.internal.deploy.core.ServiceDescriptorExtension;
import org.eclipse.stp.soas.internal.deploy.core.TechnologyDefinition;
import org.eclipse.stp.soas.internal.deploy.core.TechnologyMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentExtensionManager
extends DeployPackageManager {
    private static final LoggingProxy LOG = LoggingProxy.getlogger(DeploymentExtensionManager.class);
    public static final String EXTENSION_ID = "deploymentExtension";
    public static final String EXT_ELEM_LOGICAL_PACKAGE = "serviceDescriptor";
    public static final String EXT_ELEM_CONFIGURABLE_PACKAGE = "configurablePackage";
    public static final String EXT_ELEM_PHYSICAL_PACKAGE = "physicalPackage";
    public static final String EXT_ELEM_DEPLOY_DRIVER = "deployDriver";
    public static final String EXT_ELEM_SUPPORTED_SERVER = "supportedServer";
    public static final String EXT_ELEM_SUPPORTED_RUNTIME = "supportedRuntime";
    public static final String EXT_ELEM_SUPPORTED_TECHNOLOGY = "supportedTechnology";
    public static final String EXT_ELEM_TECHNOLOGY_DEFINITION = "technologyDefinition";
    public static final String EXT_ELEM_SERVER_DEFINITION = "serverDefinition";
    public static final String EXT_ELEM_TECHNOLOGY_MAP = "technologyMap";
    public static final String EXT_ELEM_PACKAGE_CONSTRUCTOR = "packageConstructor";
    public static final String EXT_POINT_WTP_MODULETYPE = "org.eclipse.wst.server.core.moduleTypes";
    public static final String EXT_POINT_WTP_SERVERTYPE = "org.eclipse.wst.server.core.serverTypes";
    public static final String EXT_POINT_WTP_RUNTIMETYPE = "org.eclipse.wst.server.core.runtimeTypes";
    public static boolean DEBUG_DEPLOYMENT_EXTENSION = true;
    private static final String OPTION_DEBUG_DEPLOYMENT_EXTENSION = "org.eclipse.stp.soas.deploy.core/deploymentextension";
    private static DeploymentExtensionManager sInstance;
    private Map mTechnologyDefsByID;
    private Map mServerDefsByID;
    private Map mRuntimeDefsByID;
    private Map mIdToConstructor;

    public static DeploymentExtensionManager getInstance() {
        if (sInstance == null) {
            String debug = Platform.getDebugOption((String)OPTION_DEBUG_DEPLOYMENT_EXTENSION);
            DEBUG_DEPLOYMENT_EXTENSION = debug == null ? false : debug.equalsIgnoreCase("true");
            sInstance = new DeploymentExtensionManager();
            sInstance.init();
        }
        return sInstance;
    }

    private DeploymentExtensionManager() {
    }

    public ITechnologyDefinition getTechnologyDefinition(String type) {
        ITechnologyDefinition itd = type == null || !this.mTechnologyDefsByID.containsKey(type) ? null : (ITechnologyDefinition)this.mTechnologyDefsByID.get(type);
        return itd;
    }

    public IServerDefinition getServerDefinition(String type) {
        IServerDefinition isd = type == null || !this.mServerDefsByID.containsKey(type) ? null : (IServerDefinition)this.mServerDefsByID.get(type);
        return isd;
    }

    public List<IRuntimeDefinition> getRuntimeDefinitionByType(String type) {
        ArrayList<IRuntimeDefinition> isd = new ArrayList<IRuntimeDefinition>();
        for (String rdId : this.mRuntimeDefsByID.keySet()) {
            String rdIdWithoutVersion = RuntimeCore.getRuntimeIdWithoutVersion((String)rdId);
            if (!type.equals(rdIdWithoutVersion)) continue;
            isd.add((IRuntimeDefinition)this.mRuntimeDefsByID.get(rdId));
        }
        if (type != null && this.mRuntimeDefsByID.containsKey(type)) {
            isd.add((IRuntimeDefinition)this.mRuntimeDefsByID.get(type));
        }
        return isd;
    }

    public IRuntimeDefinition getRuntimeDefinition(String id) {
        IRuntimeDefinition ird = id == null || !this.mRuntimeDefsByID.containsKey(id) ? null : (IRuntimeDefinition)this.mRuntimeDefsByID.get(id);
        return ird;
    }

    public List getPackageConstructors() {
        return new ArrayList(this.mIdToConstructor.values());
    }

    public IPackageConstructorExtension getPackageConstructor(IServiceDescriptor pkg, IServerType serverType) {
        List constructors = this.getPackageConstructors();
        for (IPackageConstructorExtension pce : constructors) {
            if (!pce.supportsPackage(pkg) || !pce.supportsServer(serverType)) continue;
            return pce;
        }
        return null;
    }

    public List getPackageConstructor(IServiceDescriptor pkg) {
        ArrayList<IPackageConstructorExtension> lstPce = new ArrayList<IPackageConstructorExtension>();
        List constructors = this.getPackageConstructors();
        for (IPackageConstructorExtension pce : constructors) {
            if (!pce.supportsPackage(pkg)) continue;
            lstPce.add(pce);
        }
        return lstPce;
    }

    private void init() {
        this.mTechnologyDefsByID = new TreeMap();
        this.mServerDefsByID = new TreeMap();
        this.mIdToLogicalExtension = new TreeMap(new IDComparator());
        this.mLogicalExtensionByFileExtension = new TreeSet(new FileExtensionComparator());
        this.mIdToConfigurableExtension = new TreeMap(new IDComparator());
        this.mConfigurableExtensionByFileExtension = new TreeSet(new FileExtensionComparator());
        this.mIdToPhysicalExtension = new TreeMap(new IDComparator());
        this.mPhysicalExtensionByFileExtension = new HashMap();
        this.mRuntimeDefsByID = new TreeMap();
        this.mIdToConstructor = new TreeMap();
        this.processWtpExtensions();
        this.processExtensions();
    }

    private void processWtpExtensions() {
        IExtension[] runtimeExts;
        int n;
        IExtension[] serverExts;
        int n2;
        IExtension[] moduleExts;
        ArrayList<IConfigurationElement> technologyDefs = new ArrayList<IConfigurationElement>();
        IExtensionPoint moduleTypePoint = Platform.getExtensionRegistry().getExtensionPoint(EXT_POINT_WTP_MODULETYPE);
        IExtension[] iExtensionArray = moduleExts = moduleTypePoint.getExtensions();
        int n3 = moduleExts.length;
        int n4 = 0;
        while (n4 < n3) {
            IExtension moduleExt = iExtensionArray[n4];
            IConfigurationElement[] iConfigurationElementArray = moduleExt.getConfigurationElements();
            int n5 = iConfigurationElementArray.length;
            n2 = 0;
            while (n2 < n5) {
                IConfigurationElement elem = iConfigurationElementArray[n2];
                technologyDefs.add(elem);
                ++n2;
            }
            ++n4;
        }
        this.processTechnologyDefs(technologyDefs);
        ArrayList<IConfigurationElement> serverDefs = new ArrayList<IConfigurationElement>();
        IExtensionPoint serverTypePoint = Platform.getExtensionRegistry().getExtensionPoint(EXT_POINT_WTP_SERVERTYPE);
        IExtension[] iExtensionArray2 = serverExts = serverTypePoint.getExtensions();
        n2 = serverExts.length;
        int elem = 0;
        while (elem < n2) {
            IExtension serverExt = iExtensionArray2[elem];
            IConfigurationElement[] iConfigurationElementArray = serverExt.getConfigurationElements();
            int n6 = iConfigurationElementArray.length;
            n = 0;
            while (n < n6) {
                IConfigurationElement elem2 = iConfigurationElementArray[n];
                serverDefs.add(elem2);
                ++n;
            }
            ++elem;
        }
        this.processServerDefs(serverDefs);
        ArrayList<IConfigurationElement> runtimeDefs = new ArrayList<IConfigurationElement>();
        IExtensionPoint runtimeTypePoint = Platform.getExtensionRegistry().getExtensionPoint(EXT_POINT_WTP_RUNTIMETYPE);
        IExtension[] iExtensionArray3 = runtimeExts = runtimeTypePoint.getExtensions();
        n = runtimeExts.length;
        int n7 = 0;
        while (n7 < n) {
            IExtension runtimeExt = iExtensionArray3[n7];
            IConfigurationElement[] iConfigurationElementArray = runtimeExt.getConfigurationElements();
            int n8 = iConfigurationElementArray.length;
            int n9 = 0;
            while (n9 < n8) {
                IConfigurationElement elem3 = iConfigurationElementArray[n9];
                runtimeDefs.add(elem3);
                ++n9;
            }
            ++n7;
        }
        this.processRuntimeDefs(runtimeDefs);
    }

    private void processExtensions() {
        IExtensionPoint exp = Platform.getExtensionRegistry().getExtensionPoint(DeployCorePlugin.getDefault().getBundle().getSymbolicName(), EXTENSION_ID);
        IExtension[] exts = exp.getExtensions();
        ArrayList<IConfigurationElement> logicalPackages = new ArrayList<IConfigurationElement>();
        ArrayList<IConfigurationElement> configurablePackages = new ArrayList<IConfigurationElement>();
        ArrayList<IConfigurationElement> physicalPackages = new ArrayList<IConfigurationElement>();
        ArrayList<IConfigurationElement> deployDrivers = new ArrayList<IConfigurationElement>();
        ArrayList<IConfigurationElement> technologyDefs = new ArrayList<IConfigurationElement>();
        ArrayList<IConfigurationElement> serverDefs = new ArrayList<IConfigurationElement>();
        ArrayList<IConfigurationElement> technologyMaps = new ArrayList<IConfigurationElement>();
        ArrayList<IConfigurationElement> constructors = new ArrayList<IConfigurationElement>();
        for (IExtension ext : Arrays.asList(exts)) {
            IConfigurationElement[] elems = ext.getConfigurationElements();
            for (IConfigurationElement elem : Arrays.asList(elems)) {
                String elemName = elem.getName();
                if (EXT_ELEM_LOGICAL_PACKAGE.equals(elemName)) {
                    logicalPackages.add(elem);
                    continue;
                }
                if (EXT_ELEM_CONFIGURABLE_PACKAGE.equals(elemName)) {
                    configurablePackages.add(elem);
                    continue;
                }
                if (EXT_ELEM_PHYSICAL_PACKAGE.equals(elemName)) {
                    physicalPackages.add(elem);
                    continue;
                }
                if (EXT_ELEM_DEPLOY_DRIVER.equals(elemName)) {
                    deployDrivers.add(elem);
                    continue;
                }
                if (EXT_ELEM_TECHNOLOGY_DEFINITION.equals(elemName)) {
                    technologyDefs.add(elem);
                    continue;
                }
                if (EXT_ELEM_SERVER_DEFINITION.equals(elemName)) {
                    serverDefs.add(elem);
                    continue;
                }
                if (EXT_ELEM_TECHNOLOGY_MAP.equals(elemName)) {
                    technologyMaps.add(elem);
                    continue;
                }
                if (EXT_ELEM_PACKAGE_CONSTRUCTOR.equals(elemName)) {
                    constructors.add(elem);
                    continue;
                }
                if (!DEBUG_DEPLOYMENT_EXTENSION) continue;
                System.err.println(DeployCorePlugin.getDefault().getResourceString("DeploymentExtensionManager.trace.error.unknownElement", new Object[]{elemName, ext.getContributor().getName()}));
                System.err.flush();
            }
        }
        this.processTechnologyDefs(technologyDefs);
        this.processServerDefs(serverDefs);
        this.processTechnologyMaps(technologyMaps);
        this.processLogicalPackages(logicalPackages);
        this.processConfigurablePackages(configurablePackages);
        this.processPhysicalPackages(physicalPackages);
        this.processPackageConstructors(constructors);
    }

    private void processPackageConstructors(Collection constructors) {
        Iterator it = constructors.iterator();
        while (it.hasNext()) {
            this.processPackageConstructor((IConfigurationElement)it.next());
        }
    }

    private void processPackageConstructor(IConfigurationElement element) {
        block2: {
            try {
                PackageConstructorExtension de = new PackageConstructorExtension(element);
                Assert.isTrue((!this.mIdToConstructor.containsKey(de.getID()) ? 1 : 0) != 0, (String)DeployCorePlugin.getDefault().getResourceString("DeploymentExtensionManager.assert.duplicatePackageConstructor", new Object[]{de.getID(), element.toString(), de.getID()}));
                this.mIdToConstructor.put(de.getID(), de);
            }
            catch (PackageExtensionException e) {
                if (!DEBUG_DEPLOYMENT_EXTENSION) break block2;
                System.err.println(DeployCorePlugin.getDefault().getResourceString("DeploymentExtensionManager.trace.error.packageConstructorParseError", new Object[]{element.getAttribute("id"), element.getDeclaringExtension().getContributor().getName()}));
                e.printStackTrace();
                System.err.flush();
            }
        }
    }

    private void processTechnologyDefs(Collection elements) {
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            this.processTechnologyDef((IConfigurationElement)it.next());
        }
    }

    private void processTechnologyDef(IConfigurationElement element) {
        try {
            TechnologyDefinition itd = new TechnologyDefinition(element);
            if (this.mTechnologyDefsByID.containsKey(itd.getID())) {
                throw new PackageExtensionException(DeployCorePlugin.getDefault().getResourceString("DeploymentExtensionManager.exception.duplicateTechnologyDefinitionId"));
            }
            this.mTechnologyDefsByID.put(itd.getID(), itd);
        }
        catch (PackageExtensionException e) {
            LOG.error((Object)DeployCorePlugin.getDefault().getResourceString("DeploymentExtensionManager.trace.error.technologyDefinitionParseError", new Object[]{element.getAttribute("id"), element.getDeclaringExtension().getContributor().getName()}));
        }
    }

    private void processServerDefs(Collection elements) {
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            this.processServerDef((IConfigurationElement)it.next());
        }
    }

    private void processServerDef(IConfigurationElement element) {
        block3: {
            try {
                ServerDefinition isd = new ServerDefinition(element);
                if (this.mServerDefsByID.containsKey(isd.getID())) {
                    throw new PackageExtensionException(DeployCorePlugin.getDefault().getResourceString("DeploymentExtensionManager.exception.duplicateServerDefinitionId"));
                }
                this.mServerDefsByID.put(isd.getID(), isd);
            }
            catch (PackageExtensionException e) {
                if (!DEBUG_DEPLOYMENT_EXTENSION) break block3;
                System.err.println(DeployCorePlugin.getDefault().getResourceString("DeploymentExtensionManager.trace.error.serverDefinitionParseError", new Object[]{element.getAttribute("id"), element.getDeclaringExtension().getContributor().getName()}));
                e.printStackTrace();
                System.err.flush();
            }
        }
    }

    private void processRuntimeDefs(Collection elements) {
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            this.processRuntimeDef((IConfigurationElement)it.next());
        }
    }

    private void processRuntimeDef(IConfigurationElement element) {
        block3: {
            try {
                RuntimeDefinition isd = new RuntimeDefinition(element);
                if (this.mRuntimeDefsByID.containsKey(isd.getID())) {
                    throw new PackageExtensionException(DeployCorePlugin.getDefault().getResourceString("DeploymentExtensionManager.exception.duplicateRuntimeDefinitionId"));
                }
                this.mRuntimeDefsByID.put(isd.getID(), isd);
            }
            catch (PackageExtensionException e) {
                if (!DEBUG_DEPLOYMENT_EXTENSION) break block3;
                System.err.println(DeployCorePlugin.getDefault().getResourceString("DeploymentExtensionManager.trace.error.serverDefinitionParseError", new Object[]{element.getAttribute("id"), element.getDeclaringExtension().getContributor().getName()}));
                e.printStackTrace();
                System.err.flush();
            }
        }
    }

    private void processTechnologyMaps(Collection elements) {
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            this.processTechnologyMap((IConfigurationElement)it.next());
        }
    }

    private void processTechnologyMap(IConfigurationElement element) {
        block2: {
            try {
                new TechnologyMap(element);
            }
            catch (PackageExtensionException e) {
                if (!DEBUG_DEPLOYMENT_EXTENSION) break block2;
                System.err.println(DeployCorePlugin.getDefault().getResourceString("DeploymentExtensionManager.trace.error.technologyMapParseError", new Object[]{element.getDeclaringExtension().getContributor().getName()}));
                e.printStackTrace();
                System.err.flush();
            }
        }
    }

    private void processLogicalPackages(Collection elements) {
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            this.processLogicalPackage((IConfigurationElement)it.next());
        }
    }

    private void processLogicalPackage(IConfigurationElement element) {
        block3: {
            try {
                ServiceDescriptorExtension lpp = new ServiceDescriptorExtension(element);
                if (this.mIdToLogicalExtension.containsKey(lpp.getID())) {
                    throw new PackageExtensionException(DeployCorePlugin.getDefault().getResourceString("DeploymentExtensionManager.exception.duplicateLogicalPackageId"));
                }
                this.mIdToLogicalExtension.put(lpp.getID(), lpp);
                this.mLogicalExtensionByFileExtension.add(lpp);
            }
            catch (PackageExtensionException e) {
                if (!DEBUG_DEPLOYMENT_EXTENSION) break block3;
                System.err.println(DeployCorePlugin.getDefault().getResourceString("DeploymentExtensionManager.trace.error.logicalPackageParseError", new Object[]{element.getAttribute("id"), element.getDeclaringExtension().getContributor().getName()}));
                e.printStackTrace();
                System.err.flush();
            }
        }
    }

    private void processConfigurablePackages(Collection elements) {
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            this.processConfigurablePackage((IConfigurationElement)it.next());
        }
    }

    private void processConfigurablePackage(IConfigurationElement element) {
        block3: {
            try {
                ConfigurablePackageExtension cpe = new ConfigurablePackageExtension(element);
                if (this.mIdToConfigurableExtension.containsKey(cpe.getID())) {
                    throw new PackageExtensionException(DeployCorePlugin.getDefault().getResourceString("DeploymentExtensionManager.exception.duplicateConfigurablePackageId"));
                }
                this.mIdToConfigurableExtension.put(cpe.getID(), cpe);
                this.mConfigurableExtensionByFileExtension.add(cpe);
            }
            catch (PackageExtensionException e) {
                if (!DEBUG_DEPLOYMENT_EXTENSION) break block3;
                System.err.println(DeployCorePlugin.getDefault().getResourceString("DeploymentExtensionManager.trace.error.configurablePackageParseError", new Object[]{element.getAttribute("id"), element.getDeclaringExtension().getContributor().getName()}));
                e.printStackTrace();
                System.err.flush();
            }
        }
    }

    private void processPhysicalPackages(Collection elements) {
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            this.processPhysicalPackage((IConfigurationElement)it.next());
        }
    }

    private void processPhysicalPackage(IConfigurationElement element) {
        block5: {
            try {
                PhysicalPackageExtension ppp = new PhysicalPackageExtension(element);
                if (this.mIdToPhysicalExtension.containsKey(ppp.getID())) {
                    throw new PackageExtensionException(DeployCorePlugin.getDefault().getResourceString("DeploymentExtensionManager.exception.duplicatePhysicalPackageId"));
                }
                this.mIdToPhysicalExtension.put(ppp.getID(), ppp);
                List<PhysicalPackageExtension> pkgExts = null;
                if (this.mPhysicalExtensionByFileExtension.containsKey(ppp.getFileExtension())) {
                    pkgExts = (List)this.mPhysicalExtensionByFileExtension.get(ppp.getFileExtension());
                    pkgExts.add(ppp);
                } else {
                    pkgExts = new ArrayList<PhysicalPackageExtension>();
                    pkgExts.add(ppp);
                    this.mPhysicalExtensionByFileExtension.put(ppp.getFileExtension(), pkgExts);
                }
            }
            catch (PackageExtensionException e) {
                if (!DEBUG_DEPLOYMENT_EXTENSION) break block5;
                System.err.println(DeployCorePlugin.getDefault().getResourceString("DeploymentExtensionManager.trace.error.physicalPackageParseError", new Object[]{element.getAttribute("id"), element.getDeclaringExtension().getContributor().getName()}));
                e.printStackTrace();
                System.err.flush();
            }
        }
    }

    private static class FileExtensionComparator
    implements Comparator {
        private FileExtensionComparator() {
        }

        public int compare(Object o1, Object o2) {
            int retVal;
            if (o1 instanceof String) {
                String s1 = (String)o1;
                String s2 = o2 instanceof String ? (String)o2 : ((IPackageExtension)o2).getFileExtension();
                retVal = s1.compareTo(s2);
            } else if (o2 instanceof String) {
                String s2 = (String)o2;
                String s1 = o1 instanceof String ? (String)o1 : ((IPackageExtension)o1).getFileExtension();
                retVal = s1.compareTo(s2);
            } else {
                IPackageExtension ipe1 = (IPackageExtension)o1;
                IPackageExtension ipe2 = (IPackageExtension)o2;
                retVal = ipe1.getFileExtension().compareTo(ipe2.getFileExtension());
                if (retVal == 0) {
                    retVal = ipe1.getID().compareTo(ipe2.getID());
                }
            }
            return retVal;
        }
    }

    private static class IDComparator
    implements Comparator {
        private IDComparator() {
        }

        public int compare(Object o1, Object o2) {
            String s1 = o1 instanceof String ? (String)o1 : ((IPackageExtension)o1).getID();
            String s2 = o2 instanceof String ? (String)o2 : ((IPackageExtension)o2).getID();
            return s1.compareTo(s2);
        }
    }
}

