/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.deploy.core;

import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.DeploymentExtensionManager;
import org.eclipse.stp.soas.deploy.core.IRuntimeDefinition;
import org.eclipse.stp.soas.deploy.core.IRuntimeType;
import org.eclipse.stp.soas.deploy.core.IVersion;

public class RuntimeType
implements IRuntimeType {
    private String mRuntimeDef;
    private IVersion mVersion;

    public RuntimeType(String runtimeDef, IVersion version) {
        if (DeploymentExtensionManager.getInstance().getRuntimeDefinition(runtimeDef) == null) {
            throw new IllegalArgumentException(DeployCorePlugin.getDefault().getResourceString("RuntimeType.exception.serverDefinitionDoesNotExist", new Object[]{runtimeDef}));
        }
        this.mRuntimeDef = runtimeDef;
        this.mVersion = version;
    }

    public IRuntimeDefinition getRuntimeDefinition() {
        return DeploymentExtensionManager.getInstance().getRuntimeDefinition(this.mRuntimeDef);
    }

    public IVersion getVersion() {
        return this.mVersion;
    }

    public String toString() {
        return DeployCorePlugin.getDefault().getResourceString("RuntimeType.toString", new Object[]{this.mRuntimeDef, this.mVersion});
    }

    public boolean equals(Object obj) {
        boolean retVal;
        if (this == obj) {
            retVal = true;
        } else if (obj instanceof RuntimeType) {
            RuntimeType st = (RuntimeType)obj;
            retVal = this.mRuntimeDef.equals(st.mRuntimeDef) && this.mVersion.equals(st.mVersion);
        } else {
            retVal = false;
        }
        return retVal;
    }

    public int hashCode() {
        return this.mRuntimeDef.hashCode();
    }
}

