/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.deploy.core.operations;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.DeploymentExtensionManager;
import org.eclipse.stp.soas.deploy.core.FilePackageOutputDescriptor;
import org.eclipse.stp.soas.deploy.core.IConfigurablePackage;
import org.eclipse.stp.soas.deploy.core.IConfigurablePackageExtension;
import org.eclipse.stp.soas.deploy.core.IPackage;
import org.eclipse.stp.soas.deploy.core.IPackageConfiguration;
import org.eclipse.stp.soas.deploy.core.IPackageConstructorExtension;
import org.eclipse.stp.soas.deploy.core.IPackageCreationContext;
import org.eclipse.stp.soas.deploy.core.IPackageOutputDescriptor;
import org.eclipse.stp.soas.deploy.core.IPhysicalPackage;
import org.eclipse.stp.soas.deploy.core.IServerType;
import org.eclipse.stp.soas.deploy.core.IServiceDescriptor;
import org.eclipse.stp.soas.deploy.core.Utilities;
import org.eclipse.stp.soas.deploy.core.utils.DeploymentUtil;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployConfiguration;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployPackage;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployServer;
import org.eclipse.stp.soas.deploy.models.deployfile.Root;
import org.eclipse.stp.soas.internal.deploy.core.PackageCreationContext;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;

public class CreateDeployPackagesJob
extends Job {
    private IFile mDeployFile;
    private Root mRoot;
    private File mTempFolder;
    private PackageCreationContext.OverwriteCancelQuery mOverwriteCancelQuery;
    private Map mTargetToPackageDescriptorMap;
    private Map mLogicalPackageToPackageDescriptorMap;

    public CreateDeployPackagesJob(Root root) {
        super(DeployCorePlugin.getDefault().getResourceString("CreateDeployPackagesJob.task.name"));
        this.mRoot = root;
        this.mOverwriteCancelQuery = new PackageCreationContext.OverwriteCancelQuery();
        this.mTargetToPackageDescriptorMap = new HashMap();
        this.mLogicalPackageToPackageDescriptorMap = new HashMap();
        URI uri = this.mRoot.eResource().getURI();
        if ("platform".equals(uri.scheme())) {
            try {
                URL url = FileLocator.toFileURL((URL)new URL(uri.scheme(), uri.authority(), uri.path()));
                uri = URI.createFileURI((String)url.getFile());
            }
            catch (Exception e) {
                throw new RuntimeException(String.valueOf(DeployCorePlugin.getDefault().getResourceString("CreateDeployPackagesJob.error.runtime.fileNotFound")) + uri.toString(), e);
            }
        }
        this.mDeployFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(uri.toFileString()));
        this.setRule((ISchedulingRule)this.mDeployFile.getWorkspace().getRoot());
        this.setUser(true);
        this.setSystem(false);
    }

    public IStatus run(IProgressMonitor monitor) {
        IStatus status;
        block7: {
            monitor.beginTask(DeployCorePlugin.getDefault().getResourceString("CreateDeployPackagesJob.task.name"), this.getBuildCount() * 100 + 600);
            status = Status.OK_STATUS;
            try {
                this.buildWorkspace(monitor);
                this.checkCancelled(monitor);
                this.checkForErrors(monitor);
                this.checkCancelled(monitor);
                this.createPackages(monitor);
                this.refreshWorkspace(monitor);
            }
            catch (InterruptedException e) {
                status = Status.CANCEL_STATUS;
                this.deleteTempFolders();
                break block7;
            }
            catch (CoreException e) {
                try {
                    status = e.getStatus();
                    break block7;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.deleteTempFolders();
                }
            }
            this.deleteTempFolders();
        }
        monitor.done();
        return status;
    }

    public Map getPackageDescriptors() {
        return this.mTargetToPackageDescriptorMap;
    }

    private void deleteTempFolders() {
        if (this.mTempFolder != null && this.mTempFolder.isDirectory()) {
            this.deleteTempFile(this.mTempFolder);
            this.mTempFolder = null;
        }
    }

    private void checkCancelled(IProgressMonitor monitor) throws InterruptedException {
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
    }

    private void buildWorkspace(IProgressMonitor monitor) throws CoreException {
        SubProgressMonitor buildMonitor = new SubProgressMonitor(monitor, 400);
        monitor.subTask(DeployCorePlugin.getDefault().getResourceString("CreateDeployPackagesJob.subtask.buildWorkspace"));
        this.mDeployFile.getWorkspace().build(10, (IProgressMonitor)buildMonitor);
        buildMonitor.done();
    }

    private void checkForErrors(IProgressMonitor monitor) throws CoreException {
        monitor.subTask(DeployCorePlugin.getDefault().getResourceString("CreateDeployPackagesJob.subtask.errorCheck"));
        if (this.mDeployFile.exists()) {
            for (IMarker marker : Arrays.asList(this.mDeployFile.findMarkers("org.eclipse.core.resources.problemmarker", true, 0))) {
                int severity = marker.getAttribute("severity", 0);
                if (2 != severity) continue;
                String exceptionMessage = DeployCorePlugin.getDefault().getResourceString("CreateDeployPackagesJob.error.errorsFound");
                Status status = new Status(4, DeployCorePlugin.getDefault().getBundle().getSymbolicName(), -1, DeployCorePlugin.getDefault().getResourceString("CreateDeployPackagesJob.error.log.message"), (Throwable)new Exception(exceptionMessage));
                throw new CoreException((IStatus)new MultiStatus(DeployCorePlugin.getDefault().getBundle().getSymbolicName(), -1, new IStatus[]{status}, DeployCorePlugin.getDefault().getResourceString("CreateDeployPackagesJob.message.log.buildPackage"), null));
            }
        } else {
            MultiStatus status;
            IServiceDescriptor ilp;
            IPackageConstructorExtension ipce;
            IStatus[] validateStatus;
            DeployPackage dp = (DeployPackage)this.mRoot.getPackage().get(0);
            IPackage ip = Utilities.adaptToIPackage((EObject)dp);
            if (ip instanceof IServiceDescriptor && (validateStatus = (ipce = this.getPackageConstructor(ilp = (IServiceDescriptor)ip, (DeployConfiguration)dp.getTargetConfiguration().get(0))).validatePackage(ilp, null, null)) != null && validateStatus.length > 0 && (status = new MultiStatus(DeployCorePlugin.getDefault().getBundle().getSymbolicName(), -1, validateStatus, DeployCorePlugin.getDefault().getResourceString("CreateDeployPackagesJob.message.log.buildPackage"), null)).getSeverity() == 4) {
                throw new CoreException((IStatus)status);
            }
        }
        monitor.worked(100);
    }

    private void createPackages(IProgressMonitor monitor) throws CoreException, InterruptedException {
        ArrayList<MultiStatus> errors = new ArrayList<MultiStatus>();
        try {
            try {
                monitor.subTask(DeployCorePlugin.getDefault().getResourceString("CreateDeployPackagesJob.subtask.createWorkingFolders"));
                this.createTempFolders();
                monitor.worked(100);
                for (DeployPackage deployPackage : this.mRoot.getPackage()) {
                    IPackage ip = Utilities.adaptToIPackage((EObject)deployPackage);
                    if (ip instanceof IServiceDescriptor) {
                        IServiceDescriptor ilp = (IServiceDescriptor)ip;
                        for (DeployConfiguration deployConfig : deployPackage.getTargetConfiguration()) {
                            monitor.subTask(DeployCorePlugin.getDefault().getResourceString("CreateDeployPackagesJob.subtask.buildPackageForDeployment", new Object[]{deployConfig.getSourcePackage().getPackageFile(), deployConfig.getTargetServer().getProfileName()}));
                            IPackageConfiguration config = this.getPackageConfiguration(ilp, deployConfig);
                            LogicalPackageConfigurationKey key = new LogicalPackageConfigurationKey(ilp, deployConfig.getTargetServer());
                            if (this.mLogicalPackageToPackageDescriptorMap.containsKey(key)) {
                                this.mTargetToPackageDescriptorMap.put(deployConfig, this.mLogicalPackageToPackageDescriptorMap.get(key));
                                continue;
                            }
                            IPackageCreationContext context = this.createPackageCreationContext(ilp, deployConfig);
                            IPackageConstructorExtension ipc = this.getPackageConstructor(ilp, deployConfig);
                            try {
                                try {
                                    List<IPackageOutputDescriptor> ipods = ipc.createPackage(ilp, context, config);
                                    this.mTargetToPackageDescriptorMap.put(deployConfig, ipods);
                                    this.mLogicalPackageToPackageDescriptorMap.put(key, ipods);
                                }
                                catch (CoreException e) {
                                    if (e.getStatus().getSeverity() == 8) {
                                        throw new InterruptedException();
                                    }
                                    MultiStatus status = new MultiStatus(DeployCorePlugin.getDefault().getBundle().getSymbolicName(), -1, DeployCorePlugin.getDefault().getResourceString("CreateDeployPackagesJob.error.createPackageFailed", new Object[]{ilp.getFile().getFullPath(), deployConfig.getTargetServer().getProfileName()}), (Throwable)e);
                                    status.add(e.getStatus());
                                    errors.add(status);
                                    monitor.worked(100);
                                    this.checkCancelled(monitor);
                                    continue;
                                }
                            }
                            catch (Throwable throwable) {
                                monitor.worked(100);
                                this.checkCancelled(monitor);
                                throw throwable;
                            }
                            monitor.worked(100);
                            this.checkCancelled(monitor);
                        }
                        continue;
                    }
                    File packageFile = ip.getFile().getLocation().toFile();
                    FilePackageOutputDescriptor ipod = new FilePackageOutputDescriptor(packageFile, null, ((IPhysicalPackage)ip).getServerType(), packageFile.toString(), ip.getName());
                    for (DeployConfiguration deployConfig : deployPackage.getTargetConfiguration()) {
                        monitor.subTask(DeployCorePlugin.getDefault().getResourceString("CreateDeployPackagesJob.subtask.processingPackage", new Object[]{ip.getName(), deployConfig.getTargetServer().getProfileName()}));
                        ArrayList<FilePackageOutputDescriptor> ipods = new ArrayList<FilePackageOutputDescriptor>();
                        ipods.add(ipod);
                        this.mTargetToPackageDescriptorMap.put(deployConfig, ipods);
                        monitor.worked(100);
                        this.checkCancelled(monitor);
                    }
                }
            }
            catch (IOException e) {
                Status status = new Status(4, DeployCorePlugin.getDefault().getBundle().getSymbolicName(), -1, DeployCorePlugin.getDefault().getResourceString("CreateDeployPackagesJob.error.log.message"), (Throwable)e);
                MultiStatus mutiStatus = new MultiStatus(DeployCorePlugin.getDefault().getBundle().getSymbolicName(), -1, new IStatus[]{status}, DeployCorePlugin.getDefault().getResourceString("CreateDeployPackagesJob.message.log.buildPackage"), null);
                throw new CoreException((IStatus)mutiStatus);
            }
        }
        finally {
            if (this.mTempFolder != null) {
                monitor.subTask(DeployCorePlugin.getDefault().getResourceString("CreateDeployPackagesJob.subtask.deleteWorkingFolders"));
                this.deleteTempFile(this.mTempFolder);
                monitor.worked(100);
            }
            if (errors.size() != 0) {
                MultiStatus mutiStatus = new MultiStatus(DeployCorePlugin.getDefault().getBundle().getSymbolicName(), -1, errors.toArray(new IStatus[errors.size()]), DeployCorePlugin.getDefault().getResourceString("CreateDeployPackagesJob.error.errorsOcurredCreatingPackages"), null);
                throw new CoreException((IStatus)mutiStatus);
            }
        }
    }

    private void refreshWorkspace(IProgressMonitor monitor) throws CoreException {
        monitor = new SubProgressMonitor(monitor, 100);
        this.mDeployFile.getWorkspace().getRoot().refreshLocal(2, monitor);
    }

    private void deleteTempFile(File file) {
        File[] files = file.listFiles();
        if (files != null && files.length > 0) {
            int index = 0;
            int count = files.length;
            while (index < count) {
                this.deleteTempFile(files[index]);
                ++index;
            }
        }
        file.delete();
    }

    private IPackageConfiguration getPackageConfiguration(IServiceDescriptor ilp, DeployConfiguration deployConfig) {
        IPackageConfiguration retVal;
        byte[] configData = deployConfig.getConfigOverride();
        if (ilp instanceof IConfigurablePackage) {
            if (configData == null || configData.length == 0) {
                retVal = null;
            } else {
                ByteArrayInputStream bais = new ByteArrayInputStream(configData);
                try {
                    try {
                        retVal = ((IConfigurablePackageExtension)ilp.getExtension()).getPackageConfigurationManager().createPackageConfiguration(ilp, bais);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        retVal = ((IConfigurablePackageExtension)ilp.getExtension()).getPackageConfigurationManager().createPackageConfiguration(ilp);
                        try {
                            bais.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                finally {
                    try {
                        bais.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        } else {
            if (configData != null && configData.length == 0) {
                System.err.println(DeployCorePlugin.getDefault().getResourceString("CreateDeployPackagesJob.error.configurationSpecifiedForLogicalPackage"));
            }
            retVal = null;
        }
        return retVal;
    }

    private IPackageConstructorExtension getPackageConstructor(IServiceDescriptor pkg, DeployConfiguration deployConfig) {
        IServer server = ServerCore.findServer((String)deployConfig.getTargetServer().getServerId());
        IServerType serverType = DeploymentUtil.convertWTPServerTypeToSTPServerType(server.getServerType());
        IPackageConstructorExtension pce = DeploymentExtensionManager.getInstance().getPackageConstructor(pkg, serverType);
        if (pce == null) {
            System.err.println(DeployCorePlugin.getDefault().getResourceString("CreateDeployPackagesJob.error.connectionProfileNotFound", new Object[]{deployConfig.getTargetServer().getProfileName()}));
        }
        return pce;
    }

    private IPackageCreationContext createPackageCreationContext(IServiceDescriptor ilp, DeployConfiguration deployConfig) {
        String childFolderName = deployConfig.getTargetServer().getProfileName();
        IServer target = Utilities.adaptToIServer((EObject)deployConfig);
        File outputFolder = this.createFolder(DeploymentExtensionManager.getInstance().getOutputFolder(ilp, deployConfig).getLocation().toFile());
        File tempFolder = this.createFolder(new File(new File(this.mTempFolder, childFolderName), ilp.getName()));
        if (target == null) {
            System.err.println(DeployCorePlugin.getDefault().getResourceString("CreateDeployPackagesJob.error.targetServerNotFound", new Object[]{deployConfig.getTargetServer().getProfileName()}));
        }
        return new PackageCreationContext(target, outputFolder, tempFolder, this.mOverwriteCancelQuery);
    }

    private File createFolder(File folder) {
        if (!folder.exists()) {
            folder.mkdirs();
        }
        return folder;
    }

    private void createTempFolders() throws IOException {
        File tmpFile = File.createTempFile("deploy_temp", ".tmp");
        tmpFile.deleteOnExit();
        this.mTempFolder = new File(tmpFile.getParentFile(), tmpFile.getName().substring(0, tmpFile.getName().lastIndexOf(".tmp")));
        this.mTempFolder.mkdir();
        this.mTempFolder.deleteOnExit();
    }

    private int getBuildCount() {
        int retVal = 2;
        Iterator it = this.mRoot.getPackage().iterator();
        while (it.hasNext()) {
            retVal += ((DeployPackage)it.next()).getTargetConfiguration().size();
        }
        return retVal;
    }

    private static class LogicalPackageConfigurationKey {
        private IServiceDescriptor mLogicalPackage;
        private DeployServer mServer;

        public LogicalPackageConfigurationKey(IServiceDescriptor ilp, DeployServer server) {
            this.mLogicalPackage = ilp;
            this.mServer = server;
        }

        public boolean equals(Object obj) {
            if (obj instanceof LogicalPackageConfigurationKey) {
                LogicalPackageConfigurationKey other = (LogicalPackageConfigurationKey)obj;
                return this.mLogicalPackage.equals(other.mLogicalPackage) && (this.mServer != null && this.mServer.equals(other.mServer) || this.mServer == null && other.mServer == null);
            }
            return false;
        }

        public int hashCode() {
            return this.mLogicalPackage.hashCode();
        }
    }
}

